/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viafabricplus.protocoltranslator.util;

import com.google.gson.JsonObject;
import com.viaversion.viafabricplus.save.AbstractSave;
import com.viaversion.vialoader.util.ProtocolVersionList;
import com.viaversion.viaversion.api.protocol.version.ProtocolVersion;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import net.minecraft.class_124;
import net.minecraft.class_639;
import net.minecraft.class_8592;

public final class ProtocolVersionDetector {
    private static final int TIMEOUT = 3000;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ProtocolVersion get(class_639 serverAddress, InetSocketAddress socketAddress, ProtocolVersion clientVersion) throws Exception {
        try (Socket socket = new Socket(serverAddress.method_2952(), serverAddress.method_2954());
             DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());
             DataInputStream dataInputStream = new DataInputStream(socket.getInputStream());
             ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
             DataOutputStream handshakePacket = new DataOutputStream(byteArrayOutputStream);){
            ProtocolVersion protocol;
            socket.setTcpNoDelay(true);
            socket.setSoTimeout(3000);
            handshakePacket.writeByte(0);
            ProtocolVersionDetector.writeVarInt(handshakePacket, clientVersion.getOriginalVersion());
            if (clientVersion.olderThanOrEqualTo(ProtocolVersion.v1_17)) {
                ProtocolVersionDetector.writeString(handshakePacket, serverAddress.method_2952());
                handshakePacket.writeShort(serverAddress.method_2954());
            } else {
                ProtocolVersionDetector.writeString(handshakePacket, socketAddress.getHostString());
                handshakePacket.writeShort(socketAddress.getPort());
            }
            ProtocolVersionDetector.writeVarInt(handshakePacket, class_8592.field_44974.method_52283());
            ProtocolVersionDetector.writeVarInt(dataOutputStream, byteArrayOutputStream.size());
            dataOutputStream.write(byteArrayOutputStream.toByteArray());
            dataOutputStream.writeByte(1);
            dataOutputStream.writeByte(0);
            int size = ProtocolVersionDetector.readVarInt(dataInputStream);
            if (size <= 0) {
                throw new IllegalStateException("Invalid packet size");
            }
            int id = ProtocolVersionDetector.readVarInt(dataInputStream);
            if (id != 0) {
                throw new IllegalStateException("Invalid packet ID");
            }
            String response = ProtocolVersionDetector.readString(dataInputStream);
            JsonObject object = (JsonObject)AbstractSave.GSON.fromJson(response, JsonObject.class);
            if (!object.has("version")) {
                throw new IllegalStateException("Invalid ping response");
            }
            JsonObject version = object.getAsJsonObject("version");
            if (!version.has("name")) throw new IllegalStateException("Invalid ping response");
            if (!version.has("protocol")) {
                throw new IllegalStateException("Invalid ping response");
            }
            int serverVersion = version.get("protocol").getAsInt();
            if (clientVersion.getOriginalVersion() == serverVersion) {
                ProtocolVersion protocolVersion = clientVersion;
                return protocolVersion;
            }
            if (ProtocolVersion.isRegistered((int)serverVersion)) {
                ProtocolVersion protocolVersion = ProtocolVersion.getProtocol((int)serverVersion);
                return protocolVersion;
            }
            String name = version.get("name").getAsString();
            Iterator iterator = ProtocolVersionList.getProtocolsNewToOld().iterator();
            block40: while (true) {
                String includedVersion;
                if (!iterator.hasNext()) throw new RuntimeException("Unable to detect the server version\nServer sent an invalid protocol id: " + String.valueOf(serverAddress) + " (" + name + String.valueOf(class_124.field_1070) + ")");
                protocol = (ProtocolVersion)iterator.next();
                Iterator iterator2 = protocol.getIncludedVersions().iterator();
                do {
                    if (!iterator2.hasNext()) continue block40;
                } while (!name.contains(includedVersion = (String)iterator2.next()));
                break;
            }
            ProtocolVersion protocolVersion = protocol;
            return protocolVersion;
        }
    }

    private static int readVarInt(DataInputStream in) throws IOException {
        byte b;
        int i = 0;
        int j = 0;
        do {
            b = in.readByte();
            i |= (b & 0x7F) << j++ * 7;
            if (j <= 5) continue;
            throw new IOException("Var int too big");
        } while ((b & 0x80) == 128);
        return i;
    }

    private static String readString(DataInputStream in) throws IOException {
        int length = ProtocolVersionDetector.readVarInt(in);
        if (length > 131068) {
            throw new IOException("Cannot receive string longer than Short.MAX_VALUE * 4 bytes (got " + length + " bytes)");
        }
        if (length < 0) {
            throw new IOException("Cannot receive string shorter than 0 bytes (got " + length + " bytes)");
        }
        byte[] bytes = new byte[length];
        in.readFully(bytes);
        String string = new String(bytes, StandardCharsets.UTF_8);
        if (string.length() > Short.MAX_VALUE) {
            throw new IOException("Cannot receive string longer than Short.MAX_VALUE characters (got " + string.length() + " bytes)");
        }
        return string;
    }

    private static void writeVarInt(DataOutputStream out, int value) throws IOException {
        while ((value & 0xFFFFFF80) != 0) {
            out.writeByte(value & 0x7F | 0x80);
            value >>>= 7;
        }
        out.writeByte(value);
    }

    private static void writeString(DataOutputStream out, String value) throws IOException {
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        ProtocolVersionDetector.writeVarInt(out, bytes.length);
        out.write(bytes);
    }
}

