/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viafabricplus;

import com.viaversion.viafabricplus.ViaFabricPlus;
import com.viaversion.viafabricplus.api.ViaFabricPlusBase;
import com.viaversion.viafabricplus.api.entrypoint.ViaFabricPlusLoadEntrypoint;
import com.viaversion.viafabricplus.api.events.ChangeProtocolVersionCallback;
import com.viaversion.viafabricplus.api.events.LoadingCycleCallback;
import com.viaversion.viafabricplus.api.settings.SettingGroup;
import com.viaversion.viafabricplus.base.Events;
import com.viaversion.viafabricplus.base.sync_tasks.SyncTasks;
import com.viaversion.viafabricplus.features.FeaturesLoading;
import com.viaversion.viafabricplus.features.item.filter_creative_tabs.VersionedRegistries;
import com.viaversion.viafabricplus.features.item.negative_item_count.NegativeItemUtil;
import com.viaversion.viafabricplus.features.limitation.max_chat_length.MaxChatLength;
import com.viaversion.viafabricplus.injection.access.base.IConnection;
import com.viaversion.viafabricplus.injection.access.base.IServerData;
import com.viaversion.viafabricplus.protocoltranslator.ProtocolTranslator;
import com.viaversion.viafabricplus.protocoltranslator.translator.ItemTranslator;
import com.viaversion.viafabricplus.save.SaveManager;
import com.viaversion.viafabricplus.screen.impl.ProtocolSelectionScreen;
import com.viaversion.viafabricplus.screen.impl.SettingsScreen;
import com.viaversion.viafabricplus.settings.SettingsManager;
import com.viaversion.viafabricplus.util.ChatUtil;
import com.viaversion.viafabricplus.util.ClassLoaderPriorityUtil;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.minecraft.item.Item;
import com.viaversion.viaversion.api.protocol.version.ProtocolVersion;
import io.netty.channel.Channel;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.entrypoint.EntrypointContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_1291;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_2535;
import net.minecraft.class_2561;
import net.minecraft.class_2582;
import net.minecraft.class_437;
import net.minecraft.class_5321;
import net.minecraft.class_642;
import net.minecraft.class_6880;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public final class ViaFabricPlusImpl
implements ViaFabricPlusBase {
    public static final ViaFabricPlusImpl INSTANCE = new ViaFabricPlusImpl();
    private final Logger logger = LogManager.getLogger((String)"ViaFabricPlus");
    private final Path path = FabricLoader.getInstance().getConfigDir().resolve("viafabricplus");
    private String version;
    private String implVersion;
    private CompletableFuture<Void> loadingFuture;

    public void init() {
        ViaFabricPlus.init((ViaFabricPlusBase)INSTANCE);
        ModMetadata metadata = ((ModContainer)FabricLoader.getInstance().getModContainer("viafabricplus").get()).getMetadata();
        this.version = metadata.getVersion().getFriendlyString();
        this.implVersion = metadata.getCustomValue("vfp:implVersion").getAsString();
        for (EntrypointContainer container : FabricLoader.getInstance().getEntrypointContainers("viafabricplus", ViaFabricPlusLoadEntrypoint.class)) {
            ((ViaFabricPlusLoadEntrypoint)container.getEntrypoint()).onPlatformLoad((ViaFabricPlusBase)INSTANCE);
        }
        try {
            Files.createDirectories(this.path, new FileAttribute[0]);
        }
        catch (IOException e) {
            this.logger.error("Failed to create ViaFabricPlus directory", (Throwable)e);
        }
        ClassLoaderPriorityUtil.loadOverridingJars(this.path, this.logger);
        SettingsManager.INSTANCE.init();
        SaveManager.INSTANCE.init();
        SyncTasks.init();
        FeaturesLoading.init();
        this.loadingFuture = ProtocolTranslator.init(this.path);
        Events.LOADING_CYCLE.register(cycle -> {
            if (cycle != LoadingCycleCallback.LoadingCycle.POST_GAME_LOAD) {
                return;
            }
            this.loadingFuture.join();
            FeaturesLoading.postInit();
            SaveManager.INSTANCE.postInit();
        });
        ((LoadingCycleCallback)Events.LOADING_CYCLE.invoker()).onLoadCycle(LoadingCycleCallback.LoadingCycle.FINAL_LOAD);
    }

    public String getVersion() {
        return this.version;
    }

    public String getImplVersion() {
        return this.implVersion;
    }

    public Path getPath() {
        return this.path;
    }

    @Nullable
    public ProtocolVersion getTargetVersion() {
        return ProtocolTranslator.getTargetVersion();
    }

    public void setTargetVersion(ProtocolVersion newVersion) {
        ProtocolTranslator.setTargetVersion(newVersion);
    }

    @Nullable
    public ProtocolVersion getTargetVersion(Channel channel) {
        return ProtocolTranslator.getTargetVersion(channel);
    }

    @Nullable
    public ProtocolVersion getTargetVersion(class_2535 connection) {
        return ((IConnection)connection).viaFabricPlus$getTargetVersion();
    }

    public void setTargetVersion(ProtocolVersion newVersion, boolean revertOnDisconnect) {
        ProtocolTranslator.setTargetVersion(newVersion, revertOnDisconnect);
    }

    @Nullable
    public UserConnection getPlayNetworkUserConnection() {
        return ProtocolTranslator.getPlayNetworkUserConnection();
    }

    @Nullable
    public UserConnection getUserConnection(class_2535 connection) {
        return ((IConnection)connection).viaFabricPlus$getUserConnection();
    }

    @Nullable
    public ProtocolVersion getServerVersion(class_642 serverInfo) {
        return ((IServerData)serverInfo).viaFabricPlus$forcedVersion();
    }

    public void registerOnChangeProtocolVersionCallback(ChangeProtocolVersionCallback callback) {
        Events.CHANGE_PROTOCOL_VERSION.register((Object)callback);
    }

    public void registerLoadingCycleCallback(LoadingCycleCallback callback) {
        Events.LOADING_CYCLE.register((Object)callback);
    }

    public int getMaxChatLength(ProtocolVersion version) {
        return MaxChatLength.getChatLength();
    }

    public List<SettingGroup> getSettingGroups() {
        return Collections.unmodifiableList(SettingsManager.INSTANCE.getGroups());
    }

    public void addSettingGroup(SettingGroup group) {
        SettingsManager.INSTANCE.addGroup(group);
    }

    @Nullable
    public SettingGroup getSettingGroup(String translationKey) {
        for (SettingGroup group : SettingsManager.INSTANCE.getGroups()) {
            if (!ChatUtil.uncoverTranslationKey((class_2561)group.getName()).equals(translationKey)) continue;
            return group;
        }
        return null;
    }

    public void openProtocolSelectionScreen(class_437 parent) {
        ProtocolSelectionScreen.INSTANCE.open(parent);
    }

    public void openSettingsScreen(class_437 parent) {
        SettingsScreen.INSTANCE.open(parent);
    }

    @Nullable
    public Item translateItem(class_1799 stack, ProtocolVersion targetVersion) {
        return ItemTranslator.mcToVia(stack, targetVersion);
    }

    @Nullable
    public class_1799 translateItem(Item item, ProtocolVersion sourceVersion) {
        return ItemTranslator.viaToMc(item, sourceVersion);
    }

    public boolean itemExists(class_1792 item, ProtocolVersion version) {
        return VersionedRegistries.containsItem(item, version);
    }

    public boolean enchantmentExists(class_5321<class_1887> enchantment, ProtocolVersion version) {
        return VersionedRegistries.containsEnchantment(enchantment, version);
    }

    public boolean effectExists(class_6880<class_1291> effect, ProtocolVersion version) {
        return VersionedRegistries.containsEffect(effect, version);
    }

    public boolean bannerPatternExists(class_5321<class_2582> pattern, ProtocolVersion version) {
        return VersionedRegistries.containsBannerPattern(pattern, version);
    }

    public boolean itemExistsInConnection(class_1792 item) {
        return VersionedRegistries.keepItem(item);
    }

    public boolean itemExistsInConnection(class_1799 stack) {
        return VersionedRegistries.keepItem(stack);
    }

    public int getStackCount(class_1799 stack) {
        return NegativeItemUtil.getCount(stack);
    }

    public Logger getLogger() {
        return this.logger;
    }
}

