/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.schematic.container;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.PrimitiveCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fi.dy.masa.litematica.schematic.container.ILitematicaBlockStatePalette;
import fi.dy.masa.litematica.schematic.container.ILitematicaBlockStatePaletteResizer;
import fi.dy.masa.litematica.schematic.container.LitematicaBlockStateContainer;
import fi.dy.masa.litematica.world.SchematicWorldHandler;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_3513;
import net.minecraft.class_7871;
import net.minecraft.class_7924;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public class LitematicaBlockStatePaletteHashMap
implements ILitematicaBlockStatePalette {
    public static final Codec<LitematicaBlockStatePaletteHashMap> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)PrimitiveCodec.INT.fieldOf("Bits").forGetter(get -> get.bits), (App)Codec.list((Codec)class_2680.field_24734).fieldOf("StatePalette").forGetter(LitematicaBlockStatePaletteHashMap::fromMapping)).apply((Applicative)inst, LitematicaBlockStatePaletteHashMap::new));
    public static final class_9139<ByteBuf, LitematicaBlockStatePaletteHashMap> PACKET_CODEC = new class_9139<ByteBuf, LitematicaBlockStatePaletteHashMap>(){

        public void encode(@Nonnull ByteBuf buf, LitematicaBlockStatePaletteHashMap value) {
            class_9135.field_49675.encode((Object)buf, (Object)value.bits);
            class_9135.field_49676.encode((Object)buf, (Object)value.writeToNBT());
        }

        @Nonnull
        public LitematicaBlockStatePaletteHashMap decode(@Nonnull ByteBuf buf) {
            Integer bitsIn = (Integer)class_9135.field_49675.decode((Object)buf);
            class_2520 nbt = (class_2520)class_9135.field_49676.decode((Object)buf);
            return new LitematicaBlockStatePaletteHashMap((int)bitsIn, (class_2499)nbt);
        }
    };
    private final class_3513<class_2680> statePaletteMap;
    private ILitematicaBlockStatePaletteResizer paletteResizer;
    private final int bits;

    public LitematicaBlockStatePaletteHashMap(int bitsIn, ILitematicaBlockStatePaletteResizer paletteResizer) {
        this.bits = bitsIn;
        this.paletteResizer = paletteResizer;
        this.statePaletteMap = class_3513.method_37913((int)(1 << bitsIn));
    }

    private LitematicaBlockStatePaletteHashMap(int bitsIn, List<class_2680> list) {
        this.bits = bitsIn;
        this.paletteResizer = null;
        this.statePaletteMap = class_3513.method_37913((int)(1 << bitsIn));
        this.setMapping(list);
    }

    private LitematicaBlockStatePaletteHashMap(int bitsIn, class_2499 list) {
        this.bits = bitsIn;
        this.paletteResizer = null;
        this.statePaletteMap = class_3513.method_37913((int)(1 << bitsIn));
        this.readFromNBT(list);
    }

    public Codec<LitematicaBlockStatePaletteHashMap> codec() {
        return CODEC;
    }

    @Override
    public void setResizer(ILitematicaBlockStatePaletteResizer resizer) {
        this.paletteResizer = resizer;
    }

    @Override
    public int idFor(class_2680 state) {
        int i = this.statePaletteMap.method_10206((Object)state);
        if (i == -1 && (i = this.statePaletteMap.method_15225((Object)state)) >= 1 << this.bits) {
            i = this.paletteResizer.onResize(this.bits + 1, state);
        }
        return i;
    }

    @Override
    @Nullable
    public class_2680 getBlockState(int indexKey) {
        return (class_2680)this.statePaletteMap.method_10200(indexKey);
    }

    @Override
    public int getPaletteSize() {
        return this.statePaletteMap.method_10204();
    }

    private void requestNewId(class_2680 state) {
        int newId;
        int origId = this.statePaletteMap.method_15225((Object)state);
        if (origId >= 1 << this.bits && (newId = this.paletteResizer.onResize(this.bits + 1, LitematicaBlockStateContainer.AIR_BLOCK_STATE)) <= origId) {
            this.statePaletteMap.method_15225((Object)state);
        }
    }

    @Override
    public void readFromNBT(class_2499 tagList) {
        class_2378 lookup = SchematicWorldHandler.INSTANCE.getRegistryManager().method_30530(class_7924.field_41254);
        int size = tagList.size();
        for (int i = 0; i < size; ++i) {
            class_2487 tag = tagList.method_68582(i);
            class_2680 state = class_2512.method_10681((class_7871)lookup, (class_2487)tag);
            if (i <= 0 && state == LitematicaBlockStateContainer.AIR_BLOCK_STATE) continue;
            this.requestNewId(state);
        }
    }

    @Override
    public class_2499 writeToNBT() {
        class_2499 tagList = new class_2499();
        for (int id = 0; id < this.statePaletteMap.method_10204(); ++id) {
            class_2680 state = (class_2680)this.statePaletteMap.method_10200(id);
            if (state == null) {
                state = LitematicaBlockStateContainer.AIR_BLOCK_STATE;
            }
            class_2487 tag = class_2512.method_10686((class_2680)state);
            tagList.add((Object)tag);
        }
        return tagList;
    }

    @Override
    public List<class_2680> fromMapping() {
        ArrayList<class_2680> list = new ArrayList<class_2680>();
        for (int i = 0; i < this.statePaletteMap.method_10204(); ++i) {
            class_2680 state = (class_2680)this.statePaletteMap.method_10200(i);
            if (state == null) {
                state = LitematicaBlockStateContainer.AIR_BLOCK_STATE;
            }
            list.add(state);
        }
        return list;
    }

    @Override
    public boolean setMapping(List<class_2680> list) {
        this.statePaletteMap.method_15229();
        for (class_2680 blockState : list) {
            this.statePaletteMap.method_15225((Object)blockState);
        }
        return true;
    }
}

