/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.registry.level.biome.fabric;

import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Either;
import dev.architectury.hooks.level.biome.BiomeHooks;
import dev.architectury.hooks.level.biome.BiomeProperties;
import dev.architectury.hooks.level.biome.ClimateProperties;
import dev.architectury.hooks.level.biome.EffectsProperties;
import dev.architectury.hooks.level.biome.GenerationProperties;
import dev.architectury.hooks.level.biome.SpawnProperties;
import dev.architectury.registry.level.biome.BiomeModifications;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.biome.v1.BiomeModification;
import net.fabricmc.fabric.api.biome.v1.BiomeModificationContext;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectionContext;
import net.fabricmc.fabric.api.biome.v1.ModificationPhase;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1959;
import net.minecraft.class_2893;
import net.minecraft.class_2922;
import net.minecraft.class_2960;
import net.minecraft.class_4763;
import net.minecraft.class_5321;
import net.minecraft.class_5483;
import net.minecraft.class_6796;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class BiomeModificationsImpl {
    private static final class_2960 FABRIC_MODIFICATION = class_2960.method_60655((String)"architectury", (String)"fabric_modification");
    private static final List<Pair<Predicate<BiomeModifications.BiomeContext>, BiConsumer<BiomeModifications.BiomeContext, BiomeProperties.Mutable>>> ADDITIONS = Lists.newArrayList();
    private static final List<Pair<Predicate<BiomeModifications.BiomeContext>, BiConsumer<BiomeModifications.BiomeContext, BiomeProperties.Mutable>>> POST_PROCESSING = Lists.newArrayList();
    private static final List<Pair<Predicate<BiomeModifications.BiomeContext>, BiConsumer<BiomeModifications.BiomeContext, BiomeProperties.Mutable>>> REMOVALS = Lists.newArrayList();
    private static final List<Pair<Predicate<BiomeModifications.BiomeContext>, BiConsumer<BiomeModifications.BiomeContext, BiomeProperties.Mutable>>> REPLACEMENTS = Lists.newArrayList();

    public static void addProperties(Predicate<BiomeModifications.BiomeContext> predicate, BiConsumer<BiomeModifications.BiomeContext, BiomeProperties.Mutable> modifier) {
        ADDITIONS.add((Pair<Predicate<BiomeModifications.BiomeContext>, BiConsumer<BiomeModifications.BiomeContext, BiomeProperties.Mutable>>)Pair.of(predicate, modifier));
    }

    public static void postProcessProperties(Predicate<BiomeModifications.BiomeContext> predicate, BiConsumer<BiomeModifications.BiomeContext, BiomeProperties.Mutable> modifier) {
        POST_PROCESSING.add((Pair<Predicate<BiomeModifications.BiomeContext>, BiConsumer<BiomeModifications.BiomeContext, BiomeProperties.Mutable>>)Pair.of(predicate, modifier));
    }

    public static void removeProperties(Predicate<BiomeModifications.BiomeContext> predicate, BiConsumer<BiomeModifications.BiomeContext, BiomeProperties.Mutable> modifier) {
        REMOVALS.add((Pair<Predicate<BiomeModifications.BiomeContext>, BiConsumer<BiomeModifications.BiomeContext, BiomeProperties.Mutable>>)Pair.of(predicate, modifier));
    }

    public static void replaceProperties(Predicate<BiomeModifications.BiomeContext> predicate, BiConsumer<BiomeModifications.BiomeContext, BiomeProperties.Mutable> modifier) {
        REPLACEMENTS.add((Pair<Predicate<BiomeModifications.BiomeContext>, BiConsumer<BiomeModifications.BiomeContext, BiomeProperties.Mutable>>)Pair.of(predicate, modifier));
    }

    private static void registerModification(BiomeModification modification, ModificationPhase phase, List<Pair<Predicate<BiomeModifications.BiomeContext>, BiConsumer<BiomeModifications.BiomeContext, BiomeProperties.Mutable>>> list) {
        modification.add(phase, (Predicate)Predicates.alwaysTrue(), (biomeSelectionContext, biomeModificationContext) -> {
            BiomeModifications.BiomeContext biomeContext = BiomeModificationsImpl.wrapSelectionContext(biomeSelectionContext);
            BiomeProperties.Mutable mutableBiome = BiomeModificationsImpl.wrapMutableBiome(biomeSelectionContext.getBiome(), biomeModificationContext);
            for (Pair pair : list) {
                if (!((Predicate)pair.getLeft()).test(biomeContext)) continue;
                ((BiConsumer)pair.getRight()).accept(biomeContext, mutableBiome);
            }
        });
    }

    private static BiomeModifications.BiomeContext wrapSelectionContext(final BiomeSelectionContext context) {
        return new BiomeModifications.BiomeContext(){
            BiomeProperties properties;
            {
                this.properties = BiomeHooks.getBiomeProperties(context.getBiome());
            }

            @Override
            public Optional<class_2960> getKey() {
                return Optional.ofNullable(context.getBiomeKey().method_29177());
            }

            @Override
            public BiomeProperties getProperties() {
                return this.properties;
            }

            @Override
            public boolean hasTag(class_6862<class_1959> tag) {
                return context.hasTag(tag);
            }
        };
    }

    private static BiomeProperties.Mutable wrapMutableBiome(class_1959 biome, BiomeModificationContext context) {
        return new BiomeHooks.MutableBiomeWrapped(biome, BiomeModificationsImpl.wrapWeather(biome, context.getWeather()), BiomeModificationsImpl.wrapEffects(biome, context.getEffects()), new MutableGenerationProperties(biome, context.getGenerationSettings()), new MutableSpawnProperties(biome, context.getSpawnSettings())){};
    }

    private static ClimateProperties.Mutable wrapWeather(class_1959 biome, final BiomeModificationContext.WeatherContext context) {
        return new BiomeHooks.ClimateWrapped(biome){

            @Override
            public ClimateProperties.Mutable setHasPrecipitation(boolean hasPrecipitation) {
                context.setPrecipitation(hasPrecipitation);
                return this;
            }

            @Override
            public ClimateProperties.Mutable setTemperature(float temperature) {
                context.setTemperature(temperature);
                return this;
            }

            @Override
            public ClimateProperties.Mutable setTemperatureModifier(class_1959.class_5484 temperatureModifier) {
                context.setTemperatureModifier(temperatureModifier);
                return this;
            }

            @Override
            public ClimateProperties.Mutable setDownfall(float downfall) {
                context.setDownfall(downfall);
                return this;
            }
        };
    }

    private static EffectsProperties.Mutable wrapEffects(class_1959 biome, final BiomeModificationContext.EffectsContext context) {
        return new BiomeHooks.EffectsWrapped(biome){

            @Override
            public EffectsProperties.Mutable setWaterColor(int color) {
                context.setWaterColor(color);
                return this;
            }

            @Override
            public EffectsProperties.Mutable setFoliageColorOverride(@Nullable Integer colorOverride) {
                context.setFoliageColor(Optional.ofNullable(colorOverride));
                return this;
            }

            @Override
            public EffectsProperties.Mutable setDryFoliageColorOverride(@Nullable Integer colorOverride) {
                context.setDryFoliageColor(Optional.ofNullable(colorOverride));
                return this;
            }

            @Override
            public EffectsProperties.Mutable setGrassColorOverride(@Nullable Integer colorOverride) {
                context.setGrassColor(Optional.ofNullable(colorOverride));
                return this;
            }

            @Override
            public EffectsProperties.Mutable setGrassColorModifier(class_4763.class_5486 modifier) {
                context.setGrassColorModifier(modifier);
                return this;
            }
        };
    }

    static {
        BiomeModification modification = BiomeModifications.create((class_2960)FABRIC_MODIFICATION);
        BiomeModificationsImpl.registerModification(modification, ModificationPhase.ADDITIONS, ADDITIONS);
        BiomeModificationsImpl.registerModification(modification, ModificationPhase.POST_PROCESSING, POST_PROCESSING);
        BiomeModificationsImpl.registerModification(modification, ModificationPhase.REMOVALS, REMOVALS);
        BiomeModificationsImpl.registerModification(modification, ModificationPhase.REPLACEMENTS, REPLACEMENTS);
    }

    private static class MutableGenerationProperties
    extends BiomeHooks.GenerationSettingsWrapped
    implements GenerationProperties.Mutable {
        protected final BiomeModificationContext.GenerationSettingsContext context;

        public MutableGenerationProperties(class_1959 biome, BiomeModificationContext.GenerationSettingsContext context) {
            super(biome);
            this.context = context;
        }

        @Override
        public GenerationProperties.Mutable addFeature(class_2893.class_2895 decoration, class_6880<class_6796> feature) {
            Either unwrap = feature.method_40229();
            if (!unwrap.left().isPresent()) {
                throw new UnsupportedOperationException("Cannot add a feature that is not registered: " + String.valueOf(unwrap.right().orElseThrow()));
            }
            this.context.addFeature(decoration, (class_5321)unwrap.left().get());
            return this;
        }

        @Override
        public GenerationProperties.Mutable addFeature(class_2893.class_2895 decoration, class_5321<class_6796> feature) {
            this.context.addFeature(decoration, feature);
            return this;
        }

        @Override
        public GenerationProperties.Mutable addCarver(class_6880<class_2922<?>> feature) {
            Either unwrap = feature.method_40229();
            if (!unwrap.left().isPresent()) {
                throw new UnsupportedOperationException("Cannot add a carver that is not registered: " + String.valueOf(unwrap.right().orElseThrow()));
            }
            this.context.addCarver((class_5321)unwrap.left().get());
            return this;
        }

        @Override
        public GenerationProperties.Mutable addCarver(class_5321<class_2922<?>> feature) {
            this.context.addCarver(feature);
            return this;
        }

        @Override
        public GenerationProperties.Mutable removeFeature(class_2893.class_2895 decoration, class_5321<class_6796> feature) {
            this.context.removeFeature(decoration, feature);
            return this;
        }

        @Override
        public GenerationProperties.Mutable removeCarver(class_5321<class_2922<?>> feature) {
            this.context.removeCarver(feature);
            return this;
        }
    }

    private static class MutableSpawnProperties
    extends BiomeHooks.SpawnSettingsWrapped
    implements SpawnProperties.Mutable {
        protected final BiomeModificationContext.SpawnSettingsContext context;

        public MutableSpawnProperties(class_1959 biome, BiomeModificationContext.SpawnSettingsContext context) {
            super(biome);
            this.context = context;
        }

        @Override
        public SpawnProperties.Mutable setCreatureProbability(float probability) {
            this.context.setCreatureSpawnProbability(probability);
            return this;
        }

        @Override
        public SpawnProperties.Mutable addSpawn(class_1311 category, class_5483.class_1964 data, int weight) {
            this.context.addSpawn(category, data, weight);
            return this;
        }

        @Override
        public boolean removeSpawns(BiPredicate<class_1311, class_5483.class_1964> predicate) {
            return this.context.removeSpawns(predicate);
        }

        @Override
        public SpawnProperties.Mutable setSpawnCost(class_1299<?> entityType, class_5483.class_5265 cost) {
            this.context.setSpawnCost(entityType, cost.comp_1308(), cost.comp_1307());
            return this;
        }

        @Override
        public SpawnProperties.Mutable setSpawnCost(class_1299<?> entityType, double charge, double energyBudget) {
            this.context.setSpawnCost(entityType, charge, energyBudget);
            return this;
        }

        @Override
        public SpawnProperties.Mutable clearSpawnCost(class_1299<?> entityType) {
            this.context.clearSpawnCost(entityType);
            return this;
        }
    }
}

