/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl.lookup;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.stream.Stream;
import net.minecraft.class_2361;
import net.minecraft.class_2960;
import org.apache.commons.lang3.tuple.Pair;
import org.jspecify.annotations.Nullable;
import snownee.jade.Jade;
import snownee.jade.api.IJadeProvider;
import snownee.jade.impl.PriorityStore;
import snownee.jade.impl.lookup.IHierarchyLookup;

public class PairHierarchyLookup<T extends IJadeProvider>
implements IHierarchyLookup<T> {
    public final IHierarchyLookup<T> first;
    public final IHierarchyLookup<T> second;
    private final Cache<Pair<Class<?>, Class<?>>, List<T>> mergedCache = CacheBuilder.newBuilder().build();
    protected boolean idMapped;
    protected @Nullable class_2361<T> idMapper;
    protected @Nullable Map<class_2960, T> byKey;

    public PairHierarchyLookup(IHierarchyLookup<T> first, IHierarchyLookup<T> second) {
        this.first = first;
        this.second = second;
    }

    public <ANY> List<ANY> getMerged(Object first, Object second) {
        Objects.requireNonNull(first);
        Objects.requireNonNull(second);
        try {
            return (List)this.mergedCache.get((Object)Pair.of(first.getClass(), second.getClass()), () -> {
                List<T> firstList = this.first.get(first);
                List<T> secondList = this.second.get(second);
                if (firstList.isEmpty()) {
                    return secondList;
                }
                if (secondList.isEmpty()) {
                    return firstList;
                }
                return ImmutableList.sortedCopyOf((Comparator)COMPARATOR, (Iterable)Iterables.concat(firstList, secondList));
            });
        }
        catch (ExecutionException e) {
            Jade.LOGGER.error("", (Throwable)e);
            return List.of();
        }
    }

    @Override
    public void idMapped() {
        this.idMapped = true;
        this.keyed();
    }

    @Override
    public class_2361<T> idMapper() {
        return Objects.requireNonNull(this.idMapper);
    }

    @Override
    public void register(Class<?> clazz, T provider) {
        IJadeProvider oldProvider;
        if (this.first.isClassAcceptable(clazz)) {
            this.first.register(clazz, provider);
        } else if (this.second.isClassAcceptable(clazz)) {
            this.second.register(clazz, provider);
        } else {
            throw new IllegalArgumentException("Class " + String.valueOf(clazz) + " is not acceptable");
        }
        if (this.byKey != null && (oldProvider = (IJadeProvider)this.byKey.put(provider.getUid(), provider)) != provider && oldProvider != null) {
            Jade.LOGGER.warn("Found different provider instances with same id {}, this may cause issues: {} and {}", new Object[]{provider.getUid(), oldProvider, provider});
        }
    }

    @Override
    public boolean isClassAcceptable(Class<?> clazz) {
        return this.first.isClassAcceptable(clazz) || this.second.isClassAcceptable(clazz);
    }

    @Override
    public List<T> get(Class<?> clazz) {
        List<T> result = this.first.get(clazz);
        if (result.isEmpty()) {
            result = this.second.get(clazz);
        }
        return result;
    }

    @Override
    public boolean isEmpty() {
        return this.first.isEmpty() && this.second.isEmpty();
    }

    @Override
    public Stream<Map.Entry<Class<?>, Collection<T>>> entries() {
        return Stream.concat(this.first.entries(), this.second.entries());
    }

    @Override
    public void invalidate() {
        this.first.invalidate();
        this.second.invalidate();
        this.mergedCache.invalidateAll();
    }

    @Override
    public void loadComplete(PriorityStore<class_2960, IJadeProvider> priorityStore) {
        this.first.loadComplete(priorityStore);
        this.second.loadComplete(priorityStore);
        if (this.idMapped) {
            this.idMapper = this.createIdMapper();
        }
    }

    @Override
    public void keyed() {
        this.byKey = Maps.newHashMap();
    }

    @Override
    public @Nullable T byKey(class_2960 key) {
        return (T)((IJadeProvider)Objects.requireNonNull(this.byKey).get(key));
    }
}

