/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.gui.config.value;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_6384;
import org.jspecify.annotations.Nullable;
import snownee.jade.gui.config.OptionsList;

public abstract class OptionValue<T>
extends OptionsList.Entry {
    private static final class_2561 SERVER_FEATURE = class_2561.method_43470((String)"* ").method_27696(class_2583.field_24360.method_10977(class_124.field_1080).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43471((String)"gui.jade.server_feature"))));
    protected final Supplier<T> getter;
    protected final Consumer<T> setter;
    protected @Nullable class_2960 id;
    protected T value;
    protected int indent;
    private class_2561 rawTitle;

    public OptionValue(String optionName, Supplier<T> getter, Consumer<T> setter) {
        super((class_2561)OptionValue.makeTitle(optionName));
        this.getter = getter;
        this.setter = setter;
        this.rawTitle = this.title();
        this.addMessageKey(optionName);
        String key = OptionValue.makeKey(optionName + "_desc");
        if (class_1074.method_4663((String)key)) {
            this.appendDescription((class_2561)class_2561.method_43471((String)key));
        }
    }

    @Override
    public void setDisabled(boolean disabled) {
        super.setDisabled(disabled);
        if (disabled) {
            this.setTitle((class_2561)this.rawTitle.method_27661().method_27692(class_124.field_1080));
        } else {
            this.setTitle(this.rawTitle);
        }
    }

    public void save() {
        this.setter.accept(this.value);
    }

    public void appendDescription(class_2561 description) {
        if (this.description.isEmpty()) {
            this.description = Lists.newArrayList((Object[])new class_2561[]{description});
        } else {
            this.description.add(description);
        }
        this.addMessage(description.getString());
    }

    @Override
    public int getTextX() {
        return this.indent + 10;
    }

    public void method_37024(class_6382 output) {
        super.method_37024(output);
        if (!this.description.isEmpty()) {
            output.method_37032(class_6381.field_33790, class_6384.method_37037((List)this.description));
        }
    }

    public boolean isValidValue() {
        return true;
    }

    @Override
    public OptionsList.Entry parent(OptionsList.Entry parent) {
        super.parent(parent);
        if (parent instanceof OptionValue) {
            this.indent = ((OptionValue)parent).indent + 12;
        }
        return this;
    }

    public abstract void setValue(T var1);

    public abstract void updateValue();

    public void setId(class_2960 id) {
        this.id = id;
    }

    public @Nullable class_2960 getId() {
        return this.id;
    }

    @Override
    public List<class_2561> getDescriptionOnShift() {
        if (this.id == null) {
            return List.of();
        }
        return List.of(class_2561.method_43470((String)this.id.toString()).method_27692(class_124.field_1080));
    }

    public void setServerFeature() {
        this.setTitle((class_2561)this.title().method_27661().method_10852(SERVER_FEATURE));
    }
}

