/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.gui;

import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_7842;
import net.minecraft.class_8130;
import org.jspecify.annotations.Nullable;
import snownee.jade.Jade;
import snownee.jade.JadeClient;
import snownee.jade.api.JadeKeys;
import snownee.jade.api.ui.JadeUI;
import snownee.jade.gui.BaseOptionsScreen;
import snownee.jade.gui.config.NotUglyEditBox;
import snownee.jade.gui.config.OptionsList;
import snownee.jade.gui.config.value.OptionValue;
import snownee.jade.impl.config.WailaConfig;
import snownee.jade.util.JsonConfig;

public class ProfileConfigScreen
extends BaseOptionsScreen {
    private @Nullable OptionValue<Boolean> enabledEntry;

    public ProfileConfigScreen(class_437 parent) {
        super(parent, (class_2561)class_2561.method_43471((String)"gui.jade.profile_settings"));
        this.saver = () -> {
            for (OptionsList.Entry entry : this.options().method_25396()) {
                if (!(entry instanceof ProfileEntry)) continue;
                ProfileEntry profileEntry = (ProfileEntry)entry;
                profileEntry.save();
            }
            class_304.method_1426();
            class_310.method_1551().field_1690.method_1640();
        };
        boolean enabled = Jade.rootConfig().isEnableProfiles();
        int index = Jade.rootConfig().profileIndex;
        Runnable runnable = JadeClient.recoverKeysAction($ -> JadeKeys.openConfig().method_1423().equals((Object)$.method_1423()));
        this.canceller = () -> {
            if (enabled) {
                Jade.useProfile(index);
            } else {
                Jade.rootConfig().setEnableProfiles(false);
            }
            runnable.run();
        };
    }

    @Override
    public OptionsList createOptions(OptionsList options) {
        WailaConfig.Root root = Jade.rootConfig();
        options.title("profiles");
        this.enabledEntry = options.choices("enable_profiles", root::isEnableProfiles, value -> {
            Jade.rootConfig().setEnableProfiles(value);
            this.refresh();
        });
        for (int i = 0; i < JadeClient.profiles.length; ++i) {
            options.add(new ProfileEntry(i));
        }
        options.title("key_binds");
        for (class_304 keyMapping : JadeClient.profiles) {
            options.keybind(keyMapping);
        }
        return options;
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        this.refresh();
    }

    public void refresh() {
        boolean enabled = Jade.rootConfig().isEnableProfiles();
        for (OptionsList.Entry entry : this.options().method_25396()) {
            if (entry == this.enabledEntry) continue;
            entry.setDisabled(!enabled);
            if (!(entry instanceof ProfileEntry)) continue;
            ProfileEntry profileEntry = (ProfileEntry)entry;
            profileEntry.refresh();
        }
    }

    public static class ProfileEntry
    extends OptionsList.Entry {
        public static final class_2561 USE = class_2561.method_43471((String)"gui.jade.profile.use");
        public static final class_2561 SAVE = class_2561.method_43471((String)"selectWorld.edit.save");
        private final int index;
        private final NotUglyEditBox editBox;
        private final @Nullable String originalName;

        public ProfileEntry(int index) {
            super((class_8130)new class_7842((class_2561)class_2561.method_43471((String)("config.jade.profile." + index)), class_310.method_1551().field_1772));
            this.index = index;
            this.editBox = new NotUglyEditBox(this.font, 0, 0, 150, 20, this.title());
            this.editBox.fixedTextX = 4;
            this.editBox.fixedTextY = 7;
            this.editBox.fixedInnerWidth = this.editBox.method_25368() - 4 - 12;
            class_7842 titleWidget = (class_7842)this.title;
            titleWidget.method_73395(this.editBox.fixedInnerWidth.intValue(), class_7842.class_11764.field_62126);
            this.editBox.backgroundMode = NotUglyEditBox.BackgroundMode.HOVERING;
            this.editBox.method_1880(100);
            this.editBox.method_47404(this.title());
            this.editBox.method_1863($ -> this.refresh());
            String name = Jade.configs().get(index).get().getName();
            if (name.startsWith("@")) {
                this.editBox.method_1852(class_1074.method_4662((String)name.substring(1), (Object[])new Object[0]));
                this.originalName = this.editBox.method_1882();
            } else {
                this.editBox.method_1852(name);
                this.originalName = null;
            }
            this.addWidget(new OptionsList.EntryWidget((class_339)this.editBox, 6, -this.editBox.method_25364() / 2, false));
            this.addWidget((class_339)class_4185.method_46430((class_2561)USE, $ -> {
                Jade.useProfile(index);
                class_437 patt0$temp = class_310.method_1551().field_1755;
                if (patt0$temp instanceof ProfileConfigScreen) {
                    ProfileConfigScreen screen = (ProfileConfigScreen)patt0$temp;
                    screen.refresh();
                }
            }).method_46437(48, 20).method_46431(), 0);
            this.addWidget((class_339)class_4185.method_46430((class_2561)SAVE, $ -> {
                if (JadeUI.hasControlDown()) {
                    Jade.saveProfile(index);
                    return;
                }
                class_310 mc = class_310.method_1551();
                class_437 screen = mc.field_1755;
                mc.method_1507((class_437)new class_410(bl -> {
                    if (bl) {
                        Jade.saveProfile(index);
                    }
                    class_310.method_1551().method_1507(screen);
                }, (class_2561)class_2561.method_43471((String)"gui.jade.save_profile.title"), (class_2561)class_2561.method_43469((String)"gui.jade.save_profile.message", (Object[])new Object[]{this.normalTitle()}), (class_2561)class_2561.method_43471((String)"gui.continue"), (class_2561)class_2561.method_43471((String)"gui.cancel")));
            }).method_46437(48, 20).method_46431(), 52);
        }

        public void refresh() {
            boolean current;
            WailaConfig.Root root = Jade.rootConfig();
            boolean enabled = root.isEnableProfiles();
            boolean bl = current = this.index == root.profileIndex;
            if (enabled && current) {
                this.setTitle((class_2561)this.normalTitle().method_27661().method_54663(-171).method_10852((class_2561)class_2561.method_43471((String)"gui.jade.profile.active")));
            } else {
                this.setTitle(this.normalTitle());
            }
            for (class_339 class_3392 : this.method_25396()) {
                if (class_3392 instanceof class_8130) continue;
                if (class_3392 == this.editBox) {
                    this.editBox.method_1868(enabled && current ? -171 : -2039584);
                    this.editBox.method_1888(enabled);
                    continue;
                }
                if (!enabled) continue;
                class_3392.field_22763 = !current;
            }
        }

        private class_2561 normalTitle() {
            return this.editBox.method_1882().isBlank() ? class_2561.method_43471((String)("config.jade.profile." + this.index)) : class_2561.method_43470((String)this.editBox.method_1882());
        }

        public void save() {
            JsonConfig<? extends WailaConfig> config = Jade.configs().get(this.index);
            if (this.originalName == null || !this.originalName.equals(this.editBox.method_1882())) {
                config.get().setName(this.editBox.method_1882());
            }
            config.save();
        }
    }
}

