/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.universal;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import net.minecraft.class_10712;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_9279;
import net.minecraft.class_9326;
import net.minecraft.class_9334;
import org.jspecify.annotations.Nullable;
import snownee.jade.addon.universal.ItemIterator;
import snownee.jade.api.Accessor;
import snownee.jade.api.view.ViewGroup;

public class ItemCollector<T> {
    public static final int MAX_SIZE = 54;
    public static final ItemCollector<?> EMPTY = new ItemCollector(null);
    private static final class_2487 IGNORED_TAG = new class_2487();
    private static final Predicate<class_1799> SHOWN;
    private final Items items = new Items();
    private final @Nullable ItemIterator<T> iterator;
    public long version;
    public long lastTimeFinished;
    public boolean lastTimeIsEmpty;
    public @Nullable List<ViewGroup<class_1799>> mergedResult;
    public @Nullable List<ViewGroup<class_1799>> sortedMergedResult;

    public ItemCollector(@Nullable ItemIterator<T> iterator) {
        this.iterator = iterator;
    }

    public @Nullable List<ViewGroup<class_1799>> update(Accessor<?> accessor) {
        List<ViewGroup<class_1799>> result;
        if (this.iterator == null) {
            return null;
        }
        T container = this.iterator.find(accessor);
        if (container == null) {
            return null;
        }
        boolean sorted = accessor.getServerData().method_68566("SortItems", false);
        long currentVersion = this.iterator.getVersion(container);
        long gameTime = System.currentTimeMillis();
        List<ViewGroup<class_1799>> list = result = sorted ? this.sortedMergedResult : this.mergedResult;
        if (result != null && this.iterator.isFinished()) {
            if (this.version == currentVersion) {
                return result;
            }
            if (this.lastTimeFinished + 250L > gameTime) {
                return result;
            }
            this.iterator.reset();
        }
        AtomicInteger count = new AtomicInteger();
        this.iterator.populate(container, 108).forEach(stack -> {
            count.incrementAndGet();
            if (SHOWN.test((class_1799)stack)) {
                ItemDefinition def = new ItemDefinition((class_1799)stack);
                this.items.addTo(def, stack.method_7947());
            }
        });
        this.iterator.afterPopulate(count.get());
        if (result != null && !this.iterator.isFinished()) {
            this.updateCollectingProgress(result.getFirst());
            return result;
        }
        List<class_1799> partialResult = this.items.partialResult(sorted);
        List<ViewGroup<class_1799>> groups = List.of(this.updateCollectingProgress(new ViewGroup<class_1799>(partialResult)));
        if (this.iterator.isFinished()) {
            if (sorted) {
                this.mergedResult = List.of(this.updateCollectingProgress(new ViewGroup<class_1799>(this.items.partialResult(false))));
                this.sortedMergedResult = groups;
            } else {
                this.mergedResult = groups;
                this.sortedMergedResult = List.of(this.updateCollectingProgress(new ViewGroup<class_1799>(this.items.partialResult(true))));
            }
            this.lastTimeIsEmpty = groups.getFirst().views.isEmpty();
            this.version = currentVersion;
            this.lastTimeFinished = gameTime;
            this.items.clear();
        }
        return groups;
    }

    protected ViewGroup<class_1799> updateCollectingProgress(ViewGroup<class_1799> group) {
        if (this.lastTimeIsEmpty && group.views.isEmpty()) {
            return group;
        }
        float progress = Objects.requireNonNull(this.iterator).getCollectingProgress();
        class_2487 data = group.getExtraData();
        if (Float.isNaN(progress) || progress >= 1.0f) {
            data.method_10551("Collecting");
        } else {
            data.method_10548("Collecting", progress);
        }
        return group;
    }

    static {
        IGNORED_TAG.method_10556("__JadeClear", true);
        SHOWN = stack -> {
            if (stack.method_7960()) {
                return false;
            }
            if (((class_10712)stack.method_58695(class_9334.field_56400, (Object)class_10712.field_56318)).comp_3600()) {
                return false;
            }
            if (stack.method_65797(class_9334.field_49637) || stack.method_65797(class_9334.field_54199)) {
                class_9279 customData = (class_9279)stack.method_58695(class_9334.field_49628, (Object)class_9279.field_49302);
                return !customData.method_57460(IGNORED_TAG);
            }
            return true;
        };
    }

    private static class Items {
        private final Object2IntLinkedOpenHashMap<ItemDefinition> items = new Object2IntLinkedOpenHashMap();
        private final List<ItemDefinition> sorted = Lists.newArrayList();
        private final Set<ItemDefinition> sortedSet = Sets.newLinkedHashSet();
        private int smallestCount;

        private Items() {
        }

        public void clear() {
            this.smallestCount = 0;
            this.items.clear();
            this.sorted.clear();
            this.sortedSet.clear();
        }

        public List<class_1799> partialResult(boolean sort) {
            if (sort) {
                this.sorted.sort((a, b) -> -Integer.compare(this.items.getInt(a), this.items.getInt(b)));
                if (this.sorted.size() > 54) {
                    this.sorted.subList(54, this.sorted.size()).clear();
                    this.sortedSet.clear();
                    this.sortedSet.addAll(this.sorted);
                }
                if (!this.sorted.isEmpty()) {
                    this.smallestCount = this.items.getInt((Object)this.sorted.getLast());
                }
                return this.sorted.stream().map(def -> def.toStack(this.items.getInt(def))).toList();
            }
            return this.items.object2IntEntrySet().stream().limit(54L).map(entry -> ((ItemDefinition)entry.getKey()).toStack(entry.getIntValue())).toList();
        }

        public void addTo(ItemDefinition def, int count) {
            int old = this.items.addTo((Object)def, count);
            if (!this.sortedSet.contains(def)) {
                count += old;
                if (this.sorted.size() < 54) {
                    this.sortedSet.add(def);
                    this.sorted.add(def);
                    this.smallestCount = Math.min(this.smallestCount, count);
                } else if (count > this.smallestCount) {
                    this.sortedSet.add(def);
                    this.sorted.add(def);
                }
            }
        }
    }

    public record ItemDefinition(class_1792 item, class_9326 components) {
        ItemDefinition(class_1799 stack) {
            this(stack.method_7909(), stack.method_57380());
        }

        public class_1799 toStack(int count) {
            class_1799 itemStack = new class_1799((class_1935)this.item, count);
            itemStack.method_57366(this.components);
            return itemStack;
        }
    }
}

