/*
 * Decompiled with CFR 0.152.
 */
package net.immortaldevs.bindcmd;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_338;
import net.minecraft.class_746;
import net.minecraft.class_8623;

public final class Command {
    private final CmdType type;
    private final String command;

    public Command(String command) {
        if (command.startsWith("@")) {
            String message = this.getLastMessage(command);
            this.type = this.getType(message);
            this.command = this.processMessage(message);
        } else {
            this.type = this.getType(command);
            String message = this.type == CmdType.MESSAGE ? command : command.substring(1);
            this.command = this.processMessage(message);
        }
    }

    public CmdType getType() {
        return this.type;
    }

    public String getCommand() {
        return this.command;
    }

    private CmdType getType(String command) {
        if (command.isBlank()) {
            return CmdType.NONE;
        }
        if (command.startsWith("/")) {
            return CmdType.COMMAND;
        }
        return CmdType.MESSAGE;
    }

    private String getLastMessage(String command) {
        try {
            int offset = Integer.parseInt(command.substring(1));
            class_8623<String> history = this.getChatHistory();
            if (history.isEmpty() || offset < 0 || offset >= history.size()) {
                return "";
            }
            return (String)history.get(history.size() - 1 - offset);
        }
        catch (NumberFormatException e) {
            return "";
        }
    }

    private class_8623<String> getChatHistory() {
        class_329 inGameHud = class_310.method_1551().field_1705;
        if (inGameHud == null) {
            return new class_8623();
        }
        class_338 chatHud = inGameHud.method_1743();
        if (chatHud == null) {
            return new class_8623();
        }
        return chatHud.method_1809();
    }

    private String processMessage(String message) {
        if (!message.contains("$")) {
            return message;
        }
        Pattern pattern = Pattern.compile("\\$\\{(.+?)}|\\$(\\w+)");
        Matcher matcher = pattern.matcher(message);
        StringBuilder result = new StringBuilder();
        while (matcher.find()) {
            String expression;
            String string = expression = matcher.group(1) != null ? matcher.group(1) : matcher.group(2);
            if (expression == null) {
                expression = "";
            }
            String evaluated = expression;
            try {
                evaluated = this.replaceVariables(evaluated);
                evaluated = this.evaluateExpression(evaluated);
            }
            catch (Exception exception) {
                // empty catch block
            }
            matcher.appendReplacement(result, Matcher.quoteReplacement(evaluated));
        }
        matcher.appendTail(result);
        return result.toString();
    }

    private String replaceVariables(String expression) {
        class_310 client = class_310.method_1551();
        class_746 player = client.field_1724;
        if (player == null) {
            return expression;
        }
        Map<String, String> variables = Map.of("username", player.method_5477().getString(), "maxHealth", String.valueOf(player.method_6063()), "health", String.valueOf(player.method_6032()), "hunger", String.valueOf(player.method_7344().method_7586()), "x", String.valueOf(player.method_31477()), "y", String.valueOf(player.method_31478()), "z", String.valueOf(player.method_31479()));
        for (Map.Entry<String, String> entry : variables.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (!expression.contains(key)) continue;
            return expression.replace(key, value);
        }
        return expression;
    }

    private String evaluateExpression(String expression) {
        ArrayList<String> output = new ArrayList<String>();
        ArrayDeque<String> operators = new ArrayDeque<String>();
        List<String> methods = List.of("sqrt", "cbrt", "min", "max", "floor", "ceil", "round", "abs", "sin", "cos", "tan", "asin", "acos", "atan", "atan2", "sinh", "cosh", "tanh", "exp", "ln", "log", "log2", "log10");
        Map<String, Integer> precedence = Map.of("+", 2, "-", 2, "*", 3, "/", 3, "%", 3, "^", 4);
        String tokenPattern = "([\\-0-9.]+)|\\s*([()+\\-*/%^]|" + String.join((CharSequence)"|", methods) + ")\\s*";
        Pattern tokenRegex = Pattern.compile(tokenPattern);
        Matcher matcher = tokenRegex.matcher(expression.replace(" ", ""));
        ArrayList<String> tokens = new ArrayList<String>();
        while (matcher.find()) {
            tokens.add(matcher.group().trim());
        }
        if (tokens.size() < 2) {
            return expression;
        }
        for (String string : tokens) {
            int n;
            if (string.equals("(")) {
                operators.addLast(string);
                continue;
            }
            if (string.equals(")")) {
                while (!operators.isEmpty() && !((String)operators.getLast()).equals("(")) {
                    output.add((String)operators.removeLast());
                }
                if (operators.isEmpty() || !((String)operators.getLast()).equals("(")) continue;
                operators.removeLast();
                continue;
            }
            if (this.isDouble(string)) {
                output.add(string);
                continue;
            }
            if (!precedence.containsKey(string) && !methods.contains(string)) continue;
            int n2 = n = methods.contains(string) ? 5 : precedence.get(string);
            while (!operators.isEmpty() && !((String)operators.getLast()).equals("(")) {
                boolean leftAssoc;
                String last = (String)operators.getLast();
                int lastPrec = methods.contains(last) ? 5 : precedence.getOrDefault(last, 0);
                boolean bl = leftAssoc = !string.equals("*") && !string.equals("/") && !string.equals("%");
                if (n >= lastPrec && (n != lastPrec || !leftAssoc)) break;
                output.add((String)operators.removeLast());
            }
            operators.addLast(string);
        }
        while (!operators.isEmpty()) {
            output.add((String)operators.removeLast());
        }
        ArrayDeque<Double> stack = new ArrayDeque<Double>();
        for (String string : output) {
            if (this.isDouble(string)) {
                stack.addLast(Double.parseDouble(string));
                continue;
            }
            if (methods.contains(string)) {
                double operand = (Double)stack.removeLast();
                stack.addLast(switch (string) {
                    case "min" -> Math.min(operand, (Double)stack.removeLast());
                    case "max" -> Math.max(operand, (Double)stack.removeLast());
                    case "floor" -> Math.floor(operand);
                    case "ceil" -> Math.ceil(operand);
                    case "round" -> Math.round(operand);
                    case "sqrt" -> Math.sqrt(operand);
                    case "cbrt" -> Math.cbrt(operand);
                    case "abs" -> Math.abs(operand);
                    case "sin" -> Math.sin(operand);
                    case "cos" -> Math.cos(operand);
                    case "tan" -> Math.tan(operand);
                    case "asin" -> Math.asin(operand);
                    case "acos" -> Math.acos(operand);
                    case "atan" -> Math.atan(operand);
                    case "atan2" -> Math.atan2(operand, (Double)stack.removeLast());
                    case "sinh" -> Math.sinh(operand);
                    case "cosh" -> Math.cosh(operand);
                    case "tanh" -> Math.tanh(operand);
                    case "exp" -> Math.exp(operand);
                    case "ln" -> Math.log(operand);
                    case "log" -> {
                        double base = (Double)stack.removeLast();
                        yield Math.log(operand) / Math.log(base);
                    }
                    case "log2" -> Math.log(operand) / Math.log(2.0);
                    case "log10" -> Math.log10(operand);
                    default -> throw new IllegalArgumentException("Unknown operator: " + string);
                });
                continue;
            }
            if (!precedence.containsKey(string)) continue;
            double operand2 = (Double)stack.removeLast();
            double operand1 = (Double)stack.removeLast();
            double result = Command.getResult(string, operand1, operand2);
            stack.addLast(result);
        }
        if (stack.isEmpty()) {
            return expression;
        }
        double d = (Double)stack.getFirst();
        if (Double.isInfinite(d)) {
            return "\u221e";
        }
        if (d % 1.0 == 0.0) {
            return Integer.toString((int)d);
        }
        return Double.toString(d);
    }

    private static double getResult(String token, double operand1, double operand2) {
        return switch (token) {
            case "+" -> operand1 + operand2;
            case "-" -> operand1 - operand2;
            case "*" -> operand1 * operand2;
            case "/" -> operand1 / operand2;
            case "%" -> operand1 % operand2;
            case "^" -> Math.pow(operand1, operand2);
            default -> throw new IllegalArgumentException("Unknown operator: " + token);
        };
    }

    private boolean isDouble(String value) {
        try {
            Double.parseDouble(value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static enum CmdType {
        MESSAGE,
        COMMAND,
        NONE;

    }
}

