/*
 * Decompiled with CFR 0.152.
 */
package net.immortaldevs.bindcmd;

import java.nio.file.Path;
import java.util.List;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.immortaldevs.bindcmd.Command;
import net.immortaldevs.bindcmd.CommandBinding;
import net.immortaldevs.bindcmd.ConfigS2CPayload;
import net.immortaldevs.bindcmd.config.Config;
import net.minecraft.class_1132;
import net.minecraft.class_310;
import net.minecraft.class_634;

public final class BindCmdClient
implements ClientModInitializer {
    private static long lastKeyPress = 0L;
    private static final long COOLDOWN = 200L;

    public void onInitializeClient() {
        PayloadTypeRegistry.playS2C().register(ConfigS2CPayload.ID, ConfigS2CPayload.CODEC);
        Config.load();
        ClientTickEvents.END_CLIENT_TICK.register(BindCmdClient::onEndClientTick);
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> BindCmdClient.onPlayerJoin(client));
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> BindCmdClient.onPlayerDisconnect());
        ClientPlayNetworking.registerGlobalReceiver(ConfigS2CPayload.ID, (payload, context) -> Config.setServerBindings(payload.config()));
    }

    private static void onPlayerJoin(class_310 client) {
        Config.clearServerBindings();
        if (client.method_1576() != null && client.method_1576().method_3724()) {
            class_1132 server = client.method_1576();
            Path dir = server.field_23784.method_54543().comp_732();
            Config.loadWorldConfig(dir);
        }
    }

    private static void onPlayerDisconnect() {
        Config.clearServerBindings();
    }

    private static void onEndClientTick(class_310 client) {
        if (System.currentTimeMillis() - lastKeyPress < 200L) {
            return;
        }
        for (CommandBinding binding : Config.getBindings()) {
            BindCmdClient.handleBinding(client, binding);
        }
    }

    private static void handleBinding(class_310 client, CommandBinding binding) {
        class_634 networkHandler = client.method_1562();
        if (binding.isUnknown() || networkHandler == null) {
            return;
        }
        if (binding.isPressed() && !binding.wasPressed) {
            List<String> commands = Config.getBindings().stream().filter(b -> b.getTranslationKey().equals(binding.getTranslationKey())).map(b -> b.command).toList();
            for (String command : commands) {
                Command cmd = new Command(command);
                switch (cmd.getType()) {
                    case COMMAND: {
                        networkHandler.method_45730(cmd.getCommand());
                        break;
                    }
                    case MESSAGE: {
                        networkHandler.method_45729(cmd.getCommand());
                        break;
                    }
                    case NONE: {
                        return;
                    }
                }
            }
            lastKeyPress = System.currentTimeMillis();
            binding.wasPressed = true;
        }
        if (!binding.isPressed() && binding.wasPressed) {
            binding.wasPressed = false;
        }
    }
}

