/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.server.serializer;

import com.zigythebird.playeranimcore.animation.Animation;
import io.github.kosmx.emotes.common.CommonData;
import io.github.kosmx.emotes.common.network.EmotePacket;
import io.github.kosmx.emotes.common.tools.MathHelper;
import io.github.kosmx.emotes.common.tools.ServiceLoaderUtil;
import io.github.kosmx.emotes.common.tools.UUIDMap;
import io.github.kosmx.emotes.server.config.Serializer;
import io.github.kosmx.emotes.server.serializer.EmoteSerializer;
import io.github.kosmx.emotes.server.serializer.type.EmoteSerializerException;
import io.github.kosmx.emotes.server.serializer.type.IReader;
import io.github.kosmx.emotes.server.serializer.type.IWriter;
import io.github.kosmx.emotes.server.services.InstanceService;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public class UniversalEmoteSerializer {
    public static final List<IReader> READERS = ServiceLoaderUtil.loadServicesSorted(IReader.class).toList();
    public static final List<IWriter> WRITERS = ServiceLoaderUtil.loadServicesSorted(IWriter.class).toList();
    public static final UUIDMap<Animation> SERVER_EMOTES = new UUIDMap();
    public static final UUIDMap<Animation> HIDDEN_SERVER_EMOTES = new UUIDMap();
    private static final Comparator<IWriter> WRITTER_COMPARATOR = Comparator.comparingInt(w -> w.onlyEmoteFile() ? 0 : 1).thenComparingInt(w -> w.possibleDataLoss() ? 0 : 1);

    public static Map<String, Animation> readData(InputStream inputStream, @Nullable String filename, String format) throws EmoteSerializerException {
        return UniversalEmoteSerializer.readData(inputStream, (String)((Object)Objects.requireNonNullElse(filename, "emote." + format)));
    }

    public static Map<String, Animation> readData(InputStream inputStream, String fileName) throws EmoteSerializerException {
        if (fileName == null || fileName.isEmpty()) {
            throw new IllegalArgumentException("filename can not be null if no format type was given");
        }
        try {
            return UniversalEmoteSerializer.findReader(fileName).orElseThrow(() -> new EmoteSerializerException("No known reader for format", fileName)).read(inputStream, fileName);
        }
        catch (EmoteSerializerException e) {
            throw e;
        }
        catch (Throwable cause) {
            throw new EmoteSerializerException("Error has occurred while serializing an emote", fileName, cause);
        }
    }

    public static Optional<IReader> findReader(String fileName) {
        return READERS.stream().filter(reader -> reader.canRead(fileName)).findFirst();
    }

    public static IWriter findWriter(@Nullable String fileName) throws EmoteSerializerException {
        return WRITERS.stream().filter(writer -> fileName == null || writer.canWrite(fileName)).max(WRITTER_COMPARATOR).orElseThrow(() -> new EmoteSerializerException("No writer has been found!", null));
    }

    public static void writeKeyframeAnimation(OutputStream stream, Animation emote, String fileName) throws EmoteSerializerException {
        IWriter writer = UniversalEmoteSerializer.findWriter(fileName);
        if (writer.possibleDataLoss()) {
            CommonData.LOGGER.warn("Writing in {} format may result in data loss or incorrect playback of the final file!", (Object)writer.getExtension());
        }
        writer.write(emote, stream, fileName);
    }

    public static UUIDMap<Animation> loadEmotes() {
        SERVER_EMOTES.clear();
        HIDDEN_SERVER_EMOTES.clear();
        UniversalEmoteSerializer.serializeInternalJson("waving");
        UniversalEmoteSerializer.serializeInternalJson("clap");
        UniversalEmoteSerializer.serializeInternalJson("crying");
        UniversalEmoteSerializer.serializeInternalJson("point");
        UniversalEmoteSerializer.serializeInternalJson("here");
        UniversalEmoteSerializer.serializeInternalJson("palm");
        UniversalEmoteSerializer.serializeInternalJson("backflip");
        UniversalEmoteSerializer.serializeInternalJson("roblox_potion_dance");
        UniversalEmoteSerializer.serializeInternalJson("kazotsky_kick");
        UniversalEmoteSerializer.serializeInternalJson("twerk");
        UniversalEmoteSerializer.serializeInternalJson("club_penguin_dance");
        Path path = InstanceService.INSTANCE.getExternalEmoteDir();
        if (!Files.isDirectory(path, new LinkOption[0])) {
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        EmoteSerializer.serializeEmotes(Serializer.getConfig().loadEmotesServerSide.get() != false ? SERVER_EMOTES : HIDDEN_SERVER_EMOTES, path);
        Path serverEmotesDir = path.resolve("server");
        if (Files.isDirectory(serverEmotesDir, new LinkOption[0])) {
            EmoteSerializer.serializeEmotes(SERVER_EMOTES, serverEmotesDir);
        }
        return UniversalEmoteSerializer.getLoadedEmotes();
    }

    private static void serializeInternalJson(String name) {
        if (!Serializer.getConfig().loadBuiltinEmotes.get().booleanValue()) {
            return;
        }
        try (InputStream stream = UniversalEmoteSerializer.class.getClassLoader().getResourceAsStream("assets/emotecraft/emotes/" + name + ".json");){
            Map<String, Animation> emotes = UniversalEmoteSerializer.readData(stream, name + ".json");
            for (Animation emote : emotes.values()) {
                emote.data().put("isBuiltin", (Object)true);
                InputStream iconStream = UniversalEmoteSerializer.class.getClassLoader().getResourceAsStream("assets/emotecraft/emotes/" + name + ".png");
                if (iconStream == null) continue;
                emote.data().put("iconData", (Object)MathHelper.readFromIStream(iconStream));
                iconStream.close();
            }
            HIDDEN_SERVER_EMOTES.addAll(emotes.values());
        }
        catch (EmoteSerializerException | IOException e) {
            CommonData.LOGGER.warn("Failed to load built-in emote!", (Throwable)e);
        }
    }

    @Nullable
    public static Animation getEmote(UUID uuid) {
        return SERVER_EMOTES.getOrDefault(uuid, (Animation)HIDDEN_SERVER_EMOTES.get(uuid));
    }

    public static UUIDMap<Animation> getLoadedEmotes() {
        UUIDMap<Animation> map = new UUIDMap<Animation>();
        map.putAll(HIDDEN_SERVER_EMOTES);
        map.putAll(SERVER_EMOTES);
        return map;
    }

    public static Stream<EmotePacket> preparePackets(Map<Byte, Byte> compatibilityMap) {
        return SERVER_EMOTES.values().stream().map(emote -> {
            try {
                return new EmotePacket.Builder().configureToSaveEmote((Animation)emote).setSizeLimit(0x100000, false).setVersion(compatibilityMap).build();
            }
            catch (Throwable e) {
                CommonData.LOGGER.warn("Failed to prepare emote packet!", e);
                return null;
            }
        }).filter(Objects::nonNull);
    }
}

