/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.worldeditcui.render.shapes;

import net.minecraft.class_2818;
import net.minecraft.class_2902;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import org.enginehub.worldeditcui.event.listeners.CUIRenderContext;
import org.enginehub.worldeditcui.render.LineStyle;
import org.enginehub.worldeditcui.render.RenderStyle;
import org.enginehub.worldeditcui.render.shapes.Render3DGrid;
import org.enginehub.worldeditcui.render.shapes.RenderRegion;
import org.enginehub.worldeditcui.util.Vector3;

public class RenderChunkBoundary
extends RenderRegion {
    private final class_310 mc;
    private final Render3DGrid grid;

    public RenderChunkBoundary(RenderStyle boundaryStyle, RenderStyle gridStyle, class_310 minecraft) {
        super(boundaryStyle);
        this.mc = minecraft;
        this.grid = new Render3DGrid(gridStyle, Vector3.ZERO, Vector3.ZERO);
        this.grid.setSpacing(4.0);
    }

    @Override
    public void render(CUIRenderContext ctx) {
        double yMin = this.mc.field_1687 != null ? (double)this.mc.field_1687.method_8597().comp_651() : 0.0;
        double yMax = this.mc.field_1687 != null ? (double)this.mc.field_1687.method_8597().comp_653() - yMin : 256.0;
        long xBlock = class_3532.method_15357((double)ctx.cameraPos().getX());
        long zBlock = class_3532.method_15357((double)ctx.cameraPos().getZ());
        int xChunk = (int)(xBlock >> 4);
        int zChunk = (int)(zBlock >> 4);
        double xBase = (double)(0L - (xBlock - (long)(xChunk * 16))) - (ctx.cameraPos().getX() - (double)xBlock);
        double zBase = (double)(0L - (zBlock - (long)(zChunk * 16))) - (ctx.cameraPos().getZ() - (double)zBlock) + 16.0;
        this.grid.setPosition(new Vector3(xBase - 0.001, yMin, zBase - 16.0 - 0.001), new Vector3(xBase + 16.0 + 0.001, yMax, zBase + 0.001));
        ctx.flush();
        ctx.matrixStack().pushMatrix();
        ctx.matrixStack().translate(0.0f, (float)(-ctx.cameraPos().getY()), 0.0f);
        ctx.applyMatrices();
        ctx.withCameraAt(Vector3.ZERO, this.grid::render);
        this.renderChunkBorder(ctx, yMin, yMax, xBase, zBase);
        if (this.mc.field_1687 != null) {
            this.renderChunkBoundary(ctx, xChunk, zChunk, xBase, zBase);
        }
        ctx.flush();
        ctx.matrixStack().popMatrix();
        ctx.applyMatrices();
    }

    private void renderChunkBorder(CUIRenderContext ctx, double yMin, double yMax, double xBase, double zBase) {
        int spacing = 16;
        for (LineStyle line : this.style.getLines()) {
            if (!ctx.apply(line, this.style.getRenderType())) continue;
            ctx.color(line).beginLines();
            for (int x = -16; x <= 32; x += 16) {
                for (int z = -16; z <= 32; z += 16) {
                    ctx.vertex(xBase + (double)x, yMin, zBase - (double)z).vertex(xBase + (double)x, yMax, zBase - (double)z);
                }
            }
            for (double y = yMin; y <= yMax; y += yMax) {
                ctx.vertex(xBase, y, zBase).vertex(xBase, y, zBase - 16.0).vertex(xBase, y, zBase - 16.0).vertex(xBase + 16.0, y, zBase - 16.0).vertex(xBase + 16.0, y, zBase - 16.0).vertex(xBase + 16.0, y, zBase).vertex(xBase + 16.0, y, zBase).vertex(xBase, y, zBase);
            }
            ctx.endLines();
        }
    }

    private void renderChunkBoundary(CUIRenderContext ctx, int xChunk, int zChunk, double xBase, double zBase) {
        class_2818 chunk = this.mc.field_1687.method_8497(xChunk, zChunk);
        class_2902 heightMap = chunk.method_12032(class_2902.class_2903.field_13202);
        for (LineStyle line : this.style.getLines()) {
            if (!ctx.apply(line, this.style.getRenderType())) continue;
            ctx.beginLines().color(line);
            int[][] lastHeight = new int[][]{{-1, -1}, {-1, -1}};
            int height = 0;
            for (int i = 0; i < 16; ++i) {
                for (int j = 0; j < 2; ++j) {
                    for (int axis = 0; axis < 2; ++axis) {
                        double zPos;
                        height = axis == 0 ? heightMap.method_12603(j * 15, i) : heightMap.method_12603(i, j * 15);
                        double xPos = axis == 0 ? xBase + (double)(j * 16) : xBase + (double)i;
                        double d = zPos = axis == 0 ? zBase - 16.0 + (double)i : zBase - 16.0 + (double)(j * 16);
                        if (lastHeight[axis][j] > -1 && height != lastHeight[axis][j]) {
                            ctx.vertex(xPos, (double)lastHeight[axis][j] + 0.001, zPos).vertex(xPos, (double)height + 0.001, zPos);
                        }
                        ctx.vertex(xPos, (double)height + 0.001, zPos).vertex(xPos + (double)axis, (double)height + 0.001, zPos + (double)(1 - axis));
                        lastHeight[axis][j] = height;
                    }
                }
            }
            ctx.endLines();
        }
    }
}

