/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.features.property_reading.properties.etf_properties;

import java.util.Optional;
import java.util.Properties;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7134;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import traben.entity_texture_features.features.property_reading.properties.RandomProperty;
import traben.entity_texture_features.features.property_reading.properties.generic_properties.StringArrayOrRegexProperty;
import traben.entity_texture_features.features.state.ETFEntityRenderState;
import traben.entity_texture_features.utils.ETFUtils2;

public class DimensionProperty
extends StringArrayOrRegexProperty {
    private final boolean doPrint;

    protected DimensionProperty(String string) throws RandomProperty.RandomPropertyException {
        super(string.replace("print:", ""));
        this.doPrint = string.startsWith("print:");
    }

    public static DimensionProperty getPropertyOrNull(Properties properties, int propertyNum) {
        try {
            return new DimensionProperty(RandomProperty.readPropertiesOrThrow(properties, propertyNum, "dimension"));
        }
        catch (RandomProperty.RandomPropertyException e) {
            return null;
        }
    }

    @Override
    @Nullable
    public String getValueFromEntity(ETFEntityRenderState etfEntity) {
        if (etfEntity == null) {
            return null;
        }
        class_1937 world = etfEntity.world();
        if (world == null) {
            return null;
        }
        Optional dimKey = etfEntity.world().method_40134().method_40230();
        if (dimKey.isEmpty()) {
            return null;
        }
        class_2960 key = ((class_5321)dimKey.get()).method_29177();
        if (key == null) {
            return null;
        }
        String output = key.equals((Object)class_7134.field_37666.method_29177()) || key.method_12832().equals("overworld_caves") ? "overworld" : (key.equals((Object)class_7134.field_37667.method_29177()) ? "the_nether" : (key.equals((Object)class_7134.field_37668.method_29177()) ? "the_end" : key.toString()));
        if (this.doPrint) {
            ETFUtils2.logMessage("[Dimension property print]: " + output);
        }
        return output;
    }

    @Override
    @NotNull
    public String[] getPropertyIds() {
        return new String[]{"dimension"};
    }

    @Override
    protected boolean shouldForceLowerCaseCheck() {
        return false;
    }
}

