/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.config.screens.skin;

import java.nio.file.Path;
import java.util.Objects;
import net.minecraft.class_1011;
import net.minecraft.class_11907;
import net.minecraft.class_11909;
import net.minecraft.class_11910;
import net.minecraft.class_1309;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_490;
import net.minecraft.class_5244;
import net.minecraft.class_746;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import traben.entity_texture_features.ETF;
import traben.entity_texture_features.config.screens.skin.ETFConfigScreenSkinToolOutcome;
import traben.entity_texture_features.config.screens.skin.ETFConfigScreenSkinToolPixelSelection;
import traben.entity_texture_features.config.screens.skin.ETFScreenOldCompat;
import traben.entity_texture_features.features.ETFManager;
import traben.entity_texture_features.features.player.ETFPlayerTexture;
import traben.entity_texture_features.utils.ETFUtils2;

public class ETFConfigScreenSkinTool
extends ETFScreenOldCompat {
    private static final class_2960 APPLY_OVERLAY = ETFUtils2.res("entity_texture_features:textures/skin_feature_printout.png");
    private static final class_2960 REMOVE_OVERLAY = ETFUtils2.res("entity_texture_features:textures/skin_feature_remove.png");
    private static final class_2960 WHOLE_FACE_OVERLAY = ETFUtils2.res("entity_texture_features:textures/skin_feature_whole_face.png");
    private static final class_2960 SMALL_EYE_OVERLAY = ETFUtils2.res("entity_texture_features:textures/skin_feature_small_eyes.png");
    private static final class_2960 BOXES_OVERLAY = ETFUtils2.res("entity_texture_features:textures/skin_feature_orange_areas.png");
    public Boolean originalEnableBlinking;
    public ETFPlayerTexture thisETFPlayerTexture = null;
    public class_1011 currentEditorSkin = null;
    public boolean flipView = false;
    class_4185 printSkinFileButton = null;
    class_4185 villagerNoseButton = null;
    class_4185 coatButton = null;
    class_4185 coatLengthButton = null;
    class_4185 blinkButton = null;
    class_4185 blinkHeightButton = null;
    class_4185 emissiveButton = null;
    class_4185 emissiveSelectButton = null;
    class_4185 enchantButton = null;
    class_4185 enchantSelectButton = null;
    class_4185 transparencyButton = null;
    private class_4185 overridesButton = null;
    private Boolean allowOverrides = null;

    public ETFConfigScreenSkinTool(class_437 parent) {
        super("config.entity_texture_features.player_skin_features.title", parent, false);
    }

    public static int getPixelColour(int choice) {
        switch (choice) {
            case 1: {
                return -65281;
            }
            case 2: {
                return -256;
            }
            case 3: {
                return -16776961;
            }
            case 4: {
                return -16711936;
            }
            case 5: {
                return -16760705;
            }
            case 6: {
                return -65536;
            }
            case 7: {
                return -16744449;
            }
            case 8: {
                return -14483457;
            }
        }
        return choice;
    }

    private void onExit() {
        ETF.config().getConfig().enableBlinking = this.originalEnableBlinking;
        if (class_310.method_1551().field_1724 != null) {
            ETFManager.getInstance().PLAYER_TEXTURE_MAP.removeEntryOnly(class_310.method_1551().field_1724.method_5667());
        }
        this.thisETFPlayerTexture = null;
    }

    @Override
    public void method_25419() {
        this.onExit();
        super.method_25419();
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        if (this.originalEnableBlinking == null) {
            this.originalEnableBlinking = ETF.config().getConfig().enableBlinking;
            ETF.config().getConfig().enableBlinking = true;
        }
        if (class_310.method_1551().field_1724 != null && this.thisETFPlayerTexture == null) {
            this.thisETFPlayerTexture = ETFManager.getInstance().PLAYER_TEXTURE_MAP.get(class_310.method_1551().field_1724.method_5667());
            if (this.thisETFPlayerTexture == null) {
                ETFPlayerTexture etfPlayerTexture = new ETFPlayerTexture();
                ETFManager.getInstance().PLAYER_TEXTURE_MAP.put(class_310.method_1551().field_1724.method_5667(), etfPlayerTexture);
                this.thisETFPlayerTexture = etfPlayerTexture;
            } else if (this.thisETFPlayerTexture.etfTextureOfFinalBaseSkin != null) {
                this.thisETFPlayerTexture.etfTextureOfFinalBaseSkin.setGUIBlink();
            }
        }
        if (this.currentEditorSkin == null) {
            this.currentEditorSkin = ETFUtils2.emptyNativeImage(64, 64);
            class_1011 skin = ETFPlayerTexture.clientPlayerOriginalSkinImageForTool;
            if (skin != null) {
                this.currentEditorSkin.method_4317(ETFPlayerTexture.clientPlayerOriginalSkinImageForTool);
            } else {
                this.onExit();
                ETFUtils2.logError("could not load tool as skin could not be loaded");
                Objects.requireNonNull(this.field_22787).method_1507(this.parent);
            }
        }
        this.method_37063((class_364)this.getETFButton(this.field_22789 / 2 - 210, (int)((double)this.field_22790 * 0.9), 200, 20, class_5244.field_24335, button -> {
            this.onExit();
            Objects.requireNonNull(this.field_22787).method_1507(this.parent);
        }));
        this.method_37063((class_364)this.getETFButton((int)((double)this.field_22789 * 0.024), (int)((double)this.field_22790 * 0.2), 20, 20, class_2561.method_30163((String)"\u27f3"), button -> {
            this.flipView = !this.flipView;
        }));
        this.printSkinFileButton = this.getETFButton(this.field_22789 / 2 + 10, (int)((double)this.field_22790 * 0.9), 200, 20, ETF.getTextFromTranslation("selectWorld.edit.save"), button -> {
            boolean result = false;
            if (class_310.method_1551().field_1724 != null) {
                result = this.printPlayerSkinCopy();
            }
            Objects.requireNonNull(this.field_22787).method_1507((class_437)new ETFConfigScreenSkinToolOutcome(this.parent, result, this.currentEditorSkin));
            this.onExit();
        });
        this.method_37063((class_364)this.printSkinFileButton);
        if (class_310.method_1551().field_1724 != null) {
            this.method_37063((class_364)this.getETFButton((int)((double)this.field_22789 * 0.25), (int)((double)this.field_22790 * 0.2), (int)((double)this.field_22789 * 0.42), 20, this.thisETFPlayerTexture.hasFeatures ? ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.remove_features") : ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.add_features"), button -> {
                if (this.thisETFPlayerTexture.hasFeatures) {
                    this.applyExistingOverlayToSkin(REMOVE_OVERLAY);
                } else {
                    this.applyExistingOverlayToSkin(APPLY_OVERLAY);
                }
                this.thisETFPlayerTexture.changeSkinToThisForTool(this.currentEditorSkin);
                button.method_25355(this.thisETFPlayerTexture.hasFeatures ? ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.remove_features") : ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.add_features"));
                this.updateButtons();
            }));
            this.overridesButton = (class_4185)this.method_37063((class_364)this.getETFButton((int)((double)this.field_22789 * 0.695), (int)((double)this.field_22790 * 0.2), (int)((double)this.field_22789 * 0.275), 20, ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.allow_examples"), button -> {
                this.allowOverrides = false;
                button.field_22763 = false;
                button.method_25355(ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.allow_examples.off"));
            }, ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.allow_examples.tooltip")));
            this.villagerNoseButton = this.getETFButton((int)((double)this.field_22789 * 0.25), (int)((double)this.field_22790 * 0.7), (int)((double)this.field_22789 * 0.2), 20, class_2561.method_30163((String)(ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.nose.button").getString() + this.thisETFPlayerTexture.noseType.getButtonText().getString())), button -> {
                int colour = this.thisETFPlayerTexture.noseType.next().getNosePixelColour();
                ETFUtils2.setPixel(this.currentEditorSkin, 53, 17, colour);
                if (this.thisETFPlayerTexture.noseType.next().appliesTextureOverlay()) {
                    this.applyExistingOverlayToSkin(BOXES_OVERLAY);
                }
                this.thisETFPlayerTexture.changeSkinToThisForTool(this.currentEditorSkin);
                button.method_25355(class_2561.method_30163((String)(ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.nose.button").getString() + this.thisETFPlayerTexture.noseType.getButtonText().getString())));
            }, ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.nose.tooltip"));
            this.transparencyButton = this.getETFButton((int)((double)this.field_22789 * 0.695), (int)((double)this.field_22790 * 0.7), (int)((double)this.field_22789 * 0.275), 20, class_2561.method_30163((String)(ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.transparency.button").getString() + ETFConfigScreenSkinTool.booleanAsOnOff(!this.thisETFPlayerTexture.wasForcedSolid))), button -> {
                button.method_25355(class_2561.method_30163((String)(ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.transparency.button").getString() + ETFConfigScreenSkinTool.booleanAsOnOff(this.thisETFPlayerTexture.wasForcedSolid))));
                ETFUtils2.setPixel(this.currentEditorSkin, 53, 18, ETFConfigScreenSkinTool.getPixelColour(this.thisETFPlayerTexture.wasForcedSolid ? 0 : 1));
                this.thisETFPlayerTexture.changeSkinToThisForTool(this.currentEditorSkin);
                this.updateButtons();
            }, ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.transparency.tooltip"));
            this.coatButton = this.getETFButton((int)((double)this.field_22789 * 0.25), (int)((double)this.field_22790 * 0.3), (int)((double)this.field_22789 * 0.42), 20, CoatStyle.get(this.thisETFPlayerTexture.coatStyle).getTitle(), button -> {
                CoatStyle coat = CoatStyle.get(this.thisETFPlayerTexture.coatStyle).next();
                button.method_25355(coat.getTitle());
                ETFUtils2.setPixel(this.currentEditorSkin, 52, 17, coat.getCoatPixelColour());
                this.thisETFPlayerTexture.changeSkinToThisForTool(this.currentEditorSkin);
                this.updateButtons();
            }, ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.coat_style.tooltip"));
            this.coatLengthButton = this.getETFButton((int)((double)this.field_22789 * 0.695), (int)((double)this.field_22790 * 0.3), (int)((double)this.field_22789 * 0.275), 20, class_2561.method_30163((String)(ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.coat_length.title").getString() + this.thisETFPlayerTexture.coatLength)), button -> {
                int lengthChoice = this.thisETFPlayerTexture.coatLength == 8 ? 1 : this.thisETFPlayerTexture.coatLength + 1;
                ETFUtils2.setPixel(this.currentEditorSkin, 52, 18, ETFConfigScreenSkinTool.getPixelColour(lengthChoice));
                this.thisETFPlayerTexture.changeSkinToThisForTool(this.currentEditorSkin);
                button.method_25355(class_2561.method_30163((String)(ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.coat_length.title").getString() + this.thisETFPlayerTexture.coatLength)));
            }, ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.coat_length.tooltip"));
            this.blinkButton = this.getETFButton((int)((double)this.field_22789 * 0.25), (int)((double)this.field_22790 * 0.4), (int)((double)this.field_22789 * 0.42), 20, BlinkType.get(this.thisETFPlayerTexture.blinkType).getTitle(), button -> {
                BlinkType blink = BlinkType.get(this.thisETFPlayerTexture.blinkType).next();
                button.method_25355(blink.getTitle());
                if (blink != BlinkType.NONE && blink != BlinkType.WHOLE_FACE_TWO && blink != BlinkType.WHOLE_FACE) {
                    ETFUtils2.setPixel(this.currentEditorSkin, 52, 19, ETFConfigScreenSkinTool.getPixelColour(0));
                } else if (ETFUtils2.getPixel(this.currentEditorSkin, 52, 19) > blink.getMaxEyePixelHeight()) {
                    ETFUtils2.setPixel(this.currentEditorSkin, 52, 19, ETFConfigScreenSkinTool.getPixelColour(blink.getMaxEyePixelHeight()));
                }
                class_2960 overlay = blink.getExampleOverlay();
                if (overlay != null) {
                    this.applyExistingOverlayToSkin(overlay);
                }
                ETFUtils2.setPixel(this.currentEditorSkin, 52, 16, blink.getBlinkPixelColour());
                this.thisETFPlayerTexture.changeSkinToThisForTool(this.currentEditorSkin);
                this.updateButtons();
            }, ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.blink_type.tooltip"));
            this.blinkHeightButton = this.getETFButton((int)((double)this.field_22789 * 0.695), (int)((double)this.field_22790 * 0.4), (int)((double)this.field_22789 * 0.275), 20, class_2561.method_30163((String)(ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.blink_height.title").getString() + this.thisETFPlayerTexture.blinkHeight)), button -> {
                int heightChoice = this.thisETFPlayerTexture.blinkHeight == BlinkType.get(this.thisETFPlayerTexture.blinkType).getMaxEyePixelHeight() ? 1 : this.thisETFPlayerTexture.blinkHeight + 1;
                ETFUtils2.setPixel(this.currentEditorSkin, 52, 19, ETFConfigScreenSkinTool.getPixelColour(heightChoice));
                this.thisETFPlayerTexture.changeSkinToThisForTool(this.currentEditorSkin);
                button.method_25355(class_2561.method_30163((String)(ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.blink_height.title").getString() + this.thisETFPlayerTexture.blinkHeight)));
            }, ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.blink_height.tooltip"));
            this.emissiveButton = this.getETFButton((int)((double)this.field_22789 * 0.25), (int)((double)this.field_22790 * 0.5), (int)((double)this.field_22789 * 0.42), 20, class_2561.method_30163((String)(ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.emissive_enable.button").getString() + (ETFUtils2.getPixel(this.currentEditorSkin, 1, 17) == ETFConfigScreenSkinTool.getPixelColour(1) ? class_5244.field_24332 : class_5244.field_24333).getString())), button -> {
                if (this.thisETFPlayerTexture.hasEmissives) {
                    ETFUtils2.setPixel(this.currentEditorSkin, 1, 17, 0);
                } else {
                    ETFUtils2.setPixel(this.currentEditorSkin, 1, 17, ETFConfigScreenSkinTool.getPixelColour(1));
                }
                this.thisETFPlayerTexture.changeSkinToThisForTool(this.currentEditorSkin);
                button.method_25355(class_2561.method_30163((String)(ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.emissive_enable.button").getString() + (ETFUtils2.getPixel(this.currentEditorSkin, 1, 17) == ETFConfigScreenSkinTool.getPixelColour(1) ? class_5244.field_24332 : class_5244.field_24333).getString())));
                this.updateButtons();
            }, ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.emissive_enable.tooltip"));
            this.emissiveSelectButton = this.getETFButton((int)((double)this.field_22789 * 0.695), (int)((double)this.field_22790 * 0.5), (int)((double)this.field_22789 * 0.275), 20, ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.emissive_select.button"), button -> Objects.requireNonNull(this.field_22787).method_1507((class_437)new ETFConfigScreenSkinToolPixelSelection(this, ETFConfigScreenSkinToolPixelSelection.SelectionMode.EMISSIVE)));
            this.enchantButton = this.getETFButton((int)((double)this.field_22789 * 0.25), (int)((double)this.field_22790 * 0.6), (int)((double)this.field_22789 * 0.42), 20, class_2561.method_30163((String)(ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.enchant_enable.button").getString() + (ETFUtils2.getPixel(this.currentEditorSkin, 1, 18) == ETFConfigScreenSkinTool.getPixelColour(2) ? class_5244.field_24332 : class_5244.field_24333).getString())), button -> {
                if (this.thisETFPlayerTexture.hasEnchant) {
                    ETFUtils2.setPixel(this.currentEditorSkin, 1, 18, 0);
                } else {
                    ETFUtils2.setPixel(this.currentEditorSkin, 1, 18, ETFConfigScreenSkinTool.getPixelColour(2));
                }
                this.thisETFPlayerTexture.changeSkinToThisForTool(this.currentEditorSkin);
                button.method_25355(class_2561.method_30163((String)(ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.enchant_enable.button").getString() + (ETFUtils2.getPixel(this.currentEditorSkin, 1, 18) == ETFConfigScreenSkinTool.getPixelColour(2) ? class_5244.field_24332 : class_5244.field_24333).getString())));
                this.updateButtons();
            }, ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.enchant_enable.tooltip"));
            this.enchantSelectButton = this.getETFButton((int)((double)this.field_22789 * 0.695), (int)((double)this.field_22790 * 0.6), (int)((double)this.field_22789 * 0.275), 20, ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.enchant_select.button"), button -> Objects.requireNonNull(this.field_22787).method_1507((class_437)new ETFConfigScreenSkinToolPixelSelection(this, ETFConfigScreenSkinToolPixelSelection.SelectionMode.ENCHANTED)));
            this.updateButtons();
            this.method_37063((class_364)this.villagerNoseButton);
            this.method_37063((class_364)this.coatButton);
            this.method_37063((class_364)this.coatLengthButton);
            this.method_37063((class_364)this.blinkButton);
            this.method_37063((class_364)this.blinkHeightButton);
            this.method_37063((class_364)this.emissiveButton);
            this.method_37063((class_364)this.emissiveSelectButton);
            this.method_37063((class_364)this.enchantButton);
            this.method_37063((class_364)this.enchantSelectButton);
            this.method_37063((class_364)this.transparencyButton);
        }
    }

    private void updateButtons() {
        boolean activeFeatures = this.thisETFPlayerTexture.hasFeatures;
        if (this.villagerNoseButton != null) {
            this.villagerNoseButton.field_22763 = activeFeatures;
            this.villagerNoseButton.method_25355(class_2561.method_30163((String)(ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.nose.button").getString() + this.thisETFPlayerTexture.noseType.getButtonText().getString())));
        }
        if (this.coatButton != null) {
            this.coatButton.field_22763 = activeFeatures;
            this.coatButton.method_25355(CoatStyle.get(this.thisETFPlayerTexture.coatStyle).getTitle());
        }
        if (this.coatLengthButton != null) {
            this.coatLengthButton.field_22763 = activeFeatures && CoatStyle.get(this.thisETFPlayerTexture.coatStyle) != CoatStyle.NONE;
            this.coatLengthButton.method_25355(class_2561.method_30163((String)(ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.coat_length.title").getString() + this.thisETFPlayerTexture.coatLength)));
        }
        if (this.blinkButton != null) {
            this.blinkButton.field_22763 = activeFeatures;
            this.blinkButton.method_25355(BlinkType.get(this.thisETFPlayerTexture.blinkType).getTitle());
        }
        if (this.blinkHeightButton != null) {
            this.blinkHeightButton.field_22763 = activeFeatures && BlinkType.get(this.thisETFPlayerTexture.blinkType) != BlinkType.NONE && BlinkType.get(this.thisETFPlayerTexture.blinkType) != BlinkType.WHOLE_FACE_TWO && BlinkType.get(this.thisETFPlayerTexture.blinkType) != BlinkType.WHOLE_FACE;
            this.blinkHeightButton.method_25355(class_2561.method_30163((String)(ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.blink_height.title").getString() + this.thisETFPlayerTexture.blinkHeight)));
        }
        if (this.emissiveButton != null) {
            this.emissiveButton.field_22763 = activeFeatures;
            this.emissiveButton.method_25355(class_2561.method_30163((String)(ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.emissive_enable.button").getString() + (ETFUtils2.getPixel(this.currentEditorSkin, 1, 17) == ETFConfigScreenSkinTool.getPixelColour(1) ? class_5244.field_24332 : class_5244.field_24333).getString())));
        }
        if (this.emissiveSelectButton != null) {
            boolean bl = this.emissiveSelectButton.field_22763 = activeFeatures && ETFUtils2.getPixel(this.currentEditorSkin, 1, 17) == ETFConfigScreenSkinTool.getPixelColour(1);
        }
        if (this.enchantButton != null) {
            this.enchantButton.field_22763 = activeFeatures;
            this.enchantButton.method_25355(class_2561.method_30163((String)(ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.enchant_enable.button").getString() + (ETFUtils2.getPixel(this.currentEditorSkin, 1, 18) == ETFConfigScreenSkinTool.getPixelColour(2) ? class_5244.field_24332 : class_5244.field_24333).getString())));
        }
        if (this.enchantSelectButton != null) {
            boolean bl = this.enchantSelectButton.field_22763 = activeFeatures && ETFUtils2.getPixel(this.currentEditorSkin, 1, 18) == ETFConfigScreenSkinTool.getPixelColour(2);
        }
        if (this.transparencyButton != null) {
            this.transparencyButton.field_22763 = activeFeatures;
            this.transparencyButton.method_25355(class_2561.method_30163((String)(ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.transparency.button").getString() + ETFConfigScreenSkinTool.booleanAsOnOff(!this.thisETFPlayerTexture.wasForcedSolid))));
        }
    }

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        class_746 player = class_310.method_1551().field_1724;
        if (player != null) {
            int height = (int)((double)this.field_22790 * 0.75);
            int playerX = (int)((double)this.field_22789 * 0.14);
            this.drawEntity(context, playerX, height, (int)((double)this.field_22790 * 0.3), mouseX, mouseY, (class_1309)player);
        } else {
            context.method_27535(this.field_22793, class_2561.method_30163((String)"Player is null for some reason!"), this.field_22789 / 7, (int)((double)this.field_22790 * 0.4), 0xFFFFFF);
            context.method_27535(this.field_22793, class_2561.method_30163((String)"Cannot load player to render!"), this.field_22789 / 7, (int)((double)this.field_22790 * 0.45), 0xFFFFFF);
        }
        context.method_27535(this.field_22793, ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.crouch_message"), this.field_22789 / 40, (int)((double)this.field_22790 * 0.8), 0x555555);
        context.method_27535(this.field_22793, ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.blink_message"), this.field_22789 / 40, (int)((double)this.field_22790 * 0.1), 0x555555);
    }

    public void applyExistingOverlayToSkin(class_2960 overlayTexture) {
        if (ETF.isFabric() == ETF.isThisModLoaded("fabric")) {
            class_1011 overlayImage = ETFUtils2.getNativeImageElseNull(overlayTexture);
            assert (overlayImage != null);
            if (!overlayTexture.equals((Object)REMOVE_OVERLAY) && !overlayTexture.equals((Object)APPLY_OVERLAY)) {
                if (this.allowOverrides == null) {
                    class_310.method_1551().method_1507((class_437)new ConfirmScreen(class_2561.method_30163((String)""), this));
                    if (this.allowOverrides == null) {
                        this.allowOverrides = false;
                    }
                }
                if (!this.allowOverrides.booleanValue()) {
                    ETFUtils2.logMessage("Skin example overlay [" + String.valueOf(overlayTexture) + "] not applied.", false);
                    return;
                }
            }
            try {
                for (int x = 0; x < this.currentEditorSkin.method_4307(); ++x) {
                    for (int y = 0; y < this.currentEditorSkin.method_4323(); ++y) {
                        if (ETFUtils2.getPixel(overlayImage, x, y) == 0) continue;
                        ETFUtils2.setPixel(this.currentEditorSkin, x, y, ETFUtils2.getPixel(overlayImage, x, y));
                    }
                }
            }
            catch (Exception e) {
                ETFUtils2.logMessage("Skin feature layout could not be applied to a copy of your skin. Error written to log.", false);
                ETFUtils2.logError(e.toString(), false);
            }
        } else {
            ETFUtils2.logError("Fabric API required for skin processing, cancelling.", false);
        }
    }

    public boolean printPlayerSkinCopy() {
        if (ETF.isFabric() == ETF.isThisModLoaded("fabric") && ETF.getConfigDirectory() != null) {
            Path outputDirectory = Path.of(ETF.getConfigDirectory().toFile().getParent(), "\\ETF_player_skin_printout.png");
            try {
                this.currentEditorSkin.method_4314(outputDirectory);
                ETFUtils2.logMessage(ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.print_skin.result.success").getString(), false);
                return true;
            }
            catch (Exception e) {
                ETFUtils2.logError(e.toString(), false);
            }
        }
        return false;
    }

    public static void renderEntityInInventoryFollowsMouse(boolean flipView, class_332 guiGraphics, int i, int j, int k, int l, int m, float f, float g, float h, class_1309 livingEntity) {
        float n = (float)(i + k) / 2.0f;
        float o = (float)(j + l) / 2.0f;
        guiGraphics.method_44379(i, j, k, l);
        float p = (float)Math.atan((n - g) / 40.0f);
        float q = (float)Math.atan((o - h) / 40.0f);
        Quaternionf quaternionf = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf quaternionf2 = new Quaternionf().rotateX(q * 20.0f * ((float)Math.PI / 180));
        quaternionf.mul((Quaternionfc)quaternionf2);
        float r = livingEntity.field_6283;
        float s = livingEntity.method_36454();
        float t = livingEntity.method_36455();
        float u = livingEntity.field_6259;
        float v = livingEntity.field_6241;
        livingEntity.field_6283 = (flipView ? 0.0f : 180.0f) + p * 20.0f;
        livingEntity.method_36456((flipView ? 0.0f : 180.0f) + p * 40.0f);
        livingEntity.method_36457(-q * 20.0f);
        livingEntity.field_6241 = livingEntity.method_36454();
        livingEntity.field_6259 = livingEntity.method_36454();
        float w = livingEntity.method_55693();
        Vector3f vector3f = new Vector3f(0.0f, livingEntity.method_17682() / 2.0f + f * w, 0.0f);
        float x = (float)m / w;
        class_490.method_48472((class_1309)livingEntity);
        livingEntity.field_6283 = r;
        livingEntity.method_36456(s);
        livingEntity.method_36457(t);
        livingEntity.field_6259 = u;
        livingEntity.field_6241 = v;
        guiGraphics.method_44380();
    }

    public void drawEntity(class_332 context, int x, int y, int size, float mouseX, float mouseY, class_1309 entity) {
        ETFConfigScreenSkinTool.renderEntityInInventoryFollowsMouse(this.flipView, context, 0, (int)((double)this.field_22790 * 0.15), x * 2, y, size, 0.0625f, mouseX + (float)((int)((double)this.field_22790 * 0.15)), mouseY, entity);
    }

    public static enum NoseType {
        VILLAGER(1, ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.nose.villager")),
        VILLAGER_TEXTURED(7, ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.nose.villager2")),
        VILLAGER_REMOVE(8, ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.nose.villager3")),
        VILLAGER_TEXTURED_REMOVE(9, ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.nose.villager4")),
        TEXTURED_1(2, ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.nose.textured.1")),
        TEXTURED_2(3, ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.nose.textured.2")),
        TEXTURED_3(4, ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.nose.textured.3")),
        TEXTURED_4(5, ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.nose.textured.4")),
        TEXTURED_5(6, ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.nose.textured.5")),
        NONE(0, ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.nose.none"));

        public final int id;
        private final class_2561 buttonText;

        private NoseType(int i, class_2561 buttonText) {
            this.id = i;
            this.buttonText = buttonText;
        }

        public NoseType getByColorId(int id) {
            for (NoseType nose : NoseType.values()) {
                if (nose.id != id) continue;
                return nose;
            }
            return NONE;
        }

        public boolean appliesTextureOverlay() {
            return this == TEXTURED_1 || this == TEXTURED_2 || this == TEXTURED_3 || this == TEXTURED_4 || this == TEXTURED_5;
        }

        public class_2561 getButtonText() {
            return this.buttonText;
        }

        public NoseType next() {
            switch (this.ordinal()) {
                case 9: {
                    return VILLAGER;
                }
                case 0: {
                    return VILLAGER_TEXTURED;
                }
                case 1: {
                    return VILLAGER_REMOVE;
                }
                case 2: {
                    return VILLAGER_TEXTURED_REMOVE;
                }
                case 3: {
                    return TEXTURED_1;
                }
                case 4: {
                    return TEXTURED_2;
                }
                case 5: {
                    return TEXTURED_3;
                }
                case 6: {
                    return TEXTURED_4;
                }
                case 7: {
                    return TEXTURED_5;
                }
            }
            return NONE;
        }

        public int getNosePixelColour() {
            return ETFPlayerTexture.getSkinNumberToPixelColour(this.id);
        }
    }

    public static enum CoatStyle {
        COPIED_THIN_TOP,
        MOVED_THIN_TOP,
        COPIED_FAT_TOP,
        MOVED_FAT_TOP,
        COPIED_THIN,
        MOVED_THIN,
        COPIED_FAT,
        MOVED_FAT,
        NONE;


        public static CoatStyle get(int id) {
            switch (id) {
                case 1: {
                    return COPIED_THIN_TOP;
                }
                case 2: {
                    return MOVED_THIN_TOP;
                }
                case 3: {
                    return COPIED_FAT_TOP;
                }
                case 4: {
                    return MOVED_FAT_TOP;
                }
                case 5: {
                    return COPIED_THIN;
                }
                case 6: {
                    return MOVED_THIN;
                }
                case 7: {
                    return COPIED_FAT;
                }
                case 8: {
                    return MOVED_FAT;
                }
            }
            return NONE;
        }

        public class_2561 getTitle() {
            switch (this.ordinal()) {
                case 0: {
                    return ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.coat_style.1");
                }
                case 1: {
                    return ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.coat_style.2");
                }
                case 2: {
                    return ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.coat_style.3");
                }
                case 3: {
                    return ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.coat_style.4");
                }
                case 4: {
                    return ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.coat_style.5");
                }
                case 5: {
                    return ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.coat_style.6");
                }
                case 6: {
                    return ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.coat_style.7");
                }
                case 7: {
                    return ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.coat_style.8");
                }
            }
            return ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.coat_style.none");
        }

        public int getCoatPixelColour() {
            switch (this.ordinal()) {
                case 0: {
                    return -65281;
                }
                case 1: {
                    return -256;
                }
                case 2: {
                    return -16776961;
                }
                case 3: {
                    return -16711936;
                }
                case 4: {
                    return -16760705;
                }
                case 5: {
                    return -65536;
                }
                case 6: {
                    return -16744449;
                }
                case 7: {
                    return -14483457;
                }
            }
            return 0;
        }

        public CoatStyle next() {
            switch (this.ordinal()) {
                case 8: {
                    return COPIED_THIN_TOP;
                }
                case 0: {
                    return MOVED_THIN_TOP;
                }
                case 1: {
                    return COPIED_FAT_TOP;
                }
                case 2: {
                    return MOVED_FAT_TOP;
                }
                case 3: {
                    return COPIED_THIN;
                }
                case 4: {
                    return MOVED_THIN;
                }
                case 5: {
                    return COPIED_FAT;
                }
                case 6: {
                    return MOVED_FAT;
                }
            }
            return NONE;
        }
    }

    public static enum BlinkType {
        ONE_PIXEL,
        TWO_PIXEL,
        FOUR_PIXEL,
        WHOLE_FACE,
        WHOLE_FACE_TWO,
        NONE;


        public static BlinkType get(int id) {
            switch (id) {
                case 3: {
                    return ONE_PIXEL;
                }
                case 4: {
                    return TWO_PIXEL;
                }
                case 5: {
                    return FOUR_PIXEL;
                }
                case 1: {
                    return WHOLE_FACE;
                }
                case 2: {
                    return WHOLE_FACE_TWO;
                }
            }
            return NONE;
        }

        public class_2960 getExampleOverlay() {
            return switch (this.ordinal()) {
                case 3, 4 -> WHOLE_FACE_OVERLAY;
                case 5 -> null;
                default -> SMALL_EYE_OVERLAY;
            };
        }

        public class_2561 getTitle() {
            switch (this.ordinal()) {
                case 0: {
                    return ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.blink_type.1");
                }
                case 1: {
                    return ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.blink_type.2");
                }
                case 2: {
                    return ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.blink_type.4");
                }
                case 3: {
                    return ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.blink_type.whole.1");
                }
                case 4: {
                    return ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.blink_type.whole.2");
                }
            }
            return ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.blink_type.none");
        }

        public int getBlinkPixelColour() {
            switch (this.ordinal()) {
                case 0: {
                    return ETFConfigScreenSkinTool.getPixelColour(3);
                }
                case 1: {
                    return ETFConfigScreenSkinTool.getPixelColour(4);
                }
                case 2: {
                    return ETFConfigScreenSkinTool.getPixelColour(5);
                }
                case 3: {
                    return ETFConfigScreenSkinTool.getPixelColour(1);
                }
                case 4: {
                    return ETFConfigScreenSkinTool.getPixelColour(2);
                }
            }
            return 0;
        }

        public int getMaxEyePixelHeight() {
            switch (this.ordinal()) {
                case 0: {
                    return 8;
                }
                case 1: {
                    return 7;
                }
                case 2: {
                    return 5;
                }
            }
            return 1;
        }

        public BlinkType next() {
            switch (this.ordinal()) {
                case 5: {
                    return ONE_PIXEL;
                }
                case 0: {
                    return TWO_PIXEL;
                }
                case 1: {
                    return FOUR_PIXEL;
                }
                case 2: {
                    return WHOLE_FACE;
                }
                case 3: {
                    return WHOLE_FACE_TWO;
                }
            }
            return NONE;
        }
    }

    private class ConfirmScreen
    extends class_437 {
        final class_437 parent;

        protected ConfirmScreen(class_2561 title, class_437 parent) {
            super(title);
            this.parent = parent;
        }

        public void method_25419() {
            if (ETFConfigScreenSkinTool.this.overridesButton == null) {
                ETFConfigScreenSkinTool.this.allowOverrides = false;
            } else {
                ETFConfigScreenSkinTool.this.overridesButton.method_25306((class_11907)new class_11909((double)ETFConfigScreenSkinTool.this.overridesButton.method_46426(), (double)ETFConfigScreenSkinTool.this.overridesButton.method_46427(), new class_11910(1, 0)));
            }
            class_310.method_1551().method_1507(this.parent);
        }

        public boolean method_25422() {
            return true;
        }

        protected void method_25426() {
            super.method_25426();
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24336, button -> {
                ETFConfigScreenSkinTool.this.allowOverrides = true;
                class_310.method_1551().method_1507(this.parent);
            }).method_46434(this.field_22789 / 2 - 210, this.field_22790 / 2 + 50, 200, 20).method_46431());
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24337, button -> this.method_25419()).method_46434(this.field_22789 / 2 + 10, this.field_22790 / 2 + 50, 200, 20).method_46431());
        }

        public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
            super.method_25394(context, mouseX, mouseY, delta);
            context.method_27534(this.field_22793, ETF.getTextFromTranslation("config.entity_texture_features.skin_editor.overlays.1"), this.field_22789 / 2, this.field_22790 / 2, -1);
            context.method_27534(this.field_22793, ETF.getTextFromTranslation("config.entity_texture_features.skin_editor.overlays.2"), this.field_22789 / 2, this.field_22790 / 2 + 11, -1);
            context.method_27534(this.field_22793, ETF.getTextFromTranslation("config.entity_texture_features.skin_editor.overlays.3"), this.field_22789 / 2, this.field_22790 / 2 + 22, -1);
        }
    }
}

