/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util.data.tag.util;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import fi.dy.masa.malilib.util.data.tag.ArrayData;
import fi.dy.masa.malilib.util.data.tag.BaseData;
import fi.dy.masa.malilib.util.data.tag.ByteArrayData;
import fi.dy.masa.malilib.util.data.tag.ByteData;
import fi.dy.masa.malilib.util.data.tag.CompoundData;
import fi.dy.masa.malilib.util.data.tag.DoubleData;
import fi.dy.masa.malilib.util.data.tag.EmptyData;
import fi.dy.masa.malilib.util.data.tag.FloatData;
import fi.dy.masa.malilib.util.data.tag.IntArrayData;
import fi.dy.masa.malilib.util.data.tag.IntData;
import fi.dy.masa.malilib.util.data.tag.ListData;
import fi.dy.masa.malilib.util.data.tag.LongArrayData;
import fi.dy.masa.malilib.util.data.tag.LongData;
import fi.dy.masa.malilib.util.data.tag.ShortData;
import fi.dy.masa.malilib.util.data.tag.StringData;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.class_156;

public class DataOps
implements DynamicOps<BaseData> {
    public static final DataOps INSTANCE = new DataOps();

    private DataOps() {
    }

    public BaseData empty() {
        return EmptyData.INSTANCE;
    }

    public BaseData emptyList() {
        return new ListData();
    }

    public BaseData emptyMap() {
        return new CompoundData();
    }

    public String toString() {
        return "DATA";
    }

    public <U> U convertTo(DynamicOps<U> ops, BaseData data) {
        return (U)(switch (data.getType()) {
            case 1 -> ops.createByte(((ByteData)data).value);
            case 2 -> ops.createShort(((ShortData)data).value);
            case 3 -> ops.createInt(((IntData)data).value);
            case 4 -> ops.createLong(((LongData)data).value);
            case 5 -> ops.createFloat(((FloatData)data).value);
            case 6 -> ops.createDouble(((DoubleData)data).value);
            case 8 -> ops.createString(((StringData)data).value);
            case 7 -> ops.createByteList(ByteBuffer.wrap(((ByteArrayData)data).value));
            case 11 -> ops.createIntList(Arrays.stream(((IntArrayData)data).value));
            case 12 -> ops.createLongList(Arrays.stream(((LongArrayData)data).value));
            case 10 -> this.convertMap(ops, data);
            case 9 -> this.convertList(ops, data);
            case 0 -> ops.empty();
            default -> throw new RuntimeException("(DataOps) Invalid data type: " + data.getType());
        });
    }

    public BaseData createNumeric(Number number) {
        return new DoubleData(number.doubleValue());
    }

    public DataResult<Number> getNumberValue(BaseData data) {
        return data.asNumber().map(DataResult::success).orElseGet(() -> DataResult.error(() -> "(DataOps) Not a number: " + data.toString()));
    }

    public Number getNumberValue(BaseData data, Number defaultValue) {
        DataResult<Number> result = this.getNumberValue(data);
        if (result.hasResultOrPartial()) {
            return (Number)result.getPartialOrThrow();
        }
        return defaultValue;
    }

    public BaseData createByte(byte value) {
        return new ByteData(value);
    }

    public BaseData createShort(short value) {
        return new ShortData(value);
    }

    public BaseData createInt(int value) {
        return new IntData(value);
    }

    public BaseData createLong(long value) {
        return new LongData(value);
    }

    public BaseData createFloat(float value) {
        return new FloatData(value);
    }

    public BaseData createDouble(double value) {
        return new DoubleData(value);
    }

    public BaseData createBoolean(boolean value) {
        return new ByteData((byte)(value ? 1 : 0));
    }

    public DataResult<Boolean> getBooleanValue(BaseData data) {
        byte value;
        if (data.getType() == 1 && ((value = ((ByteData)data).value) == 0 || value == 1)) {
            return DataResult.success((Object)(value == 1 ? 1 : 0));
        }
        return DataResult.error(() -> "(DataOps) Not a boolean: " + data.toString());
    }

    public BaseData createString(String s) {
        return new StringData(s);
    }

    public DataResult<String> getStringValue(BaseData data) {
        if (data.getType() == 8) {
            return DataResult.success((Object)((StringData)data).value);
        }
        return DataResult.error(() -> "(DataOps) Not a string: " + data.toString());
    }

    public DataResult<BaseData> mergeToList(BaseData data, BaseData entry) {
        return DataOps.createArrayFactory(data).map(factory -> DataResult.success((Object)factory.accept(entry).result())).orElseGet(() -> DataResult.error(() -> "(DataOps) Not a list: " + data.toString()));
    }

    public DataResult<BaseData> mergeToList(BaseData data, List<BaseData> entry) {
        return DataOps.createArrayFactory(data).map(factory -> DataResult.success((Object)factory.acceptAll(entry).result())).orElseGet(() -> DataResult.error(() -> "(DataOps) Not a list: " + data.toString()));
    }

    public DataResult<BaseData> mergeToMap(BaseData data, BaseData key, BaseData entry) {
        if (data.getType() != 10 && data.getType() != 0) {
            return DataResult.error(() -> "(DataOps) Not a Map: " + data.toString());
        }
        if (key.getType() == 8) {
            CompoundData compoundData;
            String keyValue = ((StringData)key).value;
            if (data instanceof CompoundData) {
                CompoundData comp = (CompoundData)data;
                compoundData = comp.copy();
            } else {
                compoundData = new CompoundData();
            }
            CompoundData compoundData2 = compoundData;
            compoundData2.put(keyValue, entry);
            return DataResult.success((Object)compoundData2);
        }
        return DataResult.error(() -> "(DataOps) Not a String key: " + key.toString());
    }

    public DataResult<BaseData> mergeToMap(BaseData data, MapLike<BaseData> mapLike) {
        CompoundData compoundData;
        if (data.getType() != 10 && data.getType() != 0) {
            return DataResult.error(() -> "(DataOps) Not a Map: " + data.toString());
        }
        Iterator iter = mapLike.entries().iterator();
        if (!iter.hasNext()) {
            return data == this.empty() ? DataResult.success((Object)this.emptyMap()) : DataResult.success((Object)data);
        }
        if (data instanceof CompoundData) {
            CompoundData comp = (CompoundData)data;
            compoundData = comp.copy();
        } else {
            compoundData = new CompoundData();
        }
        CompoundData compoundData2 = compoundData;
        ArrayList list = new ArrayList();
        iter.forEachRemaining(pair -> {
            BaseData entry = (BaseData)pair.getFirst();
            if (entry.getType() == 8) {
                compoundData2.put(((StringData)pair.getFirst()).value, (BaseData)pair.getSecond());
            } else {
                list.add(entry);
            }
        });
        return !list.isEmpty() ? DataResult.error(() -> "(DataOps) Some keys are not strings: " + list.toString(), (Object)compoundData2) : DataResult.success((Object)compoundData2);
    }

    public DataResult<BaseData> mergeToMap(BaseData data, Map<BaseData, BaseData> map) {
        CompoundData compoundData;
        if (data.getType() != 10 && data.getType() != 0) {
            return DataResult.error(() -> "(DataOps) Not a Map: " + data.toString());
        }
        if (map.isEmpty()) {
            return data == this.empty() ? DataResult.success((Object)this.emptyMap()) : DataResult.success((Object)data);
        }
        if (data instanceof CompoundData) {
            CompoundData comp = (CompoundData)data;
            compoundData = comp.copy();
        } else {
            compoundData = new CompoundData();
        }
        CompoundData compoundData2 = compoundData;
        ArrayList<BaseData> list = new ArrayList<BaseData>();
        for (Map.Entry<BaseData, BaseData> entry : map.entrySet()) {
            BaseData key = entry.getKey();
            if (key.getType() == 8) {
                compoundData2.put(((StringData)key).value, entry.getValue());
                continue;
            }
            list.add(key);
        }
        return !list.isEmpty() ? DataResult.error(() -> "(DataOps) Some keys are not strings: " + list.toString(), (Object)compoundData2) : DataResult.success((Object)compoundData2);
    }

    public DataResult<Stream<Pair<BaseData, BaseData>>> getMapValues(BaseData data) {
        if (data.getType() == 10) {
            return DataResult.success(((CompoundData)data).entrySet().stream().map(ent -> Pair.of((Object)this.createString((String)ent.getKey()), (Object)((BaseData)ent.getValue()))));
        }
        return DataResult.error(() -> "(DataOps) Not a Map: " + data.toString());
    }

    public DataResult<Consumer<BiConsumer<BaseData, BaseData>>> getMapEntries(BaseData data) {
        if (data.getType() == 10) {
            return DataResult.success(biCons -> {
                for (Map.Entry<String, BaseData> entry : ((CompoundData)data).entrySet()) {
                    biCons.accept(this.createString(entry.getKey()), entry.getValue());
                }
            });
        }
        return DataResult.error(() -> "(DataOps) Not a Map: " + data.toString());
    }

    public DataResult<MapLike<BaseData>> getMap(BaseData data) {
        if (data.getType() == 10) {
            final CompoundData comp = (CompoundData)data;
            return DataResult.success((Object)new MapLike<BaseData>(){

                @Nullable
                public BaseData get(BaseData key) {
                    if (key.getType() == 8) {
                        return comp.getData(((StringData)key).value).orElse(null);
                    }
                    throw new RuntimeException("(DataOps) Key is not a string: " + key.toString());
                }

                @Nullable
                public BaseData get(String key) {
                    return comp.getData(key).orElse(null);
                }

                public Stream<Pair<BaseData, BaseData>> entries() {
                    return comp.entrySet().stream().map(entry -> Pair.of((Object)DataOps.this.createString((String)entry.getKey()), (Object)((BaseData)entry.getValue())));
                }
            });
        }
        return DataResult.error(() -> "(DataOps) Not a Map: " + data.toString());
    }

    public BaseData createMap(Stream<Pair<BaseData, BaseData>> stream) {
        CompoundData data = new CompoundData();
        stream.forEach(pair -> {
            BaseData key = (BaseData)pair.getFirst();
            BaseData value = (BaseData)pair.getSecond();
            if (key.getType() != 8) {
                throw new RuntimeException("(DataOps) Key is not a string: " + key.toString());
            }
            data.put(((StringData)key).value, value);
        });
        return data;
    }

    public DataResult<Stream<BaseData>> getStream(BaseData data) {
        if (data instanceof ArrayData) {
            ArrayData array = (ArrayData)((Object)data);
            return DataResult.success(array.stream());
        }
        return DataResult.error(() -> "(DataOps) Not an Array: " + data.toString());
    }

    public DataResult<Consumer<Consumer<BaseData>>> getList(BaseData data) {
        if (data instanceof ArrayData) {
            ArrayData array = (ArrayData)((Object)data);
            return DataResult.success(array::forEach);
        }
        return DataResult.error(() -> "(DataOps) Not a List: " + data.toString());
    }

    public BaseData createList(Stream<BaseData> stream) {
        return new ListData((ArrayList)stream.collect(class_156.method_58579()));
    }

    public DataResult<ByteBuffer> getByteBuffer(BaseData data) {
        if (data.getType() == 7) {
            return DataResult.success((Object)ByteBuffer.wrap(((ByteArrayData)data).value));
        }
        return super.getByteBuffer((Object)data);
    }

    public BaseData createByteList(ByteBuffer buf) {
        ByteBuffer buffer = buf.duplicate().clear();
        byte[] bs = new byte[buf.capacity()];
        buffer.get(0, bs, 0, bs.length);
        return new ByteArrayData(bs);
    }

    public DataResult<IntStream> getIntStream(BaseData data) {
        if (data.getType() == 11) {
            return DataResult.success((Object)Arrays.stream(((IntArrayData)data).value));
        }
        return super.getIntStream((Object)data);
    }

    public BaseData createIntList(IntStream stream) {
        return new IntArrayData(stream.toArray());
    }

    public DataResult<LongStream> getLongStream(BaseData data) {
        if (data.getType() == 12) {
            return DataResult.success((Object)Arrays.stream(((LongArrayData)data).value));
        }
        return super.getLongStream((Object)data);
    }

    public BaseData createLongList(LongStream stream) {
        return new LongArrayData(stream.toArray());
    }

    public RecordBuilder<BaseData> mapBuilder() {
        return new Builder(this);
    }

    @Nullable
    public BaseData remove(BaseData data, String key) {
        if (data.getType() == 10) {
            return ((CompoundData)data).getData(key).orElse(null);
        }
        return null;
    }

    private static Optional<ArrayFactory> createArrayFactory(BaseData data) {
        if (data.getType() == 0) {
            return Optional.of(new GenericArrayFactory());
        }
        if (data.getType() == 9) {
            return Optional.of(new GenericArrayFactory((ListData)data));
        }
        if (data.getType() == 7) {
            return Optional.of(new ByteArrayFactory(((ByteArrayData)data).value));
        }
        if (data.getType() == 11) {
            return Optional.of(new IntArrayFactory(((IntArrayData)data).value));
        }
        if (data.getType() == 12) {
            return Optional.of(new LongArrayFactory(((LongArrayData)data).value));
        }
        return Optional.empty();
    }

    private class Builder
    extends RecordBuilder.AbstractStringBuilder<BaseData, CompoundData> {
        protected Builder(DataOps dataOps) {
            super((DynamicOps)dataOps);
        }

        protected CompoundData initBuilder() {
            return new CompoundData();
        }

        protected CompoundData append(String key, BaseData value, CompoundData data) {
            data.put(key, value);
            return data;
        }

        protected DataResult<BaseData> build(CompoundData data, BaseData prefix) {
            if (prefix == null || prefix.getType() == 0) {
                return DataResult.success((Object)data);
            }
            if (prefix.getType() != 10) {
                return DataResult.error(() -> "(DataOps) Not a map: " + prefix.toString());
            }
            CompoundData result = ((CompoundData)prefix).copy();
            for (Map.Entry<String, BaseData> entry : data.entrySet()) {
                result.put(entry.getKey(), entry.getValue().copy());
            }
            return DataResult.success((Object)result);
        }
    }

    private static class GenericArrayFactory
    implements ArrayFactory {
        private final ListData listData = new ListData();

        public GenericArrayFactory() {
        }

        public GenericArrayFactory(ListData listData) {
            this.listData.add(listData);
        }

        public GenericArrayFactory(IntArrayList list) {
            list.forEach(i -> this.listData.add(new IntData(i)));
        }

        public GenericArrayFactory(ByteArrayList list) {
            list.forEach(b -> this.listData.add(new ByteData(b)));
        }

        public GenericArrayFactory(LongArrayList list) {
            list.forEach(l -> this.listData.add(new LongData(l)));
        }

        @Override
        public ArrayFactory accept(BaseData data) {
            this.listData.add(data);
            return this;
        }

        @Override
        public BaseData result() {
            return this.listData;
        }
    }

    private static class ByteArrayFactory
    implements ArrayFactory {
        private final ByteArrayList values = new ByteArrayList();

        public ByteArrayFactory(byte[] bs) {
            this.values.addElements(0, bs);
        }

        @Override
        public ArrayFactory accept(BaseData data) {
            if (data.getType() == 1) {
                this.values.add(((ByteData)data).value);
                return this;
            }
            return new GenericArrayFactory(this.values).accept(data);
        }

        @Override
        public BaseData result() {
            return new ByteArrayData(this.values.toByteArray());
        }
    }

    private static class IntArrayFactory
    implements ArrayFactory {
        private final IntArrayList values = new IntArrayList();

        public IntArrayFactory(int[] is) {
            this.values.addElements(0, is);
        }

        @Override
        public ArrayFactory accept(BaseData data) {
            if (data.getType() == 3) {
                this.values.add(((IntData)data).value);
                return this;
            }
            return new GenericArrayFactory(this.values).accept(data);
        }

        @Override
        public BaseData result() {
            return new IntArrayData(this.values.toIntArray());
        }
    }

    private static class LongArrayFactory
    implements ArrayFactory {
        private final LongArrayList values = new LongArrayList();

        public LongArrayFactory(long[] ls) {
            this.values.addElements(0, ls);
        }

        @Override
        public ArrayFactory accept(BaseData data) {
            if (data.getType() == 4) {
                this.values.add(((LongData)data).value);
                return this;
            }
            return new GenericArrayFactory(this.values).accept(data);
        }

        @Override
        public BaseData result() {
            return new LongArrayData(this.values.toLongArray());
        }
    }

    private static interface ArrayFactory {
        public ArrayFactory accept(BaseData var1);

        default public ArrayFactory acceptAll(Iterable<BaseData> iterable) {
            ArrayFactory listFactory = this;
            for (BaseData data : iterable) {
                listFactory = listFactory.accept(data);
            }
            return listFactory;
        }

        default public ArrayFactory acceptAll(Stream<BaseData> stream) {
            return this.acceptAll(stream::iterator);
        }

        public BaseData result();
    }
}

