/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer.shapes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import fi.dy.masa.malilib.util.JsonUtils;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.malilib.util.data.Color4f;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.renderer.shapes.ShapeSpawnSphere;
import fi.dy.masa.minihud.renderer.shapes.ShapeType;
import fi.dy.masa.minihud.util.shape.SphereUtils;
import java.util.List;
import net.minecraft.class_2350;
import net.minecraft.class_243;

public class ShapeSpawnSphereClippedY
extends ShapeSpawnSphere {
    private double topTrim = 0.0;
    private double bottomTrim = 0.0;

    public ShapeSpawnSphereClippedY() {
        this(ShapeType.CLIPPED_SPAWN_SPHERE_Y, Configs.Colors.SHAPE_ADJUSTABLE_SPAWN_SPHERE.getColor(), 24.0);
    }

    public ShapeSpawnSphereClippedY(ShapeType shape, Color4f color, double radius) {
        super(shape, color, radius);
    }

    public double getTopTrim() {
        return this.topTrim;
    }

    public double getBottomTrim() {
        return this.bottomTrim;
    }

    public void setTopTrim(double v) {
        this.topTrim = Math.max(0.0, v);
        this.setNeedsUpdate();
    }

    public void setBottomTrim(double v) {
        this.bottomTrim = Math.max(0.0, v);
        this.setNeedsUpdate();
    }

    @Override
    protected SphereUtils.RingPositionTest getPositionTest() {
        return this::isInsideSphereWithYClip;
    }

    private boolean isInsideSphereWithYClip(int x, int y, int z, class_2350 outSide) {
        class_243 c = this.getEffectiveCenter();
        double r = this.getRadius();
        double minY = c.field_1351 - (r - this.bottomTrim);
        double maxY = c.field_1351 + (r - this.topTrim);
        double py = (double)y + 0.5;
        if (py < minY || py > maxY) {
            return false;
        }
        return super.getPositionTest().isInsideOrCloserThan(x, y, z, outSide);
    }

    @Override
    public List<String> getWidgetHoverLines() {
        List<String> lines = super.getWidgetHoverLines();
        lines.add(4, StringUtils.translate((String)"minihud.gui.hover.shape.clip_top_value", (Object[])new Object[]{ShapeSpawnSphereClippedY.d2(this.topTrim)}));
        lines.add(5, StringUtils.translate((String)"minihud.gui.hover.shape.clip_bottom_value", (Object[])new Object[]{ShapeSpawnSphereClippedY.d2(this.bottomTrim)}));
        return lines;
    }

    @Override
    public JsonObject toJson() {
        JsonObject obj = super.toJson();
        obj.add("top_trim", (JsonElement)new JsonPrimitive((Number)this.topTrim));
        obj.add("bottom_trim", (JsonElement)new JsonPrimitive((Number)this.bottomTrim));
        return obj;
    }

    @Override
    public void fromJson(JsonObject obj) {
        super.fromJson(obj);
        if (JsonUtils.hasDouble((JsonObject)obj, (String)"top_trim")) {
            this.topTrim = JsonUtils.getDouble((JsonObject)obj, (String)"top_trim");
        }
        if (JsonUtils.hasDouble((JsonObject)obj, (String)"bottom_trim")) {
            this.bottomTrim = JsonUtils.getDouble((JsonObject)obj, (String)"bottom_trim");
        }
        this.setNeedsUpdate();
    }
}

