/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer;

import fi.dy.masa.malilib.util.EntityUtils;
import fi.dy.masa.malilib.util.IntBoundingBox;
import fi.dy.masa.malilib.util.LayerRange;
import fi.dy.masa.malilib.util.data.Color4f;
import fi.dy.masa.malilib.util.position.PositionUtils;
import fi.dy.masa.minihud.renderer.shapes.SideQuad;
import fi.dy.masa.minihud.util.ShapeRenderType;
import fi.dy.masa.minihud.util.shape.SphereUtils;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_310;

public class RenderUtils {
    public static List<class_238> calculateBoxes(class_2338 posStart, class_2338 posEnd) {
        double minZ;
        double maxZ;
        double maxX;
        double minX;
        class_1297 entity = EntityUtils.getCameraEntity();
        if (entity == null) {
            return List.of();
        }
        int boxMinX = Math.min(posStart.method_10263(), posEnd.method_10263());
        int boxMinZ = Math.min(posStart.method_10260(), posEnd.method_10260());
        int boxMaxX = Math.max(posStart.method_10263(), posEnd.method_10263());
        int boxMaxZ = Math.max(posStart.method_10260(), posEnd.method_10260());
        int centerX = (int)Math.floor(entity.method_23317());
        int centerZ = (int)Math.floor(entity.method_23321());
        int maxDist = (Integer)class_310.method_1551().field_1690.method_42503().method_41753() * 32;
        int rangeMinX = centerX - maxDist;
        int rangeMinZ = centerZ - maxDist;
        int rangeMaxX = centerX + maxDist;
        int rangeMaxZ = centerZ + maxDist;
        double minY = Math.min(posStart.method_10264(), posEnd.method_10264());
        double maxY = Math.max(posStart.method_10264(), posEnd.method_10264()) + 1;
        ArrayList<class_238> boxes = new ArrayList<class_238>();
        if (rangeMinX <= boxMaxX && rangeMaxX >= boxMinX) {
            minX = Math.max(boxMinX, rangeMinX);
            maxX = Math.min(boxMaxX, rangeMaxX) + 1;
            if (rangeMinZ <= boxMinZ && rangeMaxZ >= boxMinZ) {
                minZ = maxZ = (double)boxMinZ;
                boxes.add(new class_238(minX, minY, minZ, maxX, maxY, maxZ));
            }
            if (rangeMinZ <= boxMaxZ && rangeMaxZ >= boxMaxZ) {
                minZ = maxZ = (double)(boxMaxZ + 1);
                boxes.add(new class_238(minX, minY, minZ, maxX, maxY, maxZ));
            }
        }
        if (rangeMinZ <= boxMaxZ && rangeMaxZ >= boxMinZ) {
            minZ = Math.max(boxMinZ, rangeMinZ);
            maxZ = Math.min(boxMaxZ, rangeMaxZ) + 1;
            if (rangeMinX <= boxMinX && rangeMaxX >= boxMinX) {
                minX = maxX = (double)boxMinX;
                boxes.add(new class_238(minX, minY, minZ, maxX, maxY, maxZ));
            }
            if (rangeMinX <= boxMaxX && rangeMaxX >= boxMaxX) {
                minX = maxX = (double)(boxMaxX + 1);
                boxes.add(new class_238(minX, minY, minZ, maxX, maxY, maxZ));
            }
        }
        return boxes;
    }

    public static void renderWallQuads(class_238 box, class_243 cameraPos, Color4f color, class_287 bufferQuads) {
        double cx = cameraPos.field_1352;
        double cy = cameraPos.field_1351;
        double cz = cameraPos.field_1350;
        bufferQuads.method_22912((float)(box.field_1323 - cx), (float)(box.field_1325 - cy), (float)(box.field_1321 - cz)).method_22915(color.r, color.g, color.b, color.a);
        bufferQuads.method_22912((float)(box.field_1323 - cx), (float)(box.field_1322 - cy), (float)(box.field_1321 - cz)).method_22915(color.r, color.g, color.b, color.a);
        bufferQuads.method_22912((float)(box.field_1320 - cx), (float)(box.field_1322 - cy), (float)(box.field_1324 - cz)).method_22915(color.r, color.g, color.b, color.a);
        bufferQuads.method_22912((float)(box.field_1320 - cx), (float)(box.field_1325 - cy), (float)(box.field_1324 - cz)).method_22915(color.r, color.g, color.b, color.a);
    }

    public static void renderWallOutlines(class_238 box, double lineIntervalH, double lineIntervalV, boolean alignLinesToModulo, class_243 cameraPos, Color4f color, float lineWidth, class_287 bufferLines) {
        block4: {
            double lineX;
            double cz;
            double cy;
            double cx;
            block5: {
                double lineZ;
                cx = cameraPos.field_1352;
                cy = cameraPos.field_1351;
                cz = cameraPos.field_1350;
                if (lineIntervalV > 0.0) {
                    double lineY;
                    double d = lineY = alignLinesToModulo ? RenderUtils.roundUp(box.field_1322, lineIntervalV) : box.field_1322;
                    while (lineY <= box.field_1325) {
                        bufferLines.method_22912((float)(box.field_1323 - cx), (float)(lineY - cy), (float)(box.field_1321 - cz)).method_22915(color.r, color.g, color.b, color.a).method_75298(lineWidth);
                        bufferLines.method_22912((float)(box.field_1320 - cx), (float)(lineY - cy), (float)(box.field_1324 - cz)).method_22915(color.r, color.g, color.b, color.a).method_75298(lineWidth);
                        lineY += lineIntervalV;
                    }
                }
                if (!(lineIntervalH > 0.0)) break block4;
                if (box.field_1323 != box.field_1320) break block5;
                double d = lineZ = alignLinesToModulo ? RenderUtils.roundUp(box.field_1321, lineIntervalH) : box.field_1321;
                while (lineZ <= box.field_1324) {
                    bufferLines.method_22912((float)(box.field_1323 - cx), (float)(box.field_1322 - cy), (float)(lineZ - cz)).method_22915(color.r, color.g, color.b, color.a).method_75298(lineWidth);
                    bufferLines.method_22912((float)(box.field_1323 - cx), (float)(box.field_1325 - cy), (float)(lineZ - cz)).method_22915(color.r, color.g, color.b, color.a).method_75298(lineWidth);
                    lineZ += lineIntervalH;
                }
                break block4;
            }
            if (box.field_1321 != box.field_1324) break block4;
            double d = lineX = alignLinesToModulo ? RenderUtils.roundUp(box.field_1323, lineIntervalH) : box.field_1323;
            while (lineX <= box.field_1320) {
                bufferLines.method_22912((float)(lineX - cx), (float)(box.field_1322 - cy), (float)(box.field_1321 - cz)).method_22915(color.r, color.g, color.b, color.a).method_75298(lineWidth);
                bufferLines.method_22912((float)(lineX - cx), (float)(box.field_1325 - cy), (float)(box.field_1321 - cz)).method_22915(color.r, color.g, color.b, color.a).method_75298(lineWidth);
                lineX += lineIntervalH;
            }
        }
    }

    public static void drawBoxQuads(IntBoundingBox bb, class_243 cameraPos, Color4f color, class_287 bufferQuads) {
        float minX = (float)((double)bb.minX() - cameraPos.field_1352);
        float minY = (float)((double)bb.minY() - cameraPos.field_1351);
        float minZ = (float)((double)bb.minZ() - cameraPos.field_1350);
        float maxX = (float)((double)(bb.maxX() + 1) - cameraPos.field_1352);
        float maxY = (float)((double)(bb.maxY() + 1) - cameraPos.field_1351);
        float maxZ = (float)((double)(bb.maxZ() + 1) - cameraPos.field_1350);
        fi.dy.masa.malilib.render.RenderUtils.drawBoxAllSidesBatchedQuads((float)minX, (float)minY, (float)minZ, (float)maxX, (float)maxY, (float)maxZ, (Color4f)color, (class_287)bufferQuads);
    }

    public static void drawBoxOutlines(IntBoundingBox bb, class_243 cameraPos, Color4f color, float lineWidth, class_287 bufferQuads) {
        float minX = (float)((double)bb.minX() - cameraPos.field_1352);
        float minY = (float)((double)bb.minY() - cameraPos.field_1351);
        float minZ = (float)((double)bb.minZ() - cameraPos.field_1350);
        float maxX = (float)((double)(bb.maxX() + 1) - cameraPos.field_1352);
        float maxY = (float)((double)(bb.maxY() + 1) - cameraPos.field_1351);
        float maxZ = (float)((double)(bb.maxZ() + 1) - cameraPos.field_1350);
        fi.dy.masa.malilib.render.RenderUtils.drawBoxAllEdgesBatchedLines((float)minX, (float)minY, (float)minZ, (float)maxX, (float)maxY, (float)maxZ, (Color4f)color, (float)lineWidth, (class_287)bufferQuads);
    }

    public static void drawBlockSpaceSideBatchedQuads(long posLong, class_2350 side, Color4f color, double expand, class_243 cameraPos, class_287 buffer) {
        int x = class_2338.method_10061((long)posLong);
        int y = class_2338.method_10071((long)posLong);
        int z = class_2338.method_10083((long)posLong);
        float offsetX = (float)((double)x - cameraPos.field_1352);
        float offsetY = (float)((double)y - cameraPos.field_1351);
        float offsetZ = (float)((double)z - cameraPos.field_1350);
        float minX = (float)((double)offsetX - expand);
        float minY = (float)((double)offsetY - expand);
        float minZ = (float)((double)offsetZ - expand);
        float maxX = (float)((double)offsetX + expand + 1.0);
        float maxY = (float)((double)offsetY + expand + 1.0);
        float maxZ = (float)((double)offsetZ + expand + 1.0);
        switch (side) {
            case field_11033: {
                buffer.method_22912(maxX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(minX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(minX, minY, minZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(maxX, minY, minZ).method_22915(color.r, color.g, color.b, color.a);
                break;
            }
            case field_11036: {
                buffer.method_22912(minX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(maxX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(maxX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(minX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a);
                break;
            }
            case field_11043: {
                buffer.method_22912(maxX, minY, minZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(minX, minY, minZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(minX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(maxX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a);
                break;
            }
            case field_11035: {
                buffer.method_22912(minX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(maxX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(maxX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(minX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a);
                break;
            }
            case field_11039: {
                buffer.method_22912(minX, minY, minZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(minX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(minX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(minX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a);
                break;
            }
            case field_11034: {
                buffer.method_22912(maxX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(maxX, minY, minZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(maxX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(maxX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a);
            }
        }
    }

    public static void drawBlockSpaceSideBatchedLines(long posLong, class_2350 side, Color4f color, double expand, class_243 cameraPos, float lineWidth, class_287 buffer) {
        int x = class_2338.method_10061((long)posLong);
        int y = class_2338.method_10071((long)posLong);
        int z = class_2338.method_10083((long)posLong);
        float offsetX = (float)((double)x - cameraPos.field_1352);
        float offsetY = (float)((double)y - cameraPos.field_1351);
        float offsetZ = (float)((double)z - cameraPos.field_1350);
        float minX = (float)((double)offsetX - expand);
        float minY = (float)((double)offsetY - expand);
        float minZ = (float)((double)offsetZ - expand);
        float maxX = (float)((double)offsetX + expand + 1.0);
        float maxY = (float)((double)offsetY + expand + 1.0);
        float maxZ = (float)((double)offsetZ + expand + 1.0);
        switch (side) {
            case field_11033: {
                buffer.method_22912(maxX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_75298(lineWidth);
                buffer.method_22912(minX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_75298(lineWidth);
                buffer.method_22912(minX, minY, minZ).method_22915(color.r, color.g, color.b, color.a).method_75298(lineWidth);
                buffer.method_22912(maxX, minY, minZ).method_22915(color.r, color.g, color.b, color.a).method_75298(lineWidth);
                break;
            }
            case field_11036: {
                buffer.method_22912(minX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_75298(lineWidth);
                buffer.method_22912(maxX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_75298(lineWidth);
                buffer.method_22912(maxX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a).method_75298(lineWidth);
                buffer.method_22912(minX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a).method_75298(lineWidth);
                break;
            }
            case field_11043: {
                buffer.method_22912(maxX, minY, minZ).method_22915(color.r, color.g, color.b, color.a).method_75298(lineWidth);
                buffer.method_22912(minX, minY, minZ).method_22915(color.r, color.g, color.b, color.a).method_75298(lineWidth);
                buffer.method_22912(minX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a).method_75298(lineWidth);
                buffer.method_22912(maxX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a).method_75298(lineWidth);
                break;
            }
            case field_11035: {
                buffer.method_22912(minX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_75298(lineWidth);
                buffer.method_22912(maxX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_75298(lineWidth);
                buffer.method_22912(maxX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_75298(lineWidth);
                buffer.method_22912(minX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_75298(lineWidth);
                break;
            }
            case field_11039: {
                buffer.method_22912(minX, minY, minZ).method_22915(color.r, color.g, color.b, color.a).method_75298(lineWidth);
                buffer.method_22912(minX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_75298(lineWidth);
                buffer.method_22912(minX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_75298(lineWidth);
                buffer.method_22912(minX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a).method_75298(lineWidth);
                break;
            }
            case field_11034: {
                buffer.method_22912(maxX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_75298(lineWidth);
                buffer.method_22912(maxX, minY, minZ).method_22915(color.r, color.g, color.b, color.a).method_75298(lineWidth);
                buffer.method_22912(maxX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a).method_75298(lineWidth);
                buffer.method_22912(maxX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_75298(lineWidth);
            }
        }
    }

    public static void renderCircleBlockOutlines(LongOpenHashSet positions, class_2350[] sides, SphereUtils.RingPositionTest test, ShapeRenderType renderType, LayerRange range, Color4f color, double expand, class_243 cameraPos, float lineWidth, class_287 buffer) {
        boolean full = renderType == ShapeRenderType.FULL_BLOCK;
        boolean outer = renderType == ShapeRenderType.OUTER_EDGE;
        boolean inner = renderType == ShapeRenderType.INNER_EDGE;
        LongIterator longIterator = positions.iterator();
        while (longIterator.hasNext()) {
            long posLong = (Long)longIterator.next();
            if (!range.isPositionWithinRange(posLong)) continue;
            for (class_2350 side : sides) {
                long adjPosLong = class_2338.method_10060((long)posLong, (class_2350)side);
                if (positions.contains(adjPosLong)) continue;
                boolean render = full;
                if (!full) {
                    int adjX = class_2338.method_10061((long)adjPosLong);
                    int adjY = class_2338.method_10071((long)adjPosLong);
                    int adjZ = class_2338.method_10083((long)adjPosLong);
                    boolean onOrIn = test.isInsideOrCloserThan(adjX, adjY, adjZ, side);
                    boolean bl = render = outer && !onOrIn || inner && onOrIn;
                }
                if (!render) continue;
                RenderUtils.drawBlockSpaceSideBatchedLines(posLong, side, color, expand, cameraPos, lineWidth, buffer);
            }
        }
    }

    public static void renderCircleBlockPositions(LongOpenHashSet positions, class_2350[] sides, SphereUtils.RingPositionTest test, ShapeRenderType renderType, LayerRange range, Color4f color, double expand, class_243 cameraPos, class_287 buffer) {
        boolean full = renderType == ShapeRenderType.FULL_BLOCK;
        boolean outer = renderType == ShapeRenderType.OUTER_EDGE;
        boolean inner = renderType == ShapeRenderType.INNER_EDGE;
        LongIterator longIterator = positions.iterator();
        while (longIterator.hasNext()) {
            long posLong = (Long)longIterator.next();
            if (!range.isPositionWithinRange(posLong)) continue;
            for (class_2350 side : sides) {
                long adjPosLong = class_2338.method_10060((long)posLong, (class_2350)side);
                if (positions.contains(adjPosLong)) continue;
                boolean render = full;
                if (!full) {
                    int adjX = class_2338.method_10061((long)adjPosLong);
                    int adjY = class_2338.method_10071((long)adjPosLong);
                    int adjZ = class_2338.method_10083((long)adjPosLong);
                    boolean onOrIn = test.isInsideOrCloserThan(adjX, adjY, adjZ, side);
                    boolean bl = render = outer && !onOrIn || inner && onOrIn;
                }
                if (!render) continue;
                RenderUtils.drawBlockSpaceSideBatchedQuads(posLong, side, color, expand, cameraPos, buffer);
            }
        }
    }

    public static void renderBlockPositions(LongOpenHashSet positions, LayerRange range, Color4f color, double expand, class_243 cameraPos, class_287 buffer) {
        LongIterator longIterator = positions.iterator();
        while (longIterator.hasNext()) {
            long posLong = (Long)longIterator.next();
            if (!range.isPositionWithinRange(posLong)) continue;
            for (class_2350 side : PositionUtils.ALL_DIRECTIONS) {
                long adjPosLong = class_2338.method_10060((long)posLong, (class_2350)side);
                if (positions.contains(adjPosLong)) continue;
                RenderUtils.drawBlockSpaceSideBatchedQuads(posLong, side, color, expand, cameraPos, buffer);
            }
        }
    }

    public static void renderBlockPositionOutlines(LongOpenHashSet positions, LayerRange range, Color4f color, double expand, class_243 cameraPos, float lineWidth, class_287 buffer) {
        LongIterator longIterator = positions.iterator();
        while (longIterator.hasNext()) {
            long posLong = (Long)longIterator.next();
            if (!range.isPositionWithinRange(posLong)) continue;
            for (class_2350 side : PositionUtils.ALL_DIRECTIONS) {
                long adjPosLong = class_2338.method_10060((long)posLong, (class_2350)side);
                if (positions.contains(adjPosLong)) continue;
                RenderUtils.drawBlockSpaceSideBatchedLines(posLong, side, color, expand, cameraPos, lineWidth, buffer);
            }
        }
    }

    public static void renderQuads(Collection<SideQuad> quads, Color4f color, double expand, class_243 cameraPos, class_287 buffer) {
        for (SideQuad quad : quads) {
            RenderUtils.renderInsetQuad(quad.startPos(), quad.width(), quad.height(), quad.side(), -expand, color, cameraPos, buffer);
        }
    }

    public static void renderInsetQuad(class_2382 minPos, int width, int height, class_2350 side, double inset, Color4f color, class_243 cameraPos, class_287 buffer) {
        RenderUtils.renderInsetQuad(minPos.method_10263(), minPos.method_10264(), minPos.method_10260(), width, height, side, inset, color, cameraPos, buffer);
    }

    public static void renderInsetQuad(long minPos, int width, int height, class_2350 side, double inset, Color4f color, class_243 cameraPos, class_287 buffer) {
        int x = class_2338.method_10061((long)minPos);
        int y = class_2338.method_10071((long)minPos);
        int z = class_2338.method_10083((long)minPos);
        RenderUtils.renderInsetQuad(x, y, z, width, height, side, inset, color, cameraPos, buffer);
    }

    public static void renderInsetQuad(int x, int y, int z, int width, int height, class_2350 side, double inset, Color4f color, class_243 cameraPos, class_287 buffer) {
        float minX = (float)((double)x - cameraPos.field_1352);
        float minY = (float)((double)y - cameraPos.field_1351);
        float minZ = (float)((double)z - cameraPos.field_1350);
        float maxX = minX;
        float maxY = minY;
        float maxZ = minZ;
        if (side.method_10166() == class_2350.class_2351.field_11051) {
            maxX += (float)width;
            maxY += (float)height;
        } else if (side.method_10166() == class_2350.class_2351.field_11048) {
            maxY += (float)height;
            maxZ += (float)width;
        } else if (side.method_10166() == class_2350.class_2351.field_11052) {
            maxX += (float)width;
            maxZ += (float)height;
        }
        switch (side) {
            case field_11039: {
                buffer.method_22912(minX += (float)inset, minY, minZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(minX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(minX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(minX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a);
                break;
            }
            case field_11034: {
                buffer.method_22912(maxX += (float)(1.0 - inset), minY, minZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(maxX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(maxX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(maxX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a);
                break;
            }
            case field_11043: {
                buffer.method_22912(minX, minY, minZ += (float)inset).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(maxX, minY, minZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(maxX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(minX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a);
                break;
            }
            case field_11035: {
                buffer.method_22912(minX, minY, maxZ += (float)(1.0 - inset)).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(minX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(maxX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(maxX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a);
                break;
            }
            case field_11033: {
                buffer.method_22912(minX, minY += (float)inset, minZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(minX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(maxX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(maxX, minY, minZ).method_22915(color.r, color.g, color.b, color.a);
                break;
            }
            case field_11036: {
                buffer.method_22912(minX, maxY += (float)(1.0 - inset), minZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(maxX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(maxX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(minX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a);
            }
        }
    }

    public static void renderQuadLines(Collection<SideQuad> quads, Color4f color, double expand, class_243 cameraPos, float lineWidth, class_287 buffer) {
        for (SideQuad quad : quads) {
            RenderUtils.renderInsetQuadLines(quad.startPos(), quad.width(), quad.height(), quad.side(), -expand, color, cameraPos, lineWidth, buffer);
        }
    }

    public static void renderInsetQuadLines(class_2382 minPos, int width, int height, class_2350 side, double inset, Color4f color, class_243 cameraPos, float lineWidth, class_287 buffer) {
        RenderUtils.renderInsetQuadLines(minPos.method_10263(), minPos.method_10264(), minPos.method_10260(), width, height, side, inset, color, cameraPos, lineWidth, buffer);
    }

    public static void renderInsetQuadLines(long minPos, int width, int height, class_2350 side, double inset, Color4f color, class_243 cameraPos, float lineWidth, class_287 buffer) {
        int x = class_2338.method_10061((long)minPos);
        int y = class_2338.method_10071((long)minPos);
        int z = class_2338.method_10083((long)minPos);
        RenderUtils.renderInsetQuadLines(x, y, z, width, height, side, inset, color, cameraPos, lineWidth, buffer);
    }

    public static void renderInsetQuadLines(int x, int y, int z, int width, int height, class_2350 side, double inset, Color4f color, class_243 cameraPos, float lineWidth, class_287 buffer) {
        float minX = (float)((double)x - cameraPos.field_1352);
        float minY = (float)((double)y - cameraPos.field_1351);
        float minZ = (float)((double)z - cameraPos.field_1350);
        float maxX = minX;
        float maxY = minY;
        float maxZ = minZ;
        if (side.method_10166() == class_2350.class_2351.field_11051) {
            maxX += (float)width;
            maxY += (float)height;
        } else if (side.method_10166() == class_2350.class_2351.field_11048) {
            maxY += (float)height;
            maxZ += (float)width;
        } else if (side.method_10166() == class_2350.class_2351.field_11052) {
            maxX += (float)width;
            maxZ += (float)height;
        }
        switch (side) {
            case field_11039: {
                buffer.method_22912(minX += (float)inset, minY, minZ).method_22915(color.r, color.g, color.b, color.a).method_75298(lineWidth);
                buffer.method_22912(minX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a).method_75298(lineWidth);
                buffer.method_22912(minX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_75298(lineWidth);
                buffer.method_22912(minX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_75298(lineWidth);
                break;
            }
            case field_11034: {
                buffer.method_22912(maxX += (float)(1.0 - inset), minY, minZ).method_22915(color.r, color.g, color.b, color.a).method_75298(lineWidth);
                buffer.method_22912(maxX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_75298(lineWidth);
                buffer.method_22912(maxX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_75298(lineWidth);
                buffer.method_22912(maxX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a).method_75298(lineWidth);
                break;
            }
            case field_11043: {
                buffer.method_22912(minX, minY, minZ += (float)inset).method_22915(color.r, color.g, color.b, color.a).method_75298(lineWidth);
                buffer.method_22912(maxX, minY, minZ).method_22915(color.r, color.g, color.b, color.a).method_75298(lineWidth);
                buffer.method_22912(maxX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a).method_75298(lineWidth);
                buffer.method_22912(minX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a).method_75298(lineWidth);
                break;
            }
            case field_11035: {
                buffer.method_22912(minX, minY, maxZ += (float)(1.0 - inset)).method_22915(color.r, color.g, color.b, color.a).method_75298(lineWidth);
                buffer.method_22912(minX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_75298(lineWidth);
                buffer.method_22912(maxX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_75298(lineWidth);
                buffer.method_22912(maxX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_75298(lineWidth);
                break;
            }
            case field_11033: {
                buffer.method_22912(minX, minY += (float)inset, minZ).method_22915(color.r, color.g, color.b, color.a).method_75298(lineWidth);
                buffer.method_22912(minX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_75298(lineWidth);
                buffer.method_22912(maxX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_75298(lineWidth);
                buffer.method_22912(maxX, minY, minZ).method_22915(color.r, color.g, color.b, color.a).method_75298(lineWidth);
                break;
            }
            case field_11036: {
                buffer.method_22912(minX, maxY += (float)(1.0 - inset), minZ).method_22915(color.r, color.g, color.b, color.a).method_75298(lineWidth);
                buffer.method_22912(maxX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a).method_75298(lineWidth);
                buffer.method_22912(maxX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_75298(lineWidth);
                buffer.method_22912(minX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_75298(lineWidth);
            }
        }
    }

    public static void renderBiomeBorderLines(class_2382 minPos, int width, int height, class_2350 side, double inset, Color4f color, class_243 cameraPos, float lineWidth, class_287 buffer) {
        float minX = (float)((double)minPos.method_10263() - cameraPos.field_1352);
        float minY = (float)((double)minPos.method_10264() - cameraPos.field_1351);
        float minZ = (float)((double)minPos.method_10260() - cameraPos.field_1350);
        switch (side) {
            case field_11039: {
                minX += (float)inset;
                break;
            }
            case field_11034: {
                minX += (float)(1.0 - inset);
                break;
            }
            case field_11043: {
                minZ += (float)inset;
                break;
            }
            case field_11035: {
                minZ += (float)(1.0 - inset);
                break;
            }
            case field_11033: {
                minY += (float)inset;
                break;
            }
            case field_11036: {
                minY += (float)(1.0 - inset);
            }
        }
        float maxX = minX;
        float maxY = minY;
        float maxZ = minZ;
        if (side.method_10166() == class_2350.class_2351.field_11051) {
            maxX += (float)width;
            maxY += (float)height;
        } else if (side.method_10166() == class_2350.class_2351.field_11048) {
            maxY += (float)height;
            maxZ += (float)width;
        } else if (side.method_10166() == class_2350.class_2351.field_11052) {
            maxX += (float)width;
            maxZ += (float)height;
        }
        if (side.method_10166() == class_2350.class_2351.field_11052) {
            buffer.method_22912(minX, minY, minZ).method_22915(color.r, color.g, color.b, color.a).method_75298(lineWidth);
            buffer.method_22912(minX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_75298(lineWidth);
            float z = minZ;
            while ((double)z < (double)maxZ + 0.5) {
                buffer.method_22912(minX, minY, z).method_22915(color.r, color.g, color.b, color.a).method_75298(lineWidth);
                buffer.method_22912(maxX, maxY, z).method_22915(color.r, color.g, color.b, color.a).method_75298(lineWidth);
                z += 1.0f;
            }
        } else {
            buffer.method_22912(minX, minY, minZ).method_22915(color.r, color.g, color.b, color.a).method_75298(lineWidth);
            buffer.method_22912(minX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a).method_75298(lineWidth);
            float y = minY;
            while ((double)y < (double)maxY + 0.5) {
                buffer.method_22912(minX, y, minZ).method_22915(color.r, color.g, color.b, color.a).method_75298(lineWidth);
                buffer.method_22912(maxX, y, maxZ).method_22915(color.r, color.g, color.b, color.a).method_75298(lineWidth);
                y += 1.0f;
            }
        }
    }

    public static double roundUp(double value, double interval) {
        double remainder;
        if (interval == 0.0) {
            return 0.0;
        }
        if (value == 0.0) {
            return interval;
        }
        if (value < 0.0) {
            interval *= -1.0;
        }
        return (remainder = value % interval) == 0.0 ? value : value + interval - remainder;
    }

    public static void drawBoxAllSidesBatchedQuads(class_238 bb, Color4f color, class_287 buffer) {
        float minX = (float)bb.field_1323;
        float minY = (float)bb.field_1322;
        float minZ = (float)bb.field_1321;
        float maxX = (float)bb.field_1320;
        float maxY = (float)bb.field_1325;
        float maxZ = (float)bb.field_1324;
        fi.dy.masa.malilib.render.RenderUtils.drawBoxAllSidesBatchedQuads((float)minX, (float)minY, (float)minZ, (float)maxX, (float)maxY, (float)maxZ, (Color4f)color, (class_287)buffer);
    }

    public static void drawBoxAllEdgesBatchedLines(class_238 bb, Color4f color, float lineWidth, class_287 buffer) {
        float minX = (float)bb.field_1323;
        float minY = (float)bb.field_1322;
        float minZ = (float)bb.field_1321;
        float maxX = (float)bb.field_1320;
        float maxY = (float)bb.field_1325;
        float maxZ = (float)bb.field_1324;
        fi.dy.masa.malilib.render.RenderUtils.drawBoxAllEdgesBatchedLines((float)minX, (float)minY, (float)minZ, (float)maxX, (float)maxY, (float)maxZ, (Color4f)color, (float)lineWidth, (class_287)buffer);
    }
}

