/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import fi.dy.masa.malilib.render.MaLiLibPipelines;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.EntityUtils;
import fi.dy.masa.malilib.util.JsonUtils;
import fi.dy.masa.malilib.util.data.Color4f;
import fi.dy.masa.minihud.MiniHUD;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.data.HudDataManager;
import fi.dy.masa.minihud.renderer.OverlayRendererBase;
import fi.dy.masa.minihud.renderer.RenderObjectVbo;
import fi.dy.masa.minihud.util.MiscUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3695;
import net.minecraft.class_4587;
import net.minecraft.class_9801;

public class OverlayRendererSlimeChunks
extends OverlayRendererBase {
    public static final OverlayRendererSlimeChunks INSTANCE = new OverlayRendererSlimeChunks();
    public double overlayTopY;
    protected boolean needsUpdate = true;
    protected boolean wasSeedKnown = false;
    protected long seed = -1L;
    protected double topY = 40.0;
    private final List<class_238> slimeChunks = new ArrayList<class_238>();
    private boolean hasData;

    protected OverlayRendererSlimeChunks() {
        this.useCulling = false;
        this.hasData = false;
    }

    @Override
    public String getName() {
        return "SlimeChunks";
    }

    public void setNeedsUpdate() {
        this.needsUpdate = true;
    }

    public void setOverlayTopY(double y) {
        this.overlayTopY = y;
    }

    public void incrementOverlayTopY(double y) {
        this.overlayTopY += y;
    }

    public void onEnabled() {
        if (Configs.Generic.SLIME_CHUNK_TOP_TO_PLAYER.getBooleanValue()) {
            class_1297 entity = EntityUtils.getCameraEntity();
            if (entity != null) {
                this.overlayTopY = entity.method_23318();
            }
        } else {
            this.overlayTopY = 40.0;
        }
        this.setNeedsUpdate();
    }

    @Override
    public boolean shouldRender(class_310 mc) {
        return RendererToggle.OVERLAY_SLIME_CHUNKS_OVERLAY.getBooleanValue() && mc.field_1687 != null && HudDataManager.getInstance().isWorldSeedKnown((class_1937)mc.field_1687) && MiscUtils.isOverworld((class_1937)mc.field_1687);
    }

    @Override
    public boolean needsUpdate(class_1297 entity, class_310 mc) {
        if (this.needsUpdate) {
            return true;
        }
        class_1937 world = entity.method_73183();
        boolean isSeedKnown = HudDataManager.getInstance().isWorldSeedKnown(world);
        long seed = HudDataManager.getInstance().getWorldSeed(world);
        if (this.topY != this.overlayTopY || this.wasSeedKnown != isSeedKnown || this.seed != seed) {
            return true;
        }
        int ex = (int)Math.floor(entity.method_23317());
        int ez = (int)Math.floor(entity.method_23321());
        int lx = this.lastUpdatePos.method_10263();
        int lz = this.lastUpdatePos.method_10260();
        return Math.abs(lx - ex) > 16 || Math.abs(lz - ez) > 16;
    }

    @Override
    public void update(class_243 cameraPos, class_1297 entity, class_310 mc, class_3695 profiler) {
        this.calculateChunks(entity, mc);
        this.renderThrough = Configs.Generic.SLIME_CHUNK_RENDER_THROUGH.getBooleanValue();
        if (this.hasData()) {
            this.render(cameraPos, mc, profiler);
        }
        this.needsUpdate = false;
    }

    @Override
    public boolean hasData() {
        return this.hasData && !this.slimeChunks.isEmpty();
    }

    @Override
    public void render(class_243 cameraPos, class_310 mc, class_3695 profiler) {
        this.allocateBuffers();
        this.renderQuads(cameraPos, mc, profiler);
        this.renderOutlines(cameraPos, mc, profiler);
    }

    private void renderQuads(class_243 cameraPos, class_310 mc, class_3695 profiler) {
        if (mc.field_1687 == null || mc.field_1724 == null) {
            return;
        }
        Color4f colorSides = Configs.Colors.SLIME_CHUNKS_OVERLAY_COLOR.getColor();
        profiler.method_15396("slime_chunk_quads");
        RenderObjectVbo ctx = (RenderObjectVbo)this.renderObjects.getFirst();
        class_287 builder = ctx.start(() -> "minihud:slime_chunk/quads", this.renderThrough ? MaLiLibPipelines.POSITION_COLOR_MASA_NO_DEPTH_NO_CULL : MaLiLibPipelines.MINIHUD_SHAPE_OFFSET_NO_CULL);
        class_4587 matrices = new class_4587();
        matrices.method_22903();
        for (class_238 bb : this.slimeChunks) {
            float x1 = (float)(bb.field_1323 - cameraPos.field_1352);
            float y1 = (float)(bb.field_1322 - cameraPos.field_1351);
            float z1 = (float)(bb.field_1321 - cameraPos.field_1350);
            float x2 = (float)(bb.field_1320 - cameraPos.field_1352);
            float y2 = (float)(bb.field_1325 - cameraPos.field_1351);
            float z2 = (float)(bb.field_1324 - cameraPos.field_1350);
            RenderUtils.drawBoxAllSidesBatchedQuads((float)x1, (float)y1, (float)z1, (float)x2, (float)y2, (float)z2, (Color4f)colorSides, (class_287)builder);
        }
        try {
            class_9801 meshData = builder.method_60794();
            if (meshData != null) {
                ctx.upload(meshData, this.shouldResort);
                if (this.shouldResort) {
                    ctx.startResorting(meshData, ctx.createVertexSorter(cameraPos));
                }
                meshData.close();
            }
        }
        catch (Exception err) {
            MiniHUD.LOGGER.error("OverlayRendererSlimeChunks#renderQuads(): Exception; {}", (Object)err.getMessage());
        }
        matrices.method_22909();
        profiler.method_15407();
    }

    private void renderOutlines(class_243 cameraPos, class_310 mc, class_3695 profiler) {
        if (mc.field_1687 == null || mc.field_1724 == null) {
            return;
        }
        Color4f colorLines = Color4f.fromColor((int)Configs.Colors.SLIME_CHUNKS_OVERLAY_COLOR.getColor().getIntValue(), (float)1.0f);
        profiler.method_15396("slime_chunk_outlines");
        RenderObjectVbo ctx = (RenderObjectVbo)this.renderObjects.get(1);
        class_287 builder = ctx.start(() -> "minihud:slime_chunk/outlines", MaLiLibPipelines.DEBUG_LINES_MASA_SIMPLE_LEQUAL_DEPTH);
        for (class_238 bb : this.slimeChunks) {
            float x1 = (float)(bb.field_1323 - cameraPos.field_1352);
            float y1 = (float)(bb.field_1322 - cameraPos.field_1351);
            float z1 = (float)(bb.field_1321 - cameraPos.field_1350);
            float x2 = (float)(bb.field_1320 - cameraPos.field_1352);
            float y2 = (float)(bb.field_1325 - cameraPos.field_1351);
            float z2 = (float)(bb.field_1324 - cameraPos.field_1350);
            RenderUtils.drawBoxAllEdgesBatchedLines((float)x1, (float)y1, (float)z1, (float)x2, (float)y2, (float)z2, (Color4f)colorLines, (float)this.glLineWidth, (class_287)builder);
        }
        try {
            class_9801 meshData = builder.method_60794();
            if (meshData != null) {
                ctx.upload(meshData, false);
                meshData.close();
            }
        }
        catch (Exception err) {
            MiniHUD.LOGGER.error("OverlayRendererSlimeChunks#renderOutlines(): Exception; {}", (Object)err.getMessage());
        }
        profiler.method_15407();
    }

    @Override
    public void reset() {
        super.reset();
        this.slimeChunks.clear();
        this.wasSeedKnown = false;
        this.seed = -1L;
        this.topY = 40.0;
        this.hasData = false;
    }

    private void calculateChunks(class_1297 entity, class_310 mc) {
        HudDataManager data = HudDataManager.getInstance();
        class_1937 world = entity.method_73183();
        int centerX = class_3532.method_15357((double)entity.method_23317()) >> 4;
        int centerZ = class_3532.method_15357((double)entity.method_23321()) >> 4;
        class_2338.class_2339 pos1 = new class_2338.class_2339();
        class_2338.class_2339 pos2 = new class_2338.class_2339();
        this.topY = this.overlayTopY;
        this.wasSeedKnown = data.isWorldSeedKnown(world);
        this.seed = data.getWorldSeed(world);
        this.hasData = false;
        if (this.wasSeedKnown) {
            int r = class_3532.method_15340((int)Configs.Generic.SLIME_CHUNK_OVERLAY_RADIUS.getIntegerValue(), (int)-1, (int)40);
            if (r == -1) {
                r = (Integer)mc.field_1690.method_42503().method_41753();
            }
            int minY = world != null ? world.method_31607() : -64;
            int topY = (int)Math.floor(this.topY);
            int count = 0;
            for (int xOff = -r; xOff <= r; ++xOff) {
                for (int zOff = -r; zOff <= r; ++zOff) {
                    int cx = centerX + xOff;
                    int cz = centerZ + zOff;
                    if (!MiscUtils.canSlimeSpawnInChunk(cx, cz, this.seed)) continue;
                    pos1.method_10103(cx << 4, minY, cz << 4);
                    pos2.method_10103((cx << 4) + 15, topY, (cz << 4) + 15);
                    class_238 bb = class_238.method_54784((class_2338)pos1, (class_2338)pos2);
                    if (!this.slimeChunks.contains(bb)) {
                        this.slimeChunks.add(bb);
                    }
                    ++count;
                }
            }
            if (count > 0) {
                this.hasData = true;
            }
        }
    }

    @Override
    public String getSaveId() {
        return "slime_chunks";
    }

    @Override
    public JsonObject toJson() {
        JsonObject obj = new JsonObject();
        obj.add("y_top", (JsonElement)new JsonPrimitive((Number)this.overlayTopY));
        return obj;
    }

    @Override
    public void fromJson(JsonObject obj) {
        this.overlayTopY = JsonUtils.getFloat((JsonObject)obj, (String)"y_top");
    }
}

