/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.info.generic;

import fi.dy.masa.minihud.config.InfoToggle;
import fi.dy.masa.minihud.info.InfoLine;
import fi.dy.masa.minihud.info.InfoLineContext;
import fi.dy.masa.minihud.util.MiscUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public class InfoLineWeather
extends InfoLine {
    private static final String WEATHER_KEY = "minihud.info_line.weather";
    private static final String REMAIN_KEY = "minihud.info_line.remaining";

    public InfoLineWeather(InfoToggle type) {
        super(type);
    }

    public InfoLineWeather() {
        this(InfoToggle.WEATHER);
    }

    @Override
    public boolean succeededType() {
        return false;
    }

    @Override
    public List<InfoLine.Entry> parse(@Nonnull InfoLineContext ctx) {
        ArrayList<InfoLine.Entry> list = new ArrayList<InfoLine.Entry>();
        String weatherType = "clear";
        int weatherTime = -1;
        if (this.getHudData().hasValidWeatherCycle()) {
            if (this.getHudData().isWeatherThunder() && this.getHudData().isWeatherRain()) {
                weatherType = "thundering";
                weatherTime = this.getHudData().getThunderTime();
            } else if (this.getHudData().isWeatherRain()) {
                weatherType = "raining";
                weatherTime = this.getHudData().getRainTime();
            } else if (this.getHudData().isWeatherClear()) {
                weatherType = "clear";
                weatherTime = this.getHudData().getClearTime();
            }
            if (weatherTime < 1) {
                list.add(this.translate(WEATHER_KEY, this.qt("minihud.info_line.weather." + weatherType, new Object[0]), ""));
            } else {
                list.add(this.translate(WEATHER_KEY, this.qt("minihud.info_line.weather." + weatherType, new Object[0]), ", " + MiscUtils.formatDuration((long)weatherTime * 50L) + " " + this.qt(REMAIN_KEY, new Object[0])));
            }
        } else {
            list.add(this.translate(WEATHER_KEY, this.qt("minihud.info_line.weather.invalid", new Object[0]), ""));
            if (this.getHudData().getClearTime() > -1) {
                this.getHudData().resetWeatherData();
            }
        }
        return list;
    }
}

