/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.config;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import fi.dy.masa.malilib.config.ConfigType;
import fi.dy.masa.malilib.config.IConfigBoolean;
import fi.dy.masa.malilib.config.IConfigInteger;
import fi.dy.masa.malilib.config.IHotkeyTogglable;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.hotkeys.IHotkeyCallback;
import fi.dy.masa.malilib.hotkeys.IKeybind;
import fi.dy.masa.malilib.hotkeys.KeyCallbackToggleBoolean;
import fi.dy.masa.malilib.hotkeys.KeybindMulti;
import fi.dy.masa.malilib.hotkeys.KeybindSettings;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.minihud.MiniHUD;
import fi.dy.masa.minihud.data.HudDataManager;
import fi.dy.masa.minihud.info.InfoLine;
import fi.dy.masa.minihud.info.InfoLineFlag;
import fi.dy.masa.minihud.info.InfoLineType;
import fi.dy.masa.minihud.info.InfoLineTypes;
import java.util.List;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;

public enum InfoToggle implements IConfigInteger,
IHotkeyTogglable
{
    FPS("infoFPS", InfoLineTypes.FPS, false, ""),
    GPU("infoGPU", InfoLineTypes.GPU, false, ""),
    MEMORY_USAGE("infoMemoryUsage", InfoLineTypes.MEMORY, false, ""),
    TIME_REAL("infoTimeIRL", InfoLineTypes.TIME_IRL, true, ""),
    TIME_WORLD("infoTimeWorld", InfoLineTypes.TIME_WORLD, false, ""),
    TIME_WORLD_FORMATTED("infoWorldTimeFormatted", InfoLineTypes.TIME_WORLD_FORMATTED, false, ""),
    COORDINATES("infoCoordinates", InfoLineTypes.COORDINATES, true, ""),
    COORDINATES_SCALED("infoCoordinatesScaled", InfoLineTypes.COORDINATES_SCALED, false, ""),
    BLOCK_POS("infoBlockPosition", InfoLineTypes.BLOCK_POS, false, ""),
    CHUNK_POS("infoChunkPosition", InfoLineTypes.CHUNK_POS, false, ""),
    BLOCK_IN_CHUNK("infoBlockInChunk", InfoLineTypes.BLOCK_IN_CHUNK, false, ""),
    DIMENSION("infoDimensionId", InfoLineTypes.DIMENSION, false, ""),
    FACING("infoFacing", InfoLineTypes.FACING, true, ""),
    ROTATION_YAW("infoRotationYaw", InfoLineTypes.ROTATION_YAW, false, ""),
    ROTATION_PITCH("infoRotationPitch", InfoLineTypes.ROTATION_PITCH, false, ""),
    BLOCK_BREAK_SPEED("infoBlockBreakSpeed", InfoLineTypes.BLOCK_BREAK_SPEED, false, ""),
    PLAYER_EXPERIENCE("infoPlayerExperience", InfoLineTypes.PLAYER_EXP, false, ""),
    SPEED("infoSpeed", InfoLineTypes.SPEED, false, ""),
    SPEED_AXIS("infoSpeedAxis", InfoLineTypes.SPEED_AXIS, false, ""),
    SPEED_HV("infoSpeedHV", InfoLineTypes.SPEED_HV, false, ""),
    SPRINTING("infoSprinting", InfoLineTypes.SPRINTING, false, ""),
    SERVER_TPS("infoServerTPS", InfoLineTypes.SERVER_TPS, false, ""),
    SERVUX("infoServux", InfoLineTypes.SERVUX, false, true, ""),
    PING("infoPing", InfoLineTypes.PING, false, ""),
    WEATHER("infoWeather", InfoLineTypes.WEATHER, false, true, ""),
    TIME_TOTAL_MODULO("infoTimeTotalModulo", InfoLineTypes.TIME_TOTAL_MODULO, false, ""),
    TIME_DAY_MODULO("infoTimeDayModulo", InfoLineTypes.TIME_DAY_MODULO, false, ""),
    MOB_CAPS("infoMobCaps", InfoLineTypes.MOB_CAPS, false, true, ""),
    PARTICLE_COUNT("infoParticleCount", InfoLineTypes.PARTICLE_COUNT, false, ""),
    DIFFICULTY("infoDifficulty", InfoLineTypes.DIFFICULTY, false, ""),
    ENTITIES("infoEntities", InfoLineTypes.ENTITIES, false, ""),
    ENTITIES_CLIENT_WORLD("infoEntitiesClientWorld", InfoLineTypes.ENTITIES_CLIENT_WORLD, false, ""),
    TILE_ENTITIES("infoTileEntities", InfoLineTypes.TILE_ENTITIES, false, ""),
    LIGHT_LEVEL("infoLightLevel", InfoLineTypes.LIGHT_LEVEL, false, ""),
    BIOME("infoBiome", InfoLineTypes.BIOME, false, ""),
    BIOME_REG_NAME("infoBiomeRegistryName", InfoLineTypes.BIOME_REG_NAME, false, ""),
    DISTANCE("infoDistance", InfoLineTypes.DISTANCE, false, ""),
    LOADED_CHUNKS_COUNT("infoLoadedChunksCount", InfoLineTypes.LOADED_CHUNKS, false, ""),
    CHUNK_SECTIONS("infoChunkSections", InfoLineTypes.CHUNK_SECTIONS, false, ""),
    CHUNK_SECTIONS_FULL("infoChunkSectionsLine", InfoLineTypes.CHUNK_SECTIONS_FULL, false, ""),
    CHUNK_UPDATES("infoChunkUpdates", InfoLineTypes.CHUNK_UPDATES, false, ""),
    REGION_FILE("infoRegionFile", InfoLineTypes.REGION_FILE, false, ""),
    SLIME_CHUNK("infoSlimeChunk", InfoLineTypes.SLIME_CHUNK, false, ""),
    LOOKING_AT_BLOCK("infoLookingAtBlock", InfoLineTypes.LOOKING_AT_BLOCK, false, ""),
    LOOKING_AT_BLOCK_CHUNK("infoLookingAtBlockInChunk", InfoLineTypes.LOOKING_AT_CHUNK, false, ""),
    BLOCK_PROPS("infoBlockProperties", InfoLineTypes.BLOCK_PROPS, false, ""),
    BEE_COUNT("infoBeeCount", InfoLineTypes.BEE_COUNT, false, true, ""),
    COMPARATOR_OUTPUT("infoComparatorOutput", InfoLineTypes.COMPARATOR, false, true, ""),
    HONEY_LEVEL("infoHoneyLevel", InfoLineTypes.HONEY_LEVEL, false, ""),
    FURNACE_XP("infoFurnaceXp", InfoLineTypes.FURNACE_EXP, false, true, ""),
    ENTITY_REG_NAME("infoEntityRegistryName", InfoLineTypes.ENTITY_REG, false, ""),
    LOOKING_AT_ENTITY("infoLookingAtEntity", InfoLineTypes.LOOKING_AT_ENTITY, false, ""),
    LOOKING_AT_EFFECTS("infoLookingAtEffects", InfoLineTypes.LOOKING_AT_EFFECTS, false, ""),
    LOOKING_AT_PLAYER_EXP("infoLookingAtPlayerExp", InfoLineTypes.LOOKING_AT_PLAYER_EXP, false, ""),
    ZOMBIE_CONVERSION("infoZombieConversion", InfoLineTypes.ZOMBIE_CONVERSION, false, ""),
    HORSE_SPEED("infoHorseSpeed", InfoLineTypes.HORSE_SPEED, false, ""),
    HORSE_JUMP("infoHorseJump", InfoLineTypes.HORSE_JUMP, false, ""),
    HORSE_MAX_HEALTH("infoHorseMaxHealth", InfoLineTypes.HORSE_MAX_HEALTH, false, ""),
    PANDA_GENE("infoPandaGene", InfoLineTypes.PANDA_GENE, false, ""),
    DOLPHIN_TREASURE("infoDolphinTreasure", InfoLineTypes.DOLPHIN_TREASURE, false, ""),
    ENTITY_VARIANT("infoEntityVariant", InfoLineTypes.ENTITY_VARIANT, false, ""),
    ENTITY_HOME_POS("infoEntityHomePos", InfoLineTypes.HOME_POS, false, ""),
    ENTITY_COPPER_AGING("infoEntityCopperAging", InfoLineTypes.COPPER_AGING, false, "");

    public static final ImmutableList<@NotNull InfoToggle> VALUES;
    private static final String INFO_KEY = "minihud.config.info_toggle";
    private final String name;
    private final InfoLineType<?> type;
    private String comment;
    private String prettyName;
    private String translatedName;
    private final IKeybind keybind;
    private final boolean defaultValueBoolean;
    private final int defaultLinePosition;
    private boolean valueBoolean;
    private int linePosition;
    private static int nextDefaultLinePosition;
    private final boolean serverDataRequired;
    private boolean dirty = false;

    private static int getNextDefaultLinePosition() {
        return nextDefaultLinePosition++;
    }

    private InfoToggle(String name, InfoLineType<?> type, boolean defaultValue, String defaultHotkey) {
        this(name, type, defaultValue, false, InfoToggle.getNextDefaultLinePosition(), defaultHotkey, InfoToggle.buildTranslateName(name, "comment"), KeybindSettings.DEFAULT, InfoToggle.buildTranslateName(name, "name"), InfoToggle.buildTranslateName(name, "prettyName"));
    }

    private InfoToggle(String name, InfoLineType<?> type, boolean defaultValue, boolean serverDataRequired, String defaultHotkey) {
        this(name, type, defaultValue, serverDataRequired, InfoToggle.getNextDefaultLinePosition(), defaultHotkey, InfoToggle.buildTranslateName(name, "comment"), KeybindSettings.DEFAULT, InfoToggle.buildTranslateName(name, "name"), InfoToggle.buildTranslateName(name, "prettyName"));
    }

    private InfoToggle(String name, InfoLineType<?> type, boolean defaultValue, String defaultHotkey, KeybindSettings settings) {
        this(name, type, defaultValue, false, InfoToggle.getNextDefaultLinePosition(), defaultHotkey, InfoToggle.buildTranslateName(name, "comment"), settings, InfoToggle.buildTranslateName(name, "name"), InfoToggle.buildTranslateName(name, "prettyName"));
    }

    private InfoToggle(String name, InfoLineType<?> type, boolean defaultValue, boolean serverDataRequired, String defaultHotkey, KeybindSettings settings) {
        this(name, type, defaultValue, serverDataRequired, InfoToggle.getNextDefaultLinePosition(), defaultHotkey, InfoToggle.buildTranslateName(name, "comment"), settings, InfoToggle.buildTranslateName(name, "name"), InfoToggle.buildTranslateName(name, "prettyName"));
    }

    private InfoToggle(String name, InfoLineType<?> type, boolean defaultValue, int linePosition, String defaultHotkey) {
        this(name, type, defaultValue, false, linePosition, defaultHotkey, InfoToggle.buildTranslateName(name, "comment"), KeybindSettings.DEFAULT, InfoToggle.buildTranslateName(name, "name"), InfoToggle.buildTranslateName(name, "prettyName"));
    }

    private InfoToggle(String name, InfoLineType<?> type, boolean defaultValue, boolean serverDataRequired, int linePosition, String defaultHotkey) {
        this(name, type, defaultValue, serverDataRequired, linePosition, defaultHotkey, InfoToggle.buildTranslateName(name, "comment"), KeybindSettings.DEFAULT, InfoToggle.buildTranslateName(name, "name"), InfoToggle.buildTranslateName(name, "prettyName"));
    }

    private InfoToggle(String name, InfoLineType<?> type, boolean defaultValue, int linePosition, String defaultHotkey, KeybindSettings settings) {
        this(name, type, defaultValue, false, linePosition, defaultHotkey, InfoToggle.buildTranslateName(name, "comment"), settings, InfoToggle.buildTranslateName(name, "name"), InfoToggle.buildTranslateName(name, "prettyName"));
    }

    private InfoToggle(String name, InfoLineType<?> type, boolean defaultValue, boolean serverDataRequired, int linePosition, String defaultHotkey, KeybindSettings settings) {
        this(name, type, defaultValue, serverDataRequired, linePosition, defaultHotkey, InfoToggle.buildTranslateName(name, "comment"), settings, InfoToggle.buildTranslateName(name, "name"), InfoToggle.buildTranslateName(name, "prettyName"));
    }

    private InfoToggle(String name, InfoLineType<?> type, boolean defaultValue, String defaultHotkey, String comment) {
        this(name, type, defaultValue, false, InfoToggle.getNextDefaultLinePosition(), defaultHotkey, comment, KeybindSettings.DEFAULT, InfoToggle.buildTranslateName(name, "name"), name);
    }

    private InfoToggle(String name, InfoLineType<?> type, boolean defaultValue, boolean serverDataRequired, String defaultHotkey, String comment) {
        this(name, type, defaultValue, serverDataRequired, InfoToggle.getNextDefaultLinePosition(), defaultHotkey, comment, KeybindSettings.DEFAULT, InfoToggle.buildTranslateName(name, "name"), name);
    }

    private InfoToggle(String name, InfoLineType<?> type, boolean defaultValue, String defaultHotkey, String comment, String translatedName) {
        this(name, type, defaultValue, false, InfoToggle.getNextDefaultLinePosition(), defaultHotkey, comment, KeybindSettings.DEFAULT, translatedName, name);
    }

    private InfoToggle(String name, InfoLineType<?> type, boolean defaultValue, boolean serverDataRequired, String defaultHotkey, String comment, String translatedName) {
        this(name, type, defaultValue, serverDataRequired, InfoToggle.getNextDefaultLinePosition(), defaultHotkey, comment, KeybindSettings.DEFAULT, translatedName, name);
    }

    private InfoToggle(String name, InfoLineType<?> type, boolean defaultValue, boolean serverDataRequired, int linePosition, String defaultHotkey, String comment, KeybindSettings settings, String translatedName, String prettyName) {
        this.name = name;
        this.type = type;
        this.valueBoolean = defaultValue;
        this.defaultValueBoolean = defaultValue;
        this.keybind = KeybindMulti.fromStorageString((String)defaultHotkey, (KeybindSettings)settings);
        this.keybind.setCallback((IHotkeyCallback)new KeyCallbackToggleBoolean((IConfigBoolean)this));
        this.defaultLinePosition = linePosition;
        this.linePosition = linePosition;
        this.comment = comment;
        this.prettyName = prettyName;
        this.translatedName = translatedName;
        this.serverDataRequired = serverDataRequired;
    }

    public ConfigType getType() {
        return ConfigType.HOTKEY;
    }

    @Nullable
    public InfoLineType<?> getInfoType() {
        return this.type;
    }

    @Nullable
    public List<InfoLineFlag> getInfoFlags() {
        if (this.type != null) {
            return this.type.getFlags();
        }
        return null;
    }

    public boolean hasFlag(InfoLineFlag flag) {
        return this.type != null && this.type.getFlags().contains((Object)flag);
    }

    @Nullable
    public InfoLine initParser() {
        if (this.type != null) {
            return this.type.init(this);
        }
        return null;
    }

    public String getName() {
        if (this.serverDataRequired) {
            return GuiBase.TXT_GOLD + this.name + GuiBase.TXT_RST;
        }
        return this.name;
    }

    public String getPrettyName() {
        return StringUtils.getTranslatedOrFallback((String)this.prettyName, (String)(this.prettyName.isEmpty() ? StringUtils.splitCamelCase((String)this.name) : this.prettyName));
    }

    public String getConfigGuiDisplayName() {
        String name = StringUtils.getTranslatedOrFallback((String)this.translatedName, (String)this.name);
        if (this.serverDataRequired) {
            return GuiBase.TXT_GOLD + name + GuiBase.TXT_RST;
        }
        return name;
    }

    public String getStringValue() {
        return String.valueOf(this.valueBoolean);
    }

    public String getDefaultStringValue() {
        return String.valueOf(this.defaultValueBoolean);
    }

    public String getComment() {
        String comment = StringUtils.getTranslatedOrFallback((String)this.comment, (String)this.comment);
        if (comment != null && this.serverDataRequired) {
            return comment + "\n" + StringUtils.translate((String)"minihud.label.config_comment.server_side_data", (Object[])new Object[0]);
        }
        return comment;
    }

    public String getTranslatedName() {
        String name = StringUtils.getTranslatedOrFallback((String)this.translatedName, (String)this.name);
        if (this.serverDataRequired) {
            return GuiBase.TXT_GOLD + name + GuiBase.TXT_RST;
        }
        return name;
    }

    public void setPrettyName(String s) {
        this.prettyName = s;
    }

    public void setTranslatedName(String s) {
        this.translatedName = s;
    }

    public void setComment(String s) {
        this.comment = s;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void markDirty() {
        this.dirty = true;
    }

    public void markClean() {
        this.dirty = false;
    }

    public void checkIfClean() {
        if (this.isDirty()) {
            this.markClean();
        }
    }

    private static String buildTranslateName(String name, String type) {
        return "minihud.config.info_toggle." + type + "." + name;
    }

    public boolean getBooleanValue() {
        return this.valueBoolean;
    }

    public boolean getDefaultBooleanValue() {
        return this.defaultValueBoolean;
    }

    public void setBooleanValue(boolean value) {
        this.valueBoolean = value;
    }

    public void toggleBooleanValue() {
        super.toggleBooleanValue();
        if (this == SERVER_TPS || this == MOB_CAPS) {
            HudDataManager.getInstance().refreshDataLoggers();
        }
    }

    public int getIntegerValue() {
        return this.linePosition;
    }

    public int getDefaultIntegerValue() {
        return this.defaultLinePosition;
    }

    public void setIntegerValue(int value) {
        this.linePosition = value;
    }

    public int getMinIntegerValue() {
        return 0;
    }

    public int getMaxIntegerValue() {
        return InfoToggle.values().length - 1;
    }

    public IKeybind getKeybind() {
        return this.keybind;
    }

    public boolean isModified() {
        return this.valueBoolean != this.defaultValueBoolean;
    }

    public boolean isModified(String newValue) {
        return !String.valueOf(this.defaultValueBoolean).equals(newValue);
    }

    public void resetToDefault() {
        this.valueBoolean = this.defaultValueBoolean;
    }

    public void setValueFromString(String value) {
        try {
            this.valueBoolean = Boolean.parseBoolean(value);
        }
        catch (Exception e) {
            MiniHUD.LOGGER.warn("Failed to read config value for {} from the JSON config", (Object)this.getName(), (Object)e);
        }
    }

    public void setValueFromJsonElement(JsonElement element) {
        try {
            if (element.isJsonPrimitive()) {
                this.valueBoolean = element.getAsBoolean();
            } else {
                MiniHUD.LOGGER.warn("Failed to read config value for {} from the JSON config", (Object)this.getName());
            }
        }
        catch (Exception e) {
            MiniHUD.LOGGER.warn("Failed to read config value for {} from the JSON config", (Object)this.getName(), (Object)e);
        }
    }

    public JsonElement getAsJsonElement() {
        return new JsonPrimitive(Boolean.valueOf(this.valueBoolean));
    }

    static {
        VALUES = ImmutableList.copyOf((Object[])InfoToggle.values());
    }
}

