/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.config.builder;

import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.caffeinemc.mods.sodium.api.config.ConfigState;
import net.caffeinemc.mods.sodium.api.config.StorageEventHandler;
import net.caffeinemc.mods.sodium.api.config.option.ControlValueFormatter;
import net.caffeinemc.mods.sodium.api.config.option.OptionBinding;
import net.caffeinemc.mods.sodium.api.config.option.OptionFlag;
import net.caffeinemc.mods.sodium.api.config.option.OptionImpact;
import net.caffeinemc.mods.sodium.api.config.option.Range;
import net.caffeinemc.mods.sodium.api.config.option.SteppedValidator;
import net.caffeinemc.mods.sodium.api.config.structure.IntegerOptionBuilder;
import net.caffeinemc.mods.sodium.client.config.builder.StatefulOptionBuilderImpl;
import net.caffeinemc.mods.sodium.client.config.structure.IntegerOption;
import net.caffeinemc.mods.sodium.client.config.value.ConstantValue;
import net.caffeinemc.mods.sodium.client.config.value.DependentValue;
import net.caffeinemc.mods.sodium.client.config.value.DynamicValue;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.apache.commons.lang3.Validate;

class IntegerOptionBuilderImpl
extends StatefulOptionBuilderImpl<IntegerOption, Integer>
implements IntegerOptionBuilder {
    private DependentValue<? extends SteppedValidator> validatorProvider;
    private ControlValueFormatter valueFormatter;

    IntegerOptionBuilderImpl(class_2960 id) {
        super(id);
    }

    @Override
    void validateData() {
        super.validateData();
        Validate.notNull(this.getValidatorProvider(), (String)"Validator provider must be set", (Object[])new Object[0]);
        Validate.notNull((Object)this.getValueFormatter(), (String)"Value formatter must be set", (Object[])new Object[0]);
    }

    @Override
    IntegerOption build() {
        this.prepareBuild();
        return new IntegerOption(this.id, this.getDependencies(), this.getName(), this.getEnabled(), this.getStorage(), this.getTooltipProvider(), this.getImpact(), this.getFlags(), this.getDefaultValue(), this.getControlHiddenWhenDisabled(), this.getBinding(), this.getApplyHook(), this.getValidatorProvider(), this.getValueFormatter());
    }

    @Override
    Collection<class_2960> getDependencies() {
        Collection<class_2960> deps = super.getDependencies();
        deps.addAll(this.getValidatorProvider().getDependencies());
        return deps;
    }

    @Override
    Class<IntegerOption> getOptionClass() {
        return IntegerOption.class;
    }

    DependentValue<? extends SteppedValidator> getValidatorProvider() {
        return this.getFirstNotNull(this.validatorProvider, IntegerOption::getValidatorProvider);
    }

    ControlValueFormatter getValueFormatter() {
        return this.getFirstNotNull(this.valueFormatter, IntegerOption::getValueFormatter);
    }

    @Override
    public IntegerOptionBuilder setName(class_2561 name) {
        super.setName(name);
        return this;
    }

    @Override
    public IntegerOptionBuilder setEnabled(boolean available) {
        super.setEnabled(available);
        return this;
    }

    @Override
    public IntegerOptionBuilder setEnabledProvider(Function<ConfigState, Boolean> provider, class_2960 ... dependencies) {
        super.setEnabledProvider((Function)provider, dependencies);
        return this;
    }

    @Override
    public IntegerOptionBuilder setStorageHandler(StorageEventHandler storage) {
        super.setStorageHandler(storage);
        return this;
    }

    @Override
    public IntegerOptionBuilder setTooltip(class_2561 tooltip) {
        super.setTooltip(tooltip);
        return this;
    }

    @Override
    public IntegerOptionBuilder setTooltip(Function<Integer, class_2561> tooltip) {
        super.setTooltip(tooltip);
        return this;
    }

    @Override
    public IntegerOptionBuilder setImpact(OptionImpact impact) {
        super.setImpact(impact);
        return this;
    }

    @Override
    public IntegerOptionBuilder setFlags(OptionFlag ... flags) {
        super.setFlags(flags);
        return this;
    }

    @Override
    public IntegerOptionBuilder setFlags(class_2960 ... flags) {
        super.setFlags(flags);
        return this;
    }

    @Override
    public IntegerOptionBuilder setDefaultValue(Integer value) {
        super.setDefaultValue(value);
        return this;
    }

    @Override
    public IntegerOptionBuilder setDefaultProvider(Function<ConfigState, Integer> provider, class_2960 ... dependencies) {
        super.setDefaultProvider(provider, dependencies);
        return this;
    }

    @Override
    public IntegerOptionBuilder setControlHiddenWhenDisabled(boolean hidden) {
        super.setControlHiddenWhenDisabled(hidden);
        return this;
    }

    @Override
    public IntegerOptionBuilder setBinding(Consumer<Integer> save, Supplier<Integer> load) {
        super.setBinding(save, load);
        return this;
    }

    @Override
    public IntegerOptionBuilder setBinding(OptionBinding<Integer> binding) {
        super.setBinding(binding);
        return this;
    }

    @Override
    public IntegerOptionBuilder setApplyHook(Consumer<ConfigState> hook) {
        super.setApplyHook(hook);
        return this;
    }

    @Override
    public IntegerOptionBuilder setRange(int min, int max, int step) {
        return this.setRange(new Range(min, max, step));
    }

    @Override
    public IntegerOptionBuilder setRange(Range range) {
        this.validatorProvider = new ConstantValue<Range>(range);
        return this;
    }

    @Override
    public IntegerOptionBuilder setRangeProvider(Function<ConfigState, ? extends SteppedValidator> provider, class_2960 ... dependencies) {
        this.validatorProvider = new DynamicValue<SteppedValidator>(provider, dependencies);
        return this;
    }

    @Override
    public IntegerOptionBuilder setValidator(SteppedValidator validator) {
        this.validatorProvider = new ConstantValue<SteppedValidator>(validator);
        return this;
    }

    @Override
    public IntegerOptionBuilder setValidatorProvider(Function<ConfigState, ? extends SteppedValidator> provider, class_2960 ... dependencies) {
        this.validatorProvider = new DynamicValue<SteppedValidator>(provider, dependencies);
        return this;
    }

    @Override
    public IntegerOptionBuilder setValueFormatter(ControlValueFormatter formatter) {
        this.valueFormatter = formatter;
        return this;
    }
}

