/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.neoforge.internal;

import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import org.enginehub.linbus.common.LinTagId;
import org.enginehub.linbus.tree.LinByteArrayTag;
import org.enginehub.linbus.tree.LinByteTag;
import org.enginehub.linbus.tree.LinCompoundTag;
import org.enginehub.linbus.tree.LinDoubleTag;
import org.enginehub.linbus.tree.LinEndTag;
import org.enginehub.linbus.tree.LinFloatTag;
import org.enginehub.linbus.tree.LinIntArrayTag;
import org.enginehub.linbus.tree.LinIntTag;
import org.enginehub.linbus.tree.LinListTag;
import org.enginehub.linbus.tree.LinLongArrayTag;
import org.enginehub.linbus.tree.LinLongTag;
import org.enginehub.linbus.tree.LinShortTag;
import org.enginehub.linbus.tree.LinStringTag;
import org.enginehub.linbus.tree.LinTag;
import org.enginehub.linbus.tree.LinTagType;

public final class NBTConverter {
    private NBTConverter() {
    }

    public static Tag toNative(LinTag<?> tag) {
        LinTag<?> linTag = tag;
        Objects.requireNonNull(linTag);
        LinTag<?> linTag2 = linTag;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LinIntArrayTag.class, LinListTag.class, LinLongTag.class, LinLongArrayTag.class, LinStringTag.class, LinIntTag.class, LinByteTag.class, LinByteArrayTag.class, LinCompoundTag.class, LinFloatTag.class, LinShortTag.class, LinDoubleTag.class, LinEndTag.class}, linTag2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                LinIntArrayTag t = (LinIntArrayTag)linTag2;
                yield NBTConverter.toNative(t);
            }
            case 1 -> {
                LinListTag t = (LinListTag)linTag2;
                yield NBTConverter.toNative(t);
            }
            case 2 -> {
                LinLongTag t = (LinLongTag)linTag2;
                yield NBTConverter.toNative(t);
            }
            case 3 -> {
                LinLongArrayTag t = (LinLongArrayTag)linTag2;
                yield NBTConverter.toNative(t);
            }
            case 4 -> {
                LinStringTag t = (LinStringTag)linTag2;
                yield NBTConverter.toNative(t);
            }
            case 5 -> {
                LinIntTag t = (LinIntTag)linTag2;
                yield NBTConverter.toNative(t);
            }
            case 6 -> {
                LinByteTag t = (LinByteTag)linTag2;
                yield NBTConverter.toNative(t);
            }
            case 7 -> {
                LinByteArrayTag t = (LinByteArrayTag)linTag2;
                yield NBTConverter.toNative(t);
            }
            case 8 -> {
                LinCompoundTag t = (LinCompoundTag)linTag2;
                yield NBTConverter.toNative(t);
            }
            case 9 -> {
                LinFloatTag t = (LinFloatTag)linTag2;
                yield NBTConverter.toNative(t);
            }
            case 10 -> {
                LinShortTag t = (LinShortTag)linTag2;
                yield NBTConverter.toNative(t);
            }
            case 11 -> {
                LinDoubleTag t = (LinDoubleTag)linTag2;
                yield NBTConverter.toNative(t);
            }
            case 12 -> {
                LinEndTag ignored = (LinEndTag)linTag2;
                yield EndTag.INSTANCE;
            }
        };
    }

    public static IntArrayTag toNative(LinIntArrayTag tag) {
        int[] value = tag.value();
        return new IntArrayTag(Arrays.copyOf(value, value.length));
    }

    public static ListTag toNative(LinListTag<?> tag) {
        ListTag list = new ListTag();
        Iterator iterator = tag.value().iterator();
        while (iterator.hasNext()) {
            LinTag child = (LinTag)iterator.next();
            list.addAndUnwrap(NBTConverter.toNative(child));
        }
        return list;
    }

    public static LongTag toNative(LinLongTag tag) {
        return LongTag.valueOf((long)tag.value());
    }

    public static LongArrayTag toNative(LinLongArrayTag tag) {
        return new LongArrayTag((long[])tag.value().clone());
    }

    public static StringTag toNative(LinStringTag tag) {
        return StringTag.valueOf((String)tag.value());
    }

    public static IntTag toNative(LinIntTag tag) {
        return IntTag.valueOf((int)tag.value());
    }

    public static ByteTag toNative(LinByteTag tag) {
        return ByteTag.valueOf((byte)tag.value());
    }

    public static ByteArrayTag toNative(LinByteArrayTag tag) {
        return new ByteArrayTag((byte[])tag.value().clone());
    }

    public static CompoundTag toNative(LinCompoundTag tag) {
        CompoundTag compound = new CompoundTag();
        tag.value().forEach((key, value) -> compound.put(key, NBTConverter.toNative(value)));
        return compound;
    }

    public static FloatTag toNative(LinFloatTag tag) {
        return FloatTag.valueOf((float)tag.value().floatValue());
    }

    public static ShortTag toNative(LinShortTag tag) {
        return ShortTag.valueOf((short)tag.value());
    }

    public static DoubleTag toNative(LinDoubleTag tag) {
        return DoubleTag.valueOf((double)tag.value());
    }

    public static LinTag<?> fromNative(Tag other) {
        Tag tag = other;
        Objects.requireNonNull(tag);
        Tag tag2 = tag;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IntArrayTag.class, ListTag.class, EndTag.class, LongTag.class, LongArrayTag.class, StringTag.class, IntTag.class, ByteTag.class, ByteArrayTag.class, CompoundTag.class, FloatTag.class, ShortTag.class, DoubleTag.class}, (Object)tag2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                IntArrayTag tags = (IntArrayTag)tag2;
                yield NBTConverter.fromNative(tags);
            }
            case 1 -> {
                ListTag tags = (ListTag)tag2;
                yield NBTConverter.fromNative(tags);
            }
            case 2 -> {
                EndTag endTag = (EndTag)tag2;
                yield NBTConverter.fromNative(endTag);
            }
            case 3 -> {
                LongTag longTag = (LongTag)tag2;
                yield NBTConverter.fromNative(longTag);
            }
            case 4 -> {
                LongArrayTag tags = (LongArrayTag)tag2;
                yield NBTConverter.fromNative(tags);
            }
            case 5 -> {
                StringTag stringTag = (StringTag)tag2;
                yield NBTConverter.fromNative(stringTag);
            }
            case 6 -> {
                IntTag intTag = (IntTag)tag2;
                yield NBTConverter.fromNative(intTag);
            }
            case 7 -> {
                ByteTag byteTag = (ByteTag)tag2;
                yield NBTConverter.fromNative(byteTag);
            }
            case 8 -> {
                ByteArrayTag tags = (ByteArrayTag)tag2;
                yield NBTConverter.fromNative(tags);
            }
            case 9 -> {
                CompoundTag compoundTag = (CompoundTag)tag2;
                yield NBTConverter.fromNative(compoundTag);
            }
            case 10 -> {
                FloatTag floatTag = (FloatTag)tag2;
                yield NBTConverter.fromNative(floatTag);
            }
            case 11 -> {
                ShortTag shortTag = (ShortTag)tag2;
                yield NBTConverter.fromNative(shortTag);
            }
            case 12 -> {
                DoubleTag doubleTag = (DoubleTag)tag2;
                yield NBTConverter.fromNative(doubleTag);
            }
        };
    }

    public static LinIntArrayTag fromNative(IntArrayTag other) {
        int[] value = other.getAsIntArray();
        return LinIntArrayTag.of(Arrays.copyOf(value, value.length));
    }

    private static byte identifyRawElementType(ListTag list) {
        byte b = 0;
        for (Tag tag : list) {
            byte c = tag.getId();
            if (b == 0) {
                b = c;
                continue;
            }
            if (b == c) continue;
            return 10;
        }
        return b;
    }

    private static CompoundTag wrapTag(Tag tag) {
        if (tag instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)tag;
            return compoundTag;
        }
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.put("", tag);
        return compoundTag;
    }

    public static LinListTag<?> fromNative(ListTag other) {
        byte rawType = NBTConverter.identifyRawElementType(other);
        LinListTag.Builder<LinTag<?>> list = LinListTag.builder(LinTagType.fromId(LinTagId.fromId(rawType)));
        for (Tag tag : other) {
            if (rawType == LinTagId.COMPOUND.id() && !(tag instanceof CompoundTag)) {
                list.add(NBTConverter.fromNative(NBTConverter.wrapTag(tag)));
                continue;
            }
            list.add(NBTConverter.fromNative(tag));
        }
        return list.build();
    }

    public static LinEndTag fromNative(EndTag other) {
        return LinEndTag.instance();
    }

    public static LinLongTag fromNative(LongTag other) {
        return LinLongTag.of(other.value());
    }

    public static LinLongArrayTag fromNative(LongArrayTag other) {
        return LinLongArrayTag.of((long[])other.getAsLongArray().clone());
    }

    public static LinStringTag fromNative(StringTag other) {
        return LinStringTag.of(other.value());
    }

    public static LinIntTag fromNative(IntTag other) {
        return LinIntTag.of(other.value());
    }

    public static LinByteTag fromNative(ByteTag other) {
        return LinByteTag.of(other.value());
    }

    public static LinByteArrayTag fromNative(ByteArrayTag other) {
        return LinByteArrayTag.of((byte[])other.getAsByteArray().clone());
    }

    public static LinCompoundTag fromNative(CompoundTag other) {
        Set tags = other.keySet();
        LinCompoundTag.Builder builder = LinCompoundTag.builder();
        for (String tagName : tags) {
            builder.put(tagName, NBTConverter.fromNative(other.get(tagName)));
        }
        return builder.build();
    }

    public static LinFloatTag fromNative(FloatTag other) {
        return LinFloatTag.of(other.value());
    }

    public static LinShortTag fromNative(ShortTag other) {
        return LinShortTag.of(other.value());
    }

    public static LinDoubleTag fromNative(DoubleTag other) {
        return LinDoubleTag.of(other.value());
    }
}

