/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.math.transform;

import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.math.transform.CombinedTransform;
import com.sk89q.worldedit.math.transform.Transform;

public record ScaleAndTranslateTransform(Vector3 offset, Vector3 scale) implements Transform
{
    @Override
    public boolean isIdentity() {
        return this.offset.equals(Vector3.ZERO) && this.scale.equals(Vector3.ONE);
    }

    @Override
    public Vector3 apply(Vector3 input) {
        return input.multiply(this.scale).add(this.offset);
    }

    @Override
    public Transform inverse() {
        return new Transform(){

            @Override
            public boolean isIdentity() {
                return ScaleAndTranslateTransform.this.isIdentity();
            }

            @Override
            public Vector3 apply(Vector3 input) {
                return input.subtract(ScaleAndTranslateTransform.this.offset).divide(ScaleAndTranslateTransform.this.scale);
            }

            @Override
            public Transform inverse() {
                return ScaleAndTranslateTransform.this;
            }

            @Override
            public Transform combine(Transform other) {
                return new CombinedTransform(this, other);
            }
        };
    }

    @Override
    public Transform combine(Transform other) {
        return new CombinedTransform(this, other);
    }
}

