/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.internal.schematic;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.internal.schematic.backends.FileWatcherSchematicsBackend;
import com.sk89q.worldedit.internal.schematic.backends.PollingSchematicsBackend;
import com.sk89q.worldedit.internal.schematic.backends.SchematicsBackend;
import com.sk89q.worldedit.internal.util.LogManagerCompat;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public class SchematicsManager {
    private static final Logger LOGGER = LogManagerCompat.getLogger();
    private final WorldEdit worldEdit;
    private Path schematicsDir;
    private SchematicsBackend backend;

    public SchematicsManager(WorldEdit worldEdit) {
        this.worldEdit = worldEdit;
    }

    public void init() {
        try {
            Path schematicsDirByConfig = this.worldEdit.getWorkingDirectoryPath(this.worldEdit.getConfiguration().saveDir);
            Files.createDirectories(schematicsDirByConfig, new FileAttribute[0]);
            this.schematicsDir = schematicsDirByConfig.toRealPath(new LinkOption[0]);
            try {
                this.backend = FileWatcherSchematicsBackend.create(this.schematicsDir);
            }
            catch (IOException e) {
                LOGGER.warn("Failed to initialize file-monitoring based schematics backend. Falling back to polling.", (Throwable)e);
                this.backend = PollingSchematicsBackend.create(this.schematicsDir);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create schematics directory", e);
        }
        this.backend.init();
    }

    public void uninit() {
        if (this.backend != null) {
            this.backend.uninit();
            this.backend = null;
        }
    }

    public Path getRoot() {
        Preconditions.checkNotNull((Object)this.schematicsDir, (Object)"not initialized");
        return this.schematicsDir;
    }

    public Set<Path> getSchematicPaths() {
        Preconditions.checkNotNull((Object)this.backend);
        return this.backend.getPaths();
    }

    public void update() {
        this.backend.update();
    }
}

