/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.proto.packets;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.function.Supplier;
import su.plo.voice.proto.packets.Packet;

public class PacketRegistry {
    private final Int2ObjectOpenHashMap<Supplier<? extends Packet<?>>> packetFactoryById = new Int2ObjectOpenHashMap();
    private final Object2IntOpenHashMap<Class<? extends Packet<?>>> packetIdByType = new Object2IntOpenHashMap();

    public void register(int packetId, Class<? extends Packet<?>> clazz, Supplier<? extends Packet<?>> factory) {
        this.packetFactoryById.put(packetId, factory);
        this.packetIdByType.put(clazz, packetId);
    }

    public Packet<?> byType(int type) {
        Supplier packetFactory = (Supplier)this.packetFactoryById.get(type);
        if (packetFactory != null) {
            try {
                return (Packet)packetFactory.get();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public int getType(Packet<?> packet) {
        return this.packetIdByType.getOrDefault(packet.getClass(), -1);
    }
}

