/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.api.server.connection;

import java.util.Optional;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import su.plo.voice.api.server.connection.UdpConnectionManager;
import su.plo.voice.api.server.event.connection.UdpClientDisconnectedEvent;
import su.plo.voice.api.server.player.VoiceServerPlayer;
import su.plo.voice.api.server.socket.UdpServerConnection;

public interface UdpServerConnectionManager
extends UdpConnectionManager<VoiceServerPlayer, UdpServerConnection> {
    public Optional<UUID> getPlayerIdBySecret(@NotNull UUID var1);

    @NotNull
    public UUID getSecretByPlayerId(@NotNull UUID var1);

    public void addConnection(@NotNull UdpServerConnection var1);

    default public boolean removeConnection(@NotNull UdpServerConnection connection) {
        return this.removeConnection(connection, UdpClientDisconnectedEvent.Reason.CUSTOM);
    }

    public boolean removeConnection(@NotNull UdpServerConnection var1, @NotNull UdpClientDisconnectedEvent.Reason var2);

    default public boolean removeConnection(@NotNull VoiceServerPlayer player) {
        return this.removeConnection(player, UdpClientDisconnectedEvent.Reason.CUSTOM);
    }

    public boolean removeConnection(@NotNull VoiceServerPlayer var1, @NotNull UdpClientDisconnectedEvent.Reason var2);

    default public boolean removeConnection(@NotNull UUID secret) {
        return this.removeConnection(secret, UdpClientDisconnectedEvent.Reason.CUSTOM);
    }

    public boolean removeConnection(@NotNull UUID var1, @NotNull UdpClientDisconnectedEvent.Reason var2);

    public void clearConnections();
}

