/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.reeses_sodium_options.client.gui.frame;

import java.util.ArrayList;
import me.flashyreese.mods.reeses_sodium_options.client.gui.AbstractWidgetExtended;
import me.flashyreese.mods.reeses_sodium_options.client.gui.Dim2iExtended;
import me.flashyreese.mods.reeses_sodium_options.client.gui.OptionExtended;
import me.flashyreese.mods.reeses_sodium_options.client.gui.Point2i;
import me.flashyreese.mods.reeses_sodium_options.client.gui.frame.AbstractFrame;
import me.flashyreese.mods.reeses_sodium_options.client.gui.frame.components.LabelComponent;
import net.caffeinemc.mods.sodium.api.config.option.OptionImpact;
import net.caffeinemc.mods.sodium.client.config.structure.ModOptions;
import net.caffeinemc.mods.sodium.client.config.structure.Option;
import net.caffeinemc.mods.sodium.client.config.structure.OptionGroup;
import net.caffeinemc.mods.sodium.client.config.structure.Page;
import net.caffeinemc.mods.sodium.client.gui.options.control.AbstractOptionList;
import net.caffeinemc.mods.sodium.client.gui.options.control.Control;
import net.caffeinemc.mods.sodium.client.gui.options.control.ControlElement;
import net.caffeinemc.mods.sodium.client.gui.widgets.AbstractWidget;
import net.caffeinemc.mods.sodium.client.util.Dim2i;
import net.minecraft.class_124;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_8016;
import net.minecraft.class_8023;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PageFrame
extends AbstractFrame {
    protected final Dim2i originalDim;
    protected final Page page;
    private long lastTime = 0L;
    private ControlElement lastHoveredElement = null;

    public PageFrame(class_437 screen, Dim2i dim, boolean renderOutline, Page page, ModOptions modOptions) {
        super(dim, screen, renderOutline, modOptions);
        this.originalDim = new Dim2i(dim.x(), dim.y(), dim.width(), dim.height());
        this.page = page;
        this.setupFrame();
        this.buildFrame();
    }

    public static Builder builder() {
        return new Builder();
    }

    public void setupFrame() {
        this.children.clear();
        this.controlElements.clear();
        int y = 0;
        if (!this.page.groups().isEmpty()) {
            OptionGroup lastGroup = (OptionGroup)this.page.groups().get(this.page.groups().size() - 1);
            for (OptionGroup group2 : this.page.groups()) {
                if (group2.name() != null && !group2.name().getString().isEmpty()) {
                    y += 18;
                }
                y += group2.options().size() * 18;
                if (group2 == lastGroup) continue;
                y += 4;
            }
        }
        ((Dim2iExtended)((AbstractWidgetExtended)((Object)this)).getDim()).setHeight(y);
        this.page.groups().forEach(group -> group.options().forEach(option -> {
            if (option instanceof OptionExtended) {
                OptionExtended optionExtended = (OptionExtended)option;
                optionExtended.setParentDimension(((AbstractWidgetExtended)((Object)this)).getDim());
            }
        }));
    }

    @Override
    public void buildFrame() {
        if (this.page == null) {
            return;
        }
        this.children.clear();
        this.controlElements.clear();
        int y = 0;
        for (OptionGroup group : this.page.groups()) {
            if (group.name() != null && !group.name().getString().isEmpty()) {
                Dim2i dim = new Dim2i(0, y + 4, this.getWidth(), 18);
                ((Dim2iExtended)dim).setPoint2i((Point2i)((AbstractWidgetExtended)((Object)this)).getDim());
                this.children.add(new LabelComponent(dim, group.name(), -1));
                y += 18;
            }
            for (Option option : group.options()) {
                Control control = option.getControl();
                Dim2i dim = new Dim2i(0, y, this.getWidth(), 18);
                ((Dim2iExtended)dim).setPoint2i((Point2i)((AbstractWidgetExtended)((Object)this)).getDim());
                ControlElement element = control.createElement(this.screen, (AbstractOptionList)this, dim, this.modOptions.theme());
                ((OptionExtended)element.getOption()).setDim2i(dim);
                this.children.add(element);
                y += 18;
            }
            y += 4;
        }
        super.buildFrame();
    }

    @Override
    public void method_25394(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        ControlElement hoveredElement = this.controlElements.stream().filter(controlElement -> ((Dim2iExtended)((AbstractWidgetExtended)controlElement).getDim()).overlapWith(this.originalDim)).filter(AbstractWidget::isHovered).findFirst().orElse(this.controlElements.stream().filter(controlElement -> ((Dim2iExtended)((AbstractWidgetExtended)controlElement).getDim()).overlapWith(this.originalDim)).filter(AbstractWidget::method_25370).findFirst().orElse(null));
        super.method_25394(guiGraphics, mouseX, mouseY, delta);
        if (hoveredElement != null && this.lastHoveredElement == hoveredElement && (this.originalDim.containsCursor((double)mouseX, (double)mouseY) && hoveredElement.isHovered() && hoveredElement.method_25405((double)mouseX, (double)mouseY) || hoveredElement.method_25370())) {
            if (this.lastTime == 0L) {
                this.lastTime = System.currentTimeMillis();
            }
            this.renderOptionTooltip(guiGraphics, hoveredElement);
        } else {
            this.lastTime = 0L;
            this.lastHoveredElement = hoveredElement;
        }
    }

    private void renderOptionTooltip(class_332 guiGraphics, ControlElement element) {
        int boxYCutoff;
        int boxHeight;
        int boxYLimit;
        if (this.lastTime + 500L > System.currentTimeMillis()) {
            return;
        }
        Dim2i dim = ((AbstractWidgetExtended)element).getDim();
        int textPadding = 3;
        int boxPadding = 3;
        int boxWidth = dim.width();
        int boxY = dim.getLimitY();
        int boxX = dim.x();
        Option option = element.getOption();
        ArrayList<class_5481> tooltip = new ArrayList<class_5481>(class_310.method_1551().field_1772.method_1728((class_5348)option.getTooltip(), boxWidth - textPadding * 2));
        OptionImpact impact = option.getImpact();
        if (impact != null) {
            tooltip.add(class_2477.method_10517().method_30934((class_5348)class_2561.method_43469((String)"sodium.options.performance_impact_string", (Object[])new Object[]{impact.getName()}).method_27692(class_124.field_1080)));
        }
        if ((boxYLimit = boxY + (boxHeight = tooltip.size() * 12 + boxPadding)) > (boxYCutoff = this.originalDim.getLimitY())) {
            boxY -= boxHeight + dim.height();
        }
        if (boxY < 0) {
            boxY = dim.getLimitY();
        }
        if (tooltip.isEmpty()) {
            return;
        }
        this.drawRect(guiGraphics, boxX, boxY, boxX + boxWidth, boxY + boxHeight, -536870912);
        this.drawBorder(guiGraphics, boxX, boxY, boxX + boxWidth, boxY + boxHeight, -7019309);
        for (int i = 0; i < tooltip.size(); ++i) {
            guiGraphics.method_51430(class_310.method_1551().field_1772, (class_5481)tooltip.get(i), boxX + textPadding, boxY + textPadding + i * 12, -1, true);
        }
    }

    @Override
    @Nullable
    public class_8016 method_48205(@NotNull class_8023 navigation) {
        return super.method_48205(navigation);
    }

    public static class Builder {
        private Dim2i dim;
        private boolean renderOutline;
        private Page page;
        private class_437 screen;
        private ModOptions modOptions;

        public Builder withDimension(Dim2i dim) {
            this.dim = dim;
            return this;
        }

        public Builder withRenderOutline(boolean renderOutline) {
            this.renderOutline = renderOutline;
            return this;
        }

        public Builder withPage(Page page) {
            this.page = page;
            return this;
        }

        public Builder withScreen(class_437 screen) {
            this.screen = screen;
            return this;
        }

        public Builder withModOptions(ModOptions modConfig) {
            this.modOptions = modConfig;
            return this;
        }

        public PageFrame build() {
            Validate.notNull((Object)this.dim, (String)"Dimension must be specified", (Object[])new Object[0]);
            Validate.notNull((Object)this.page, (String)"Option Page must be specified", (Object[])new Object[0]);
            Validate.notNull((Object)this.screen, (String)"Screen must be specified", (Object[])new Object[0]);
            Validate.notNull((Object)this.modOptions, (String)"Mod Options must be specified", (Object[])new Object[0]);
            return new PageFrame(this.screen, this.dim, this.renderOutline, this.page, this.modOptions);
        }
    }
}

