/*
 * Decompiled with CFR 0.152.
 */
package fr.estecka.variantscit.reload;

import fr.estecka.variantscit.VariantsCitMod;
import fr.estecka.variantscit.assetgen.EAssetGenPass;
import fr.estecka.variantscit.assetgen.GeneratedResourcePack;
import fr.estecka.variantscit.assetgen.GeneratorPresets;
import fr.estecka.variantscit.assetgen.HotswappableResourceManager;
import fr.estecka.variantscit.assetgen.IAssetGenerator;
import fr.estecka.variantscit.modules.libraries.VariantLibrary;
import fr.estecka.variantscit.reload.EAssetType;
import fr.estecka.variantscit.reload.EModuleContext;
import fr.estecka.variantscit.reload.ModuleDefinition;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_7367;

public class VariantAggregator {
    private final Map<ModuleDefinition, class_2960> moduleIds = new IdentityHashMap<ModuleDefinition, class_2960>();
    private final Map<ModuleDefinition, IAssetGenerator> assetGenerators = new IdentityHashMap<ModuleDefinition, IAssetGenerator>();
    private final Map<ModuleDefinition, VariantLibrary> item_model = new IdentityHashMap<ModuleDefinition, VariantLibrary>();
    private final Map<ModuleDefinition, VariantLibrary> equippable = new IdentityHashMap<ModuleDefinition, VariantLibrary>();
    public final Map<class_2960, GeneratedAsset> generatedAssets = new HashMap<class_2960, GeneratedAsset>();
    public final Set<String> conflictingModelPrefixes = new HashSet<String>();

    public VariantAggregator(Map<class_2960, ModuleDefinition> modules) {
        for (Map.Entry<class_2960, ModuleDefinition> entry : modules.entrySet()) {
            ModuleDefinition module = entry.getValue();
            this.moduleIds.put(module, entry.getKey());
            for (EModuleContext context : module.contexts()) {
                this.GetLibraryMap(context).put(module, VariantAggregator.EmptyLibrary(module));
            }
            this.assetGenerators.put(module, module.assetGen().orElse(GeneratorPresets.LegacyGenerator(module)));
        }
    }

    private static VariantLibrary EmptyLibrary(ModuleDefinition module) {
        return new VariantLibrary(module.fallbackModel().orElse(null), new HashMap<class_2960, class_2960>(), module.specialModels());
    }

    private Map<ModuleDefinition, VariantLibrary> GetLibraryMap(EModuleContext context) {
        return switch (context) {
            default -> throw new AssertionError((Object)"Invalid Context");
            case EModuleContext.EQUIPPABLE -> this.equippable;
            case EModuleContext.ITEM_MODEL -> this.item_model;
        };
    }

    public Optional<VariantLibrary> GetLibrary(EModuleContext context, ModuleDefinition module) {
        return Optional.ofNullable(this.GetLibraryMap(context).get(module));
    }

    public void GatherAll(HotswappableResourceManager manager) {
        Map<class_2960, class_7367<InputStream>> genPack = GeneratedResourcePack.INSTANCE.Reset();
        this.GatherType(EAssetType.EQUIP_TEXTURE, manager.Get());
        this.GatherType(EAssetType.ITEM_TEXTURE, manager.Get());
        this.UpdateGeneratedPack(genPack, manager);
        this.GatherType(EAssetType.BAKED_MODEL, manager.Get());
        this.UpdateGeneratedPack(genPack, manager);
        this.GatherType(EAssetType.ITEM_STATE, manager.Get());
        this.GatherType(EAssetType.EQUIPMENT, manager.Get());
    }

    private void GatherType(EAssetType assetType, class_3300 manager) {
        Set resources = manager.method_14488(assetType.directory, id -> id.method_12832().endsWith(assetType.suffix)).keySet();
        Stream<class_2960> shortIds = resources.stream().map(id -> assetType.GetShortId((class_2960)id).get());
        this.GatherIds(assetType, shortIds);
    }

    private void GatherIds(EAssetType assetType, Stream<class_2960> assets) {
        assets.forEach(shortId -> this.ApplyModelToAll(assetType, (class_2960)shortId));
    }

    private void ApplyModelToAll(EAssetType assetType, class_2960 shortId) {
        EAssetGenPass generatorPass = switch (assetType) {
            default -> null;
            case EAssetType.EQUIP_TEXTURE -> EAssetGenPass.EQUIPMENTS;
            case EAssetType.ITEM_TEXTURE -> EAssetGenPass.BAKED_MODELS;
            case EAssetType.BAKED_MODEL -> EAssetGenPass.ITEM_STATES;
        };
        for (Map.Entry<ModuleDefinition, VariantLibrary> entry : this.GetLibraryMap(assetType.context).entrySet()) {
            ModuleDefinition module = entry.getKey();
            VariantLibrary library = entry.getValue();
            VariantsCitMod.LOGGER.PushLabel(this.moduleIds.get(module));
            this.ApplyModelToModule(assetType.isFundamental, module, library, shortId);
            if (generatorPass != null) {
                IAssetGenerator generator = this.assetGenerators.get(module);
                IAssetGenerator.Result generatedResources = generator.AcceptAsset(generatorPass, shortId);
                for (Map.Entry e : generatedResources.entrySet()) {
                    if (!this.ApplyModelToModule(false, module, library, ((IAssetGenerator.ParentedResource)e.getValue()).radical())) continue;
                    class_2960 resourceId = generatorPass.GetOutputResourceId((class_2960)e.getKey());
                    this.OnGeneratedResource(resourceId, module.modelPrefix(), ((IAssetGenerator.ParentedResource)e.getValue()).resource());
                }
            }
            VariantsCitMod.LOGGER.PopLabel();
        }
    }

    private boolean ApplyModelToModule(boolean isFundamental, ModuleDefinition module, VariantLibrary library, class_2960 shortId) {
        boolean accepted = false;
        if (shortId.equals((Object)library.fallbackModel())) {
            accepted = true;
        }
        if (library.specialModels().containsValue(shortId)) {
            accepted = true;
        }
        if (shortId.method_12832().startsWith(module.modelPrefix())) {
            class_2960 variantId = class_2960.method_60655((String)shortId.method_12836(), (String)shortId.method_12832().substring(module.modelPrefix().length()));
            if (module.parameters().AcceptsVariant(variantId)) {
                accepted = true;
                if (isFundamental) {
                    library.variantModels().put(variantId, shortId);
                }
            }
        }
        return accepted;
    }

    private void UpdateGeneratedPack(Map<class_2960, class_7367<InputStream>> pack, HotswappableResourceManager manager) {
        for (Map.Entry<class_2960, GeneratedAsset> entry : this.generatedAssets.entrySet()) {
            pack.put(entry.getKey(), entry.getValue().resource);
        }
        manager.Refresh();
    }

    private void OnGeneratedResource(class_2960 resourceId, String modelPrefix, class_7367<InputStream> resource) {
        int priority = modelPrefix.length();
        GeneratedAsset oldAsset = this.generatedAssets.get(resourceId);
        if (oldAsset == null || oldAsset.priority < priority) {
            this.generatedAssets.put(resourceId, new GeneratedAsset(resource, priority));
        }
    }

    public record GeneratedAsset(class_7367<InputStream> resource, int priority) {
    }
}

