/*
 * Decompiled with CFR 0.152.
 */
package fr.estecka.variantscit.reload;

import com.mojang.serialization.DataResult;
import fr.estecka.variantscit.CodecUtil;
import fr.estecka.variantscit.VariantsCitMod;
import fr.estecka.variantscit.assetgen.HotswappableResourceManager;
import fr.estecka.variantscit.modules.IBakedModule;
import fr.estecka.variantscit.reload.EModuleContext;
import fr.estecka.variantscit.reload.MetaModule;
import fr.estecka.variantscit.reload.ModuleDefinition;
import fr.estecka.variantscit.reload.VariantAggregator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public final class ModuleLoader {
    public static Result ReloadModules(HotswappableResourceManager manager) {
        class_2960 moduleId;
        ArrayList<MetaModule> metamodules = new ArrayList<MetaModule>();
        HashMap<class_2960, class_3298> resources = new HashMap<class_2960, class_3298>();
        HashMap<class_2960, ModuleDefinition> definitions = new HashMap<class_2960, ModuleDefinition>();
        resources.putAll(CodecUtil.GetResources(manager.Get(), "variant-cits/item", ".json"));
        ModuleLoader.ObsoletePathWarning(resources);
        resources.putAll(CodecUtil.GetResources(manager.Get(), "variants-cit/item", ".json"));
        resources.putAll(CodecUtil.GetResources(manager.Get(), "variants-cit/modules", ".json"));
        for (Map.Entry entry : resources.entrySet()) {
            moduleId = (class_2960)entry.getKey();
            DataResult<ModuleDefinition> optDefinition = CodecUtil.ParseResource((class_3298)entry.getValue(), ModuleDefinition.CODEC);
            if (optDefinition.isError()) {
                VariantsCitMod.LOGGER.error("Error in VCIT module {}: {}", moduleId, ((DataResult.Error)optDefinition.error().get()).message());
                continue;
            }
            ModuleDefinition definition = (ModuleDefinition)optDefinition.getOrThrow();
            if (definition.contexts().isEmpty()) {
                VariantsCitMod.LOGGER.warn("Skipped VCIT module with no context: {}", moduleId);
                continue;
            }
            if (ModuleLoader.ItemsFromModule(moduleId, definition).isEmpty()) {
                VariantsCitMod.LOGGER.warn("Skipped VCIT module with no valid item: {}", moduleId);
                continue;
            }
            if (definition.modelPrefix().isEmpty()) {
                VariantsCitMod.LOGGER.error("VCIT module `{}` has an empty model prefix. This can lead to unexpected behaviours and performance loss.", moduleId);
            }
            definitions.put(moduleId, definition);
        }
        Result result = new Result(definitions);
        result.variantAggregator.GatherAll(manager);
        for (Map.Entry entry : definitions.entrySet()) {
            moduleId = (class_2960)entry.getKey();
            ModuleDefinition definition = (ModuleDefinition)entry.getValue();
            Set<class_1792> targets = ModuleLoader.ItemsFromModule(moduleId, definition);
            MetaModule meta = new MetaModule(moduleId, definition.priority(), targets, definition.modelPrefix(), result.variantAggregator.GetLibrary(EModuleContext.ITEM_MODEL, definition).map(definition.parameters()::Bake), result.variantAggregator.GetLibrary(EModuleContext.EQUIPPABLE, definition).map(definition.parameters()::Bake));
            result.allModules.put(moduleId, meta);
            metamodules.add(meta);
        }
        metamodules.sort((a, b) -> -Integer.compare(a.priority(), b.priority()));
        if (!result.variantAggregator.conflictingModelPrefixes.isEmpty()) {
            Object message = "Some modules with identical model prefixes have conflicting model parents, it is undefined which parent will be used. The following prefixes are involved: ";
            for (String prefix : result.variantAggregator.conflictingModelPrefixes) {
                message = (String)message + "\n - " + prefix;
            }
            VariantsCitMod.LOGGER.error((String)message, new Object[0]);
        }
        ModuleLoader.BakeModules(result, metamodules);
        return result;
    }

    private static void ObsoletePathWarning(Map<class_2960, class_3298> resources) {
        if (!resources.isEmpty()) {
            Object names = "";
            for (class_2960 id : resources.keySet()) {
                names = (String)names + " ";
                names = (String)names + id.toString();
            }
            VariantsCitMod.LOGGER.warn("Some VCIT modules are using the old mispelled directory `variant-cits`, those should be moved to `variants-cit` instead:{}", names);
        }
    }

    private static Set<class_1792> ItemsFromModule(class_2960 moduleId, ModuleDefinition module) {
        return module.targets().map(ModuleLoader::ItemsFromTarget).orElseGet(() -> ModuleLoader.ItemsFromModuleId(moduleId));
    }

    private static Set<class_1792> ItemsFromTarget(List<class_2960> targets) {
        HashSet<class_1792> result = new HashSet<class_1792>();
        targets.stream().map(id -> class_7923.field_41178.method_10223(id)).filter(Optional::isPresent).map(opt -> (class_1792)((class_6880.class_6883)opt.get()).comp_349()).forEach(result::add);
        return result;
    }

    private static Set<class_1792> ItemsFromModuleId(class_2960 moduleId) {
        if (class_7923.field_41178.method_10250(moduleId)) {
            return Set.of((class_1792)((class_6880.class_6883)class_7923.field_41178.method_10223(moduleId).get()).comp_349());
        }
        return Set.of();
    }

    public static void BakeModules(Result result, List<MetaModule> modules) {
        HashMap<class_1792, List<IBakedModule>> itemModules = new HashMap<class_1792, List<IBakedModule>>();
        HashMap<class_1792, List<IBakedModule>> equipModules = new HashMap<class_1792, List<IBakedModule>>();
        for (MetaModule meta : modules) {
            if (meta.itemModule().isPresent()) {
                ModuleLoader.BakeModuleContext(meta, meta.itemModule().get(), itemModules);
            }
            if (!meta.equipModule().isPresent()) continue;
            ModuleLoader.BakeModuleContext(meta, meta.equipModule().get(), equipModules);
        }
        ModuleLoader.BakeItem(result.itemModules, itemModules);
        ModuleLoader.BakeItem(result.equipModules, equipModules);
    }

    private static void BakeModuleContext(MetaModule meta, IBakedModule bakedModule, Map<class_1792, List<IBakedModule>> output) {
        for (class_1792 itemType : meta.targets()) {
            output.computeIfAbsent(itemType, __ -> new ArrayList()).add(bakedModule);
        }
    }

    private static void BakeItem(Map<class_1792, IBakedModule> result, Map<class_1792, List<IBakedModule>> moduleListPerItem) {
        for (Map.Entry<class_1792, List<IBakedModule>> entry : moduleListPerItem.entrySet()) {
            result.put(entry.getKey(), IBakedModule.OfList(entry.getValue()));
        }
    }

    public static class Result {
        public final Map<class_1792, IBakedModule> itemModules = new HashMap<class_1792, IBakedModule>();
        public final Map<class_1792, IBakedModule> equipModules = new HashMap<class_1792, IBakedModule>();
        public final Map<class_2960, MetaModule> allModules = new HashMap<class_2960, MetaModule>();
        public final VariantAggregator variantAggregator;

        private Result(Map<class_2960, ModuleDefinition> modules) {
            this.variantAggregator = new VariantAggregator(modules);
        }
    }
}

