/*
 * Decompiled with CFR 0.152.
 */
package fr.estecka.variantscit.reload;

import fr.estecka.variantscit.reload.EModuleContext;
import java.util.Optional;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public enum EAssetType {
    ITEM_TEXTURE(EModuleContext.ITEM_MODEL, false, "textures/item", ".png"),
    BAKED_MODEL(EModuleContext.ITEM_MODEL, false, "models/item", ".json"),
    ITEM_STATE(EModuleContext.ITEM_MODEL, true, "items", ".json"),
    EQUIP_TEXTURE(EModuleContext.EQUIPPABLE, false, "textures/entity/equipment", ".png"),
    EQUIPMENT(EModuleContext.EQUIPPABLE, true, "equipment", ".json");

    public final EModuleContext context;
    public final boolean isFundamental;
    @Nullable
    public final String vanillaPrefix;
    public final String directory;
    public final String suffix;

    private EAssetType(EModuleContext context, boolean isFundamental, String directory, String suffix) {
        this.context = context;
        this.isFundamental = isFundamental;
        this.directory = directory;
        this.suffix = suffix;
        int subDir = directory.indexOf("/");
        this.vanillaPrefix = subDir >= 0 ? directory.substring(subDir + 1) : null;
    }

    public Optional<class_2960> GetShortId(class_2960 resourceId) {
        String path = resourceId.method_12832();
        if (!path.startsWith(this.directory + "/") || !path.endsWith(this.suffix)) {
            return Optional.empty();
        }
        return Optional.of(resourceId.method_45136(path.substring(this.directory.length() + 1, path.length() - this.suffix.length())));
    }

    public class_2960 GetVanillaId(class_2960 shortId) {
        if (this.vanillaPrefix == null) {
            return shortId;
        }
        return shortId.method_45134(path -> this.vanillaPrefix + "/" + path);
    }
}

