/*
 * Decompiled with CFR 0.152.
 */
package fr.estecka.variantscit.modules.libraries;

import fr.estecka.variantscit.api.ICitModule;
import fr.estecka.variantscit.api.IVariantManager;
import fr.estecka.variantscit.commands.CommandLogger;
import fr.estecka.variantscit.modules.IBakedModule;
import fr.estecka.variantscit.modules.libraries.GenericBakedModule;
import fr.estecka.variantscit.modules.libraries.IDebuggableLibrary;
import java.util.Map;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public record VariantLibrary(@Nullable class_2960 fallbackModel, Map<class_2960, class_2960> variantModels, Map<String, class_2960> specialModels) implements IVariantManager,
IDebuggableLibrary<IVariantManager>
{
    @Override
    public boolean HasVariantModel(class_2960 variant) {
        return this.variantModels.containsKey(variant);
    }

    @Override
    @Nullable
    public class_2960 GetVariantModel(class_2960 variant) {
        if (variant == null) {
            return null;
        }
        return this.variantModels.getOrDefault(variant, this.fallbackModel);
    }

    @Override
    @Nullable
    public class_2960 GetSpecialModel(String key) {
        return this.specialModels.get(key);
    }

    public int GetVariantCount() {
        return this.variantModels.size();
    }

    public boolean isEmpty() {
        return this.variantModels.isEmpty() && this.specialModels.isEmpty() && this.fallbackModel == null;
    }

    public IBakedModule Bake(ICitModule logic) {
        return new GenericBakedModule<IVariantManager>(this, logic);
    }

    @Override
    public void Summary(CommandLogger logger) {
        logger.Info("This module handles {} variants.", this.variantModels.size());
    }

    @Override
    public void Dump(CommandLogger logger) {
        if (this.variantModels.isEmpty()) {
            logger.Info("This module does not have any variant.");
        } else {
            for (Map.Entry<class_2960, class_2960> entry : this.variantModels.entrySet()) {
                logger.Info("{} -> {} ", CommandLogger.ItemData(entry.getKey()), CommandLogger.PackData(entry.getValue()));
            }
        }
    }

    @Override
    public IDebuggableLibrary.Snitch<IVariantManager> CreateSnitch(CommandLogger logger) {
        return new SnitchingLibrary(logger);
    }

    private class SnitchingLibrary
    extends IDebuggableLibrary.Snitch<IVariantManager>
    implements IVariantManager {
        public SnitchingLibrary(CommandLogger logger) {
            super(logger);
        }

        @Override
        public boolean HasVariantModel(@Nullable class_2960 variantId) {
            boolean r = VariantLibrary.this.HasVariantModel(variantId);
            this.OnTriedVariant(variantId, r);
            return r;
        }

        @Override
        @Nullable
        public class_2960 GetVariantModel(class_2960 variantId) {
            this.HasVariantModel(variantId);
            return VariantLibrary.this.GetVariantModel(variantId);
        }

        @Override
        @Nullable
        public class_2960 GetSpecialModel(String key) {
            class_2960 r = VariantLibrary.this.GetSpecialModel(key);
            this.OnTriedSpecial(key, r != null);
            return r;
        }

        @Override
        protected void OnTriedVariant(class_2960 variantId, boolean exists) {
            this.logger.Info("Tested variant ID: {}", CommandLogger.ItemData(variantId));
            super.OnTriedVariant(variantId, exists);
        }
    }
}

