/*
 * Decompiled with CFR 0.152.
 */
package fr.estecka.variantscit.modules.libraries;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.function.Predicate;

public class LinearSnapMap<T>
implements Iterable<Entry<T>> {
    private final ArrayList<Entry<T>> entries = new ArrayList();
    private final Comparator<T> discriminator;

    public LinearSnapMap(Comparator<T> discriminator) {
        this.discriminator = discriminator;
    }

    public LinearSnapMap() {
        this((a, b) -> 0);
    }

    public int size() {
        return this.entries.size();
    }

    @Override
    public Iterator<Entry<T>> iterator() {
        return this.entries.iterator();
    }

    private int CompareEntries(Entry<T> a, Entry<T> b) {
        int r = Integer.compare(a.magnitude, b.magnitude);
        if (r != 0) {
            return r;
        }
        return this.discriminator.compare(a.value, b.value);
    }

    public final void AddEntry(int magnitude, T value) {
        this.entries.add(new Entry<T>(magnitude, value));
        this.entries.sort(this::CompareEntries);
    }

    public final void AddEntries(Collection<Entry<T>> entries) {
        this.entries.addAll(entries);
        this.entries.sort(this::CompareEntries);
    }

    private int GetClosestIndex(int targetMagnitude, int bias) {
        int iMin = -1;
        int iMax = this.entries.size();
        int iBestFit = -1;
        while (iMin + 1 < iMax) {
            boolean nudgeUp;
            int midpoint = (iMax + iMin) / 2;
            int midMagnitude = this.entries.get((int)midpoint).magnitude;
            if (midMagnitude == targetMagnitude && bias == 0) {
                return midpoint;
            }
            if (midMagnitude == targetMagnitude || midMagnitude < targetMagnitude && bias < 0 || midMagnitude > targetMagnitude && bias > 0) {
                iBestFit = midpoint;
            }
            if (midMagnitude < targetMagnitude) {
                nudgeUp = true;
            } else if (midMagnitude > targetMagnitude) {
                nudgeUp = false;
            } else {
                boolean bl = nudgeUp = bias < 0;
            }
            if (nudgeUp) {
                iMin = midpoint;
                continue;
            }
            iMax = midpoint;
        }
        return iBestFit;
    }

    public final T GetClosestValue(int targetMagnitude, int bias) {
        int i = this.GetClosestIndex(targetMagnitude, bias);
        if (i < 0) {
            return null;
        }
        return this.entries.get((int)i).value;
    }

    public final T GetClosestValue(int targetMagnitude, int bias, Predicate<T> isElligible) {
        int direction;
        int i = this.GetClosestIndex(targetMagnitude, bias);
        if (i < 0) {
            return null;
        }
        int n = direction = bias > 0 ? 1 : -1;
        while (0 <= i && i < this.entries.size()) {
            Entry<T> result = this.entries.get(i);
            if (isElligible.test(result.value)) {
                return result.value;
            }
            i += direction;
        }
        return null;
    }

    public final T GetClosestValue(int targetMagnitude, int bias, Predicate<T> isElligible, Comparator<T> comparator) {
        int direction;
        int i = this.GetClosestIndex(targetMagnitude, bias);
        if (i < 0) {
            return null;
        }
        Entry<T> bestFit = null;
        int n = direction = bias > 0 ? 1 : -1;
        while (0 <= i && i < this.entries.size()) {
            Entry<T> result = this.entries.get(i);
            if (bestFit == null && isElligible.test(result.value)) {
                bestFit = result;
            } else {
                if (result.magnitude != bestFit.magnitude) break;
                if (isElligible.test(result.value) && comparator.compare(bestFit.value, result.value) < 0) {
                    bestFit = result;
                }
            }
            i += direction;
        }
        return bestFit.value;
    }

    public record Entry<T>(int magnitude, T value) {
    }
}

