/*
 * Decompiled with CFR 0.152.
 */
package fr.estecka.variantscit.modules.impl;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fr.estecka.variantscit.CodecUtil;
import fr.estecka.variantscit.MultiPropertyCache;
import fr.estecka.variantscit.commands.CommandLogger;
import fr.estecka.variantscit.format.NbtPath;
import fr.estecka.variantscit.modules.libraries.ILinearLibrary;
import fr.estecka.variantscit.modules.libraries.LinearLibrary;
import java.util.Map;
import net.minecraft.class_1799;
import net.minecraft.class_2514;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.minecraft.class_9331;
import org.jetbrains.annotations.Nullable;

public class ComponentThresholdModule
implements LinearLibrary.ILinearCitModule {
    public static final Codec<Integer> BIAS_CODEC = CodecUtil.Enum(Codec.STRING, Map.of("strictly_equal", 0, "lesser_or_equal", -1, "greater_or_equal", 1));
    public static final MapCodec<ComponentThresholdModule> MAPCODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)CodecUtil.IDENTIFIER_NAMESPACE.optionalFieldOf("namespace", (Object)"minecraft").forGetter(o -> o.namespace), (App)class_7923.field_49658.method_39673().fieldOf("componentType").forGetter(o -> o.componentType), (App)NbtPath.CODEC.optionalFieldOf("nbtPath", (Object)NbtPath.IDENTITY).forGetter(o -> o.nbtPath), (App)BIAS_CODEC.fieldOf("modelRange").forGetter(o -> o.bias), (App)Codec.FLOAT.optionalFieldOf("scale", (Object)Float.valueOf(1.0f)).forGetter(o -> Float.valueOf(o.scale)), (App)Codec.FLOAT.optionalFieldOf("offset", (Object)Float.valueOf(0.0f)).forGetter(o -> Float.valueOf(o.offset))).apply((Applicative)builder, ComponentThresholdModule::new));
    private final String namespace;
    private final MultiPropertyCache cache;
    private final class_9331<?> componentType;
    private final NbtPath nbtPath;
    private final int bias;
    private final float scale;
    private final float offset;

    public ComponentThresholdModule(String namespace, class_9331<?> component, NbtPath path, int bias, float scale, float offset) {
        this.componentType = component;
        this.namespace = namespace;
        this.nbtPath = path;
        this.bias = bias;
        this.scale = scale;
        this.offset = offset;
        this.cache = new MultiPropertyCache(false, component);
    }

    @Override
    public String GetNamespace() {
        return this.namespace;
    }

    @Override
    @Nullable
    public class_2960 GetItemModel(class_1799 stack, ILinearLibrary library) {
        return this.cache.ComputeIfAbsent(stack, _0 -> this.RecomputeItemModel(stack, library));
    }

    @Nullable
    public class_2960 RecomputeItemModel(class_1799 stack, ILinearLibrary library) {
        Integer value = this.GetComponentValue(stack);
        if (value == null) {
            return null;
        }
        return library.GetWithBias((int)((float)value.intValue() * this.scale + this.offset), this.bias);
    }

    @Override
    @Nullable
    public class_2960 Walkthrough(class_1799 stack, ILinearLibrary library, CommandLogger logger) {
        Integer value = this.GetComponentValue(stack);
        logger.Info("Raw data: {}", CommandLogger.ItemData(value, "missing or invalid"));
        if (value == null) {
            return null;
        }
        value = (int)((float)value.intValue() * this.scale + this.offset);
        logger.Info("Transformed: {}", CommandLogger.ItemData(value));
        return this.RecomputeItemModel(stack, library);
    }

    @Nullable
    private Integer GetComponentValue(class_1799 stack) {
        class_2520 nbt = CodecUtil.GetComponentNbt(stack, this.componentType);
        if (nbt == null) {
            return null;
        }
        if ((nbt = this.nbtPath.Resolve(nbt)) == null || !(nbt instanceof class_2514)) {
            return null;
        }
        class_2514 number = (class_2514)nbt;
        return number.method_10701();
    }
}

