/*
 * Decompiled with CFR 0.152.
 */
package fr.estecka.variantscit.format.transforms;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fr.estecka.variantscit.CodecUtil;
import fr.estecka.variantscit.VariantsCitMod;
import fr.estecka.variantscit.format.IStringTransform;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.exception.ExceptionUtils;

public record RegexTransform(Pattern pattern, String substitution, boolean matchAll, @Deprecated boolean validate) implements IStringTransform
{
    public static final MapCodec<RegexTransform> MAPCODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CodecUtil.REGEX.fieldOf("regex").forGetter(RegexTransform::pattern), (App)Codec.STRING.optionalFieldOf("substitution", (Object)"$0").forGetter(RegexTransform::substitution), (App)Codec.BOOL.optionalFieldOf("matchAll", (Object)true).forGetter(RegexTransform::matchAll), (App)Codec.BOOL.optionalFieldOf("validate", (Object)true).forGetter(RegexTransform::validate)).apply((Applicative)instance, RegexTransform::new));

    @Override
    public String apply(String input) {
        Matcher match = this.pattern.matcher(input);
        if (this.matchAll ? match.matches() : match.find()) {
            try {
                return match.replaceAll(this.substitution);
            }
            catch (IllegalArgumentException | IndexOutOfBoundsException e) {
                VariantsCitMod.LOGGER.error("Error in regex substitution: {}\n{}]", this.substitution, ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return this.validate ? null : input;
    }
}

