/*
 * Decompiled with CFR 0.152.
 */
package fr.estecka.variantscit.format.transforms;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fr.estecka.variantscit.CodecUtil;
import fr.estecka.variantscit.format.IStringTransform;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;

public record OptionalTransform(IStringTransform inner, @Nullable String fallback) implements IStringTransform
{
    public static <T extends IStringTransform> MapCodec<IStringTransform> CodecOf(MapCodec<T> inner) {
        return RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.BOOL.optionalFieldOf("optional", (Object)false).forGetter(OptionalTransform::IsOptional), (App)Codec.STRING.optionalFieldOf("fallback").forGetter(OptionalTransform::GetFallback), (App)CodecUtil.Anonymize(inner).forGetter(OptionalTransform::Unwrap)).apply((Applicative)builder, OptionalTransform::Wrap));
    }

    private static IStringTransform Wrap(boolean optional, Optional<String> fallback, IStringTransform inner) {
        if (optional || fallback.isPresent()) {
            return new OptionalTransform(inner, fallback.orElse(null));
        }
        return inner;
    }

    private static IStringTransform Unwrap(IStringTransform transform) {
        if (transform instanceof OptionalTransform) {
            OptionalTransform opt = (OptionalTransform)transform;
            return opt.inner;
        }
        return transform;
    }

    private static boolean IsOptional(IStringTransform transform) {
        return transform instanceof OptionalTransform;
    }

    private static Optional<String> GetFallback(IStringTransform transform) {
        if (transform instanceof OptionalTransform) {
            OptionalTransform opt = (OptionalTransform)transform;
            return Optional.of(opt.fallback);
        }
        return Optional.empty();
    }

    @Override
    public String apply(String input) {
        String result = (String)this.inner.apply(input);
        if (result != null) {
            return result;
        }
        if (this.fallback != null) {
            return this.fallback;
        }
        return input;
    }
}

