/*
 * Decompiled with CFR 0.152.
 */
package fr.estecka.variantscit.format;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import fr.estecka.variantscit.VariantsCitMod;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.minecraft.class_5699;

public class Substitution {
    public static final Codec<Substitution> CODEC = Codec.STRING.comapFlatMap(Substitution::Parse, Substitution::toString);
    public static final Codec<String> VARNAME_CODEC = class_5699.field_41759.validate(Substitution::ValidateVarname);
    public static final Pattern VARNAME_REGEX = Pattern.compile("^[a-zA-Z_][a-zA-Z0-9_]*$");
    private Token[] tokens;

    private Substitution(List<Token> tokens) {
        this.tokens = (Token[])tokens.toArray(Token[]::new);
    }

    public String Substitute(Map<String, String> variables) {
        StringBuilder builder = new StringBuilder();
        for (Token t : this.tokens) {
            builder.append(t.Substitute(variables));
        }
        return builder.toString();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Token t : this.tokens) {
            builder.append(t.toString());
        }
        return builder.toString();
    }

    public boolean Matches(Set<String> varnames) {
        int matchcount = 0;
        for (Token token : this.tokens) {
            if (!(token instanceof Variable)) continue;
            Variable varToken = (Variable)token;
            if (!varnames.contains(varToken.name)) {
                return false;
            }
            ++matchcount;
        }
        return matchcount == varnames.size();
    }

    public void MatchWarning(Set<String> varnames) {
        if (!this.Matches(varnames)) {
            VariantsCitMod.LOGGER.warn("Format \"{}\" does not match the provided list of variables.", this);
        }
    }

    public static DataResult<Substitution> Parse(String input) {
        ArrayList<Token> result = new ArrayList<Token>();
        String remainder = input;
        while (!remainder.isEmpty()) {
            Parsed<Record> parsed;
            try {
                parsed = !remainder.startsWith("$") ? Substitution.NextLiteral(remainder) : Substitution.NextVariable(remainder);
            }
            catch (IllegalArgumentException e) {
                return DataResult.error(e::getMessage);
            }
            result.add((Token)parsed.token);
            remainder = parsed.remainder;
        }
        return DataResult.success((Object)new Substitution(result));
    }

    private static Parsed<Literal> NextLiteral(String input) throws IllegalArgumentException {
        int end = input.indexOf("$");
        if (end < 0) {
            end = input.length();
        }
        String literal = input.substring(0, end);
        return new Parsed<Literal>(new Literal(literal), input.substring(end));
    }

    private static Parsed<Variable> NextVariable(String input) throws IllegalArgumentException {
        String name;
        int end;
        if (input.startsWith("${") && (end = input.indexOf("}")) > 2 && Substitution.IsVarnameValid(name = input.substring(2, end))) {
            return new Parsed<Variable>(new Variable(name), input.substring(end + 1));
        }
        throw new IllegalArgumentException("Invalid variable format");
    }

    public static final DataResult<String> ValidateVarname(String input) {
        if (Substitution.IsVarnameValid(input)) {
            return DataResult.success((Object)input);
        }
        return DataResult.error(() -> "Invalid character in string: " + input);
    }

    public static final boolean IsVarnameValid(String input) {
        return VARNAME_REGEX.matcher(input).matches();
    }

    @FunctionalInterface
    private static interface Token {
        public String Substitute(Map<String, String> var1);
    }

    private record Variable(String name) implements Token
    {
        @Override
        public String Substitute(Map<String, String> variables) {
            return variables.getOrDefault(this.name, "");
        }

        @Override
        public String toString() {
            return "${" + this.name + "}";
        }
    }

    private record Parsed<T extends Token>(T token, String remainder) {
    }

    private record Literal(String value) implements Token
    {
        @Override
        public String Substitute(Map<String, String> variables) {
            return this.value;
        }

        @Override
        public String toString() {
            return this.value;
        }
    }
}

