/*
 * Decompiled with CFR 0.152.
 */
package fr.estecka.variantscit.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import fr.estecka.variantscit.VariantsCitMod;
import fr.estecka.variantscit.assetgen.FilledTemplate;
import fr.estecka.variantscit.assetgen.GeneratedResourcePack;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2172;
import net.minecraft.class_2232;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3283;
import net.minecraft.class_7157;
import net.minecraft.class_7367;
import org.apache.commons.io.FileUtils;

public class AssetGenCommands {
    public static final class_2960 ID = class_2960.method_60655((String)"variants-cit", (String)"assetgen");
    public static final String BAKED_PACK_DIR = "VCIT Baked AssetGen";
    public static final String ASSET_ARG = "asset id";

    public static void Register() {
        ClientCommandRegistrationCallback.EVENT.register(ID, AssetGenCommands::RegisterWith);
    }

    public static void RegisterWith(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 registryAccess) {
        LiteralArgumentBuilder pack = (LiteralArgumentBuilder)ClientCommandManager.literal((String)"createPack").executes(AssetGenCommands::CreatePack);
        LiteralArgumentBuilder peek = (LiteralArgumentBuilder)ClientCommandManager.literal((String)"peek").then(ClientCommandManager.argument((String)ASSET_ARG, (ArgumentType)class_2232.method_9441()).suggests(AssetGenCommands::AssetAutofill).executes(AssetGenCommands::AssetDump));
        LiteralArgumentBuilder root = (LiteralArgumentBuilder)ClientCommandManager.literal((String)"variants-cit").then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"assetgen").then((ArgumentBuilder)peek)).then((ArgumentBuilder)pack));
        dispatcher.register(root);
    }

    private static CompletableFuture<Suggestions> AssetAutofill(CommandContext<FabricClientCommandSource> context, SuggestionsBuilder builder) {
        class_2172.method_9270(GeneratedResourcePack.INSTANCE.GetAll().keySet(), (SuggestionsBuilder)builder);
        return builder.buildFuture();
    }

    private static int Error(CommandContext<FabricClientCommandSource> context, String message) {
        ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)message));
        return -1;
    }

    private static int AssetDump(CommandContext<FabricClientCommandSource> context) throws CommandSyntaxException {
        class_2960 id = (class_2960)context.getArgument(ASSET_ARG, class_2960.class);
        FilledTemplate resource = (FilledTemplate)GeneratedResourcePack.INSTANCE.GetAll().get(id);
        if (resource == null) {
            return AssetGenCommands.Error(context, "No such asset: " + id.toString());
        }
        VariantsCitMod.LOGGER.info("{}:\n{}", id, resource.getString());
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Asset content was printed into the game's log."));
        return 0;
    }

    private static int CreatePack(CommandContext<FabricClientCommandSource> context) throws CommandSyntaxException {
        File base = ((Path)((ModContainer)FabricLoader.getInstance().getModContainer("variants-cit").get()).findPath("baked_pack_base").get()).toFile();
        File pack = FabricLoader.getInstance().getGameDir().resolve("resourcepacks/VCIT Baked AssetGen").toFile();
        if (!base.exists() || !base.isDirectory()) {
            return AssetGenCommands.Error(context, "Missing base for baked assetgen pack.");
        }
        if (pack.exists()) {
            if (!pack.isDirectory()) {
                return AssetGenCommands.Error(context, "File \"VCIT Baked AssetGen\" already exists but is not a directory.");
            }
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Deleting existing pack..."));
            try {
                FileUtils.deleteDirectory((File)pack);
            }
            catch (IOException e) {
                VariantsCitMod.LOGGER.error("Unable to delete existing baked assetgen pack:\n{}", e);
                return AssetGenCommands.Error(context, "Unable to delete existing baked assetgen pack.");
            }
        }
        try {
            FileUtils.copyDirectory((File)base, (File)pack);
        }
        catch (IOException e) {
            VariantsCitMod.LOGGER.error("Unable to initialize baked pack:\n{}", e);
            return AssetGenCommands.Error(context, "Unable to initialize baked pack.");
        }
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Writing assets..."));
        boolean error = false;
        for (Map.Entry<class_2960, class_7367<InputStream>> entry : GeneratedResourcePack.INSTANCE.GetAll().entrySet()) {
            class_2960 id = entry.getKey();
            String assetPath = "assets/" + id.method_12836() + "/" + id.method_12832();
            Path assetDst = pack.toPath().resolve(assetPath);
            assetDst.getParent().toFile().mkdirs();
            try {
                Files.write(assetDst, ((InputStream)entry.getValue().get()).readAllBytes(), new OpenOption[0]);
            }
            catch (IOException e) {
                VariantsCitMod.LOGGER.error("Error writing file: {}\n{}", assetDst, e);
            }
        }
        if (error) {
            return AssetGenCommands.Error(context, "Error while writing some assets. See log for details.");
        }
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Done\u00a0!"));
        class_3283 packManager = class_310.method_1551().method_1520();
        String packId = "file/VCIT Baked AssetGen";
        ArrayList<String> enabled = new ArrayList<String>(packManager.method_29210());
        if (!packManager.method_29210().contains(packId)) {
            enabled.addFirst(packId);
            packManager.method_14445();
            packManager.method_14447(enabled);
        }
        class_310.method_1551().method_1521();
        return 1;
    }
}

