/*
 * Decompiled with CFR 0.152.
 */
package fr.estecka.variantscit.assetgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fr.estecka.variantscit.CodecUtil;
import fr.estecka.variantscit.VariantsCitMod;
import fr.estecka.variantscit.assetgen.EAssetGenPass;
import fr.estecka.variantscit.assetgen.FilledTemplate;
import fr.estecka.variantscit.assetgen.IAssetGenerator;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_2960;
import org.apache.commons.lang3.exception.ExceptionUtils;

public record TemplatedAssetGenerator(EAssetGenPass pass, Pattern inputRegex, String outputSubst, Optional<String> radicalSubst, FilledTemplate template) implements IAssetGenerator
{
    public static final MapCodec<TemplatedAssetGenerator> MAPCODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)EAssetGenPass.CODEC.fieldOf("pass").forGetter(TemplatedAssetGenerator::pass), (App)CodecUtil.REGEX.optionalFieldOf("inputPath", (Object)Pattern.compile(".*")).forGetter(TemplatedAssetGenerator::inputRegex), (App)Codec.STRING.optionalFieldOf("outputPath", (Object)"$0").forGetter(TemplatedAssetGenerator::outputSubst), (App)Codec.STRING.optionalFieldOf("radicalPath").forGetter(TemplatedAssetGenerator::radicalSubst), (App)FilledTemplate.MAPCODEC.forGetter(TemplatedAssetGenerator::template)).apply((Applicative)builder, TemplatedAssetGenerator::new));

    public TemplatedAssetGenerator(EAssetGenPass pass, Pattern inputRegex, FilledTemplate template) {
        this(pass, inputRegex, "$0", Optional.of("$0"), template);
    }

    @Override
    public IAssetGenerator.Result AcceptAsset(EAssetGenPass pass, class_2960 inputId) {
        IAssetGenerator.Result result = new IAssetGenerator.Result();
        Matcher inputMatcher = this.inputRegex.matcher(inputId.method_12832());
        if (pass != this.pass || !inputMatcher.matches()) {
            return result;
        }
        Optional<String> outPath = TemplatedAssetGenerator.SubstitutePath(inputMatcher, this.outputSubst);
        Optional<String> radPath = TemplatedAssetGenerator.SubstitutePath(inputMatcher, this.radicalSubst.orElse(this.outputSubst));
        if (outPath.isPresent() && radPath.isPresent()) {
            class_2960 outputId = inputId.method_45136(outPath.get());
            class_2960 radicalId = inputId.method_45136(radPath.get());
            result.putIfAbsent(outputId, new IAssetGenerator.ParentedResource(radicalId, this.template.Backfilled(Map.of("NAMESPACE", inputId.method_12836())).Backfilled(FilledTemplate.IdVariables("INPUT", pass.input.GetVanillaId(inputId))).Backfilled(FilledTemplate.IdVariables("OUTPUT", pass.output.GetVanillaId(outputId))).Backfilled(FilledTemplate.IdVariables("RADICAL", pass.output.GetVanillaId(radicalId)))));
        }
        return result;
    }

    private static Optional<String> SubstitutePath(Matcher matcher, String substitution) {
        String stringResult;
        try {
            stringResult = matcher.replaceAll(substitution);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            VariantsCitMod.LOGGER.error("Error in regex substitution:\n- Regex: {}\n- Substitution: {}\n{}", matcher.pattern().pattern(), substitution, ExceptionUtils.getStackTrace((Throwable)e));
            return Optional.empty();
        }
        if (!class_2960.method_20208((String)stringResult)) {
            VariantsCitMod.LOGGER.error("Asset Generator resulted in invalid identifier path: {}:{}\n- Regex: {}\n- Substitution: {}", stringResult, matcher.pattern().pattern(), substitution);
            return Optional.empty();
        }
        return Optional.of(stringResult);
    }
}

