/*
 * Decompiled with CFR 0.152.
 */
package fr.estecka.variantscit.assetgen;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import fr.estecka.variantscit.CodecUtil;
import fr.estecka.variantscit.VariantsCitMod;
import fr.estecka.variantscit.format.Substitution;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;

public class TemplateRepository {
    private static final String DIRECTORY = "variants-cit/templates";
    private static final String EXTENSION = ".json";
    private static final Map<class_2960, Substitution> TEMPLATES = new HashMap<class_2960, Substitution>();
    public static final Codec<Substitution> CODEC = CodecUtil.Enum(CodecUtil.VCIT_IDENTIFIER, TEMPLATES);

    public static DataResult<Substitution> Get(class_2960 id) {
        Substitution result = TEMPLATES.get(id);
        return result != null ? DataResult.success((Object)result) : DataResult.error(() -> "No such template: " + id.toString());
    }

    public static void ReloadPatterns(class_3300 manager) {
        TEMPLATES.clear();
        Map resources = manager.method_14488(DIRECTORY, id -> id.method_12832().endsWith(EXTENSION));
        for (Map.Entry entry : resources.entrySet()) {
            class_3298 resource = (class_3298)entry.getValue();
            class_2960 id2 = ((class_2960)entry.getKey()).method_45134(path -> path.substring(DIRECTORY.length() + 1, path.length() - EXTENSION.length()));
            DataResult<Substitution> result = TemplateRepository.CreateTemplate(resource);
            if (result.isError()) {
                VariantsCitMod.LOGGER.error("Error loading template:{}\n{}", id2, ((DataResult.Error)result.error().get()).message());
                continue;
            }
            TEMPLATES.put(id2, (Substitution)result.getOrThrow());
        }
    }

    private static DataResult<Substitution> CreateTemplate(class_3298 resource) {
        BufferedReader reader;
        try {
            reader = resource.method_43039();
        }
        catch (IOException e) {
            return DataResult.error(e::getMessage);
        }
        Object raw = "";
        Iterator lines = reader.lines().iterator();
        while (lines.hasNext()) {
            raw = (String)raw + (String)lines.next() + "\n";
        }
        return Substitution.Parse((String)raw);
    }
}

