/*
 * Decompiled with CFR 0.152.
 */
package fr.estecka.variantscit.assetgen;

import com.mojang.serialization.Codec;
import fr.estecka.variantscit.CodecUtil;
import fr.estecka.variantscit.assetgen.EAssetGenPass;
import fr.estecka.variantscit.assetgen.GeneratorPresets;
import fr.estecka.variantscit.assetgen.TemplatedAssetGenerator;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_7367;

public interface IAssetGenerator {
    public static final IAssetGenerator NOOP = (_0, _1) -> new Result();
    public static final Codec<IAssetGenerator> CODEC = CodecUtil.OneOrMany(Codec.withAlternative(GeneratorPresets.PRESET_CODEC, (Codec)TemplatedAssetGenerator.MAPCODEC.codec())).xmap(ListGenerator::Wrap, ListGenerator::Unwrap);

    public Result AcceptAsset(EAssetGenPass var1, class_2960 var2);

    public static class Result
    extends HashMap<class_2960, ParentedResource> {
        public void PutAllIfAbsent(Result behind) {
            for (Map.Entry entry : behind.entrySet()) {
                this.putIfAbsent((class_2960)entry.getKey(), (ParentedResource)entry.getValue());
            }
        }
    }

    public record ParentedResource(class_2960 radical, class_7367<InputStream> resource) {
    }

    public record ListGenerator(IAssetGenerator[] subGenerators) implements IAssetGenerator
    {
        @Override
        public Result AcceptAsset(EAssetGenPass pass, class_2960 assetId) {
            Result result = new Result();
            for (IAssetGenerator generator : this.subGenerators) {
                result.PutAllIfAbsent(generator.AcceptAsset(pass, assetId));
            }
            return result;
        }

        public static ListGenerator Of(IAssetGenerator ... subGenerators) {
            return new ListGenerator(subGenerators);
        }

        public static <T extends IAssetGenerator> IAssetGenerator Wrap(List<T> list) {
            if (list.size() == 0) {
                return NOOP;
            }
            if (list.size() == 1) {
                return (IAssetGenerator)list.get(0);
            }
            return new ListGenerator((IAssetGenerator[])list.toArray(IAssetGenerator[]::new));
        }

        public static List<IAssetGenerator> Unwrap(IAssetGenerator generator) {
            if (generator instanceof ListGenerator) {
                ListGenerator list = (ListGenerator)generator;
                return List.of(list.subGenerators);
            }
            return List.of(generator);
        }
    }
}

