/*
 * Decompiled with CFR 0.152.
 */
package fr.estecka.variantscit.assetgen;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import fr.estecka.variantscit.CodecUtil;
import fr.estecka.variantscit.VariantsCitMod;
import fr.estecka.variantscit.assetgen.EAssetGenPass;
import fr.estecka.variantscit.assetgen.FilledTemplate;
import fr.estecka.variantscit.assetgen.IAssetGenerator;
import fr.estecka.variantscit.assetgen.TemplatedAssetGenerator;
import fr.estecka.variantscit.reload.ModuleDefinition;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.class_2960;
import net.minecraft.class_3300;

public final class GeneratorPresets {
    private static final String DIRECTORY = "variants-cit/assetgen_presets";
    private static final String EXTENSION = ".json";
    private static final Map<class_2960, IAssetGenerator> BAKED_PRESETS = new HashMap<class_2960, IAssetGenerator>();
    public static final Codec<IAssetGenerator> PRESET_CODEC = CodecUtil.Enum(CodecUtil.VCIT_IDENTIFIER, BAKED_PRESETS);

    public static void ReloadPresets(class_3300 manager) {
        Map result = CodecUtil.ReloadResources(manager, TemplatedAssetGenerator.MAPCODEC.codec().listOf(), DIRECTORY, EXTENSION);
        BAKED_PRESETS.clear();
        for (Map.Entry entry : result.entrySet()) {
            BAKED_PRESETS.put(entry.getKey(), IAssetGenerator.ListGenerator.Wrap((List)entry.getValue()));
        }
    }

    public static IAssetGenerator LegacyGenerator(ModuleDefinition module) {
        Pattern acceptAll = Pattern.compile(".*");
        if (!module.itemGen()) {
            return IAssetGenerator.NOOP;
        }
        DataResult<FilledTemplate> itemsTemplate = FilledTemplate.Stateless();
        if (itemsTemplate.isError()) {
            VariantsCitMod.LOGGER.error("Missing built-in template for option itemsFromModel.\n{}", ((DataResult.Error)itemsTemplate.error().get()).message());
            return IAssetGenerator.NOOP;
        }
        TemplatedAssetGenerator items = new TemplatedAssetGenerator(EAssetGenPass.ITEM_STATES, acceptAll, (FilledTemplate)itemsTemplate.getOrThrow());
        if (!module.modelParent().isPresent()) {
            return items;
        }
        DataResult<FilledTemplate> modelTemplate = FilledTemplate.ModelParent(module.modelParent().get().toString());
        if (modelTemplate.isError()) {
            VariantsCitMod.LOGGER.error("Missing built-in template for option modelParent.\n{}", ((DataResult.Error)modelTemplate.error().get()).message());
            return items;
        }
        TemplatedAssetGenerator models = new TemplatedAssetGenerator(EAssetGenPass.BAKED_MODELS, acceptAll, (FilledTemplate)modelTemplate.getOrThrow());
        return IAssetGenerator.ListGenerator.Of(items, models);
    }
}

