/*
 * Decompiled with CFR 0.152.
 */
package fr.estecka.variantscit;

import fr.estecka.variantscit.EquippableCache;
import fr.estecka.variantscit.LabelledLogger;
import fr.estecka.variantscit.commands.AssetGenCommands;
import fr.estecka.variantscit.commands.ModuleCommands;
import fr.estecka.variantscit.modules.IBakedModule;
import fr.estecka.variantscit.reload.EModuleContext;
import fr.estecka.variantscit.reload.MetaModule;
import fr.estecka.variantscit.reload.ModuleLoader;
import java.util.Map;
import net.fabricmc.api.ClientModInitializer;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class VariantsCitMod
implements ClientModInitializer {
    public static final String MODID = "variants-cit";
    public static final LabelledLogger LOGGER = new LabelledLogger();
    public static int reloadcount = 0;
    public static final EquippableCache EQUIPABLES = new EquippableCache();
    private static Map<class_1792, IBakedModule> ITEM_MODULES = Map.of();
    private static Map<class_1792, IBakedModule> EQUIP_MODULES = Map.of();
    private static Map<class_2960, MetaModule> META = Map.of();

    public static class_2960 Identifier(String path) {
        return class_2960.method_60655((String)MODID, (String)path);
    }

    @Nullable
    public static IBakedModule GetItemModule(class_1792 itemType) {
        return ITEM_MODULES.get(itemType);
    }

    @Nullable
    public static IBakedModule GetEquipmentModule(class_1792 itemType) {
        return EQUIP_MODULES.get(itemType);
    }

    public static Map<class_2960, MetaModule> GetMeta() {
        return Map.copyOf(META);
    }

    public static IBakedModule GetModule(EModuleContext context, class_2960 id) {
        MetaModule meta = META.get(id);
        if (meta == null) {
            return null;
        }
        return switch (context) {
            default -> throw new IllegalArgumentException();
            case EModuleContext.ITEM_MODEL -> meta.itemModule().orElse(null);
            case EModuleContext.EQUIPPABLE -> meta.equipModule().orElse(null);
        };
    }

    public void onInitializeClient() {
        ModuleCommands.Register();
        AssetGenCommands.Register();
    }

    public static void OnResourceReload(ModuleLoader.Result result) {
        ++reloadcount;
        EQUIPABLES.Clear();
        ITEM_MODULES = result.itemModules;
        EQUIP_MODULES = result.equipModules;
        META = result.allModules;
    }
}

