/*
 * Decompiled with CFR 0.152.
 */
package fr.estecka.variantscit;

import java.util.EmptyStackException;
import java.util.Stack;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LabelledLogger {
    public final Logger logger = LoggerFactory.getLogger((String)"variants-cit");
    private final Stack<Object> labels = new Stack();

    public Logger Unlabelled() {
        return this.logger;
    }

    public void PushLabel(Object tag) {
        this.labels.push(tag);
    }

    public void PopLabel() {
        try {
            this.labels.pop();
        }
        catch (EmptyStackException e) {
            this.logger.error("{}", (Throwable)e);
        }
    }

    public void Reset() {
        this.labels.clear();
    }

    public void Print(BiConsumer<String, Object[]> printer, String format, Object ... args) {
        StringBuilder builder = new StringBuilder();
        for (Object e : this.labels) {
            builder.append('[');
            builder.append(e.toString());
            builder.append(']');
        }
        builder.append(" ");
        builder.append(format);
        printer.accept(builder.toString(), args);
    }

    public void info(String format, Object ... args) {
        this.Print((arg_0, arg_1) -> ((Logger)this.logger).info(arg_0, arg_1), format, args);
    }

    public void warn(String format, Object ... args) {
        this.Print((arg_0, arg_1) -> ((Logger)this.logger).warn(arg_0, arg_1), format, args);
    }

    public void error(String format, Object ... args) {
        this.Print((arg_0, arg_1) -> ((Logger)this.logger).error(arg_0, arg_1), format, args);
    }

    public void trace(String format, Object ... args) {
        this.Print((arg_0, arg_1) -> ((Logger)this.logger).trace(arg_0, arg_1), format, args);
    }
}

