/*
 * Decompiled with CFR 0.152.
 */
package fr.estecka.variantscit;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import fr.estecka.variantscit.VariantsCitMod;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.minecraft.class_1799;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_9331;
import org.jetbrains.annotations.Nullable;

public final class CodecUtil {
    private static final class_310 client = class_310.method_1551();
    public static final Codec<class_2960> VCIT_IDENTIFIER = Codec.STRING.comapFlatMap(CodecUtil::VCitIdenfitier, class_2960::toString);
    public static final Codec<String> IDENTIFIER_PATH = Codec.STRING.validate(path -> class_2960.method_20208((String)path) ? DataResult.success((Object)path) : DataResult.error(() -> "Invalid character in path: " + path));
    public static final Codec<String> IDENTIFIER_NAMESPACE = Codec.STRING.validate(path -> class_2960.method_20209((String)path) ? DataResult.success((Object)path) : DataResult.error(() -> "Invalid character in namespace: " + path));
    public static final Codec<String> NONEMPTY_STRING = Codec.STRING.validate(string -> string.isEmpty() ? DataResult.error(() -> "String cannot be empty") : DataResult.success((Object)string));
    public static final Codec<Character> CHAR = Codec.string((int)1, (int)1).xmap(s -> Character.valueOf(s.charAt(0)), c -> String.valueOf(c));
    public static final Codec<Pattern> REGEX = Codec.STRING.comapFlatMap(CodecUtil::ParseRegex, Pattern::toString);

    public static DataResult<class_2960> VCitIdenfitier(String input) {
        if (!((String)input).contains(":")) {
            input = "variants-cit:" + (String)input;
        }
        return class_2960.method_29186((String)input);
    }

    public static DataResult<Pattern> ParseRegex(String regex) {
        try {
            return DataResult.success((Object)Pattern.compile(regex));
        }
        catch (PatternSyntaxException e) {
            return DataResult.error(e::toString);
        }
    }

    public static <K, V> Codec<V> Enum(Codec<K> keyCodec, Map<K, V> units) {
        return keyCodec.flatXmap(key -> units.containsKey(key) ? DataResult.success(units.get(key)) : DataResult.error(() -> "Unknown key: " + key.toString()), obj -> units.containsValue(obj) ? DataResult.success((Object)units.entrySet().stream().filter(entry -> obj.equals(entry.getValue())).map(Map.Entry::getKey).findFirst().get()) : DataResult.error(() -> "Unknown unit"));
    }

    public static <T> Function<T, DataResult<T>> WithWarning(String warning, Object ... args) {
        return o -> {
            VariantsCitMod.LOGGER.warn(warning, args);
            return DataResult.success((Object)o);
        };
    }

    public static <T> MapCodec<T> WithWarning(MapCodec<T> codec, String warning, Object ... args) {
        return codec.validate(CodecUtil.WithWarning(warning, args));
    }

    public static <T> Codec<List<T>> OneOrMany(Codec<T> original) {
        Codec listCodec = original.listOf();
        return Codec.withAlternative((Codec)listCodec, (Codec)Codec.of((Encoder)listCodec, (Decoder)original.map(List::of)));
    }

    public static <T> MapCodec<T> MapWithAlternative(MapCodec<T> primary, MapCodec<? extends T> alternative) {
        return MapCodec.assumeMapUnsafe((Codec)Codec.withAlternative((Codec)primary.codec(), (Codec)alternative.codec()));
    }

    @SafeVarargs
    public static <T> Codec<T> WithAlternatives(Codec<T> primary, Codec<T> ... altArray) {
        int i = altArray.length - 1;
        Codec alternative = altArray[i];
        --i;
        while (i >= 0) {
            alternative = Codec.withAlternative(altArray[i], alternative);
            --i;
        }
        return Codec.withAlternative(primary, alternative);
    }

    @SafeVarargs
    public static <T> MapCodec<T> MapWithAlternatives(MapCodec<T> primaryMap, MapCodec<T> ... mapArray) {
        Codec[] codecArray = new Codec[mapArray.length];
        for (int i = 0; i < mapArray.length; ++i) {
            codecArray[i] = mapArray[i].codec();
        }
        return MapCodec.assumeMapUnsafe(CodecUtil.WithAlternatives(primaryMap.codec(), codecArray));
    }

    public static <T> MapCodec<T> WithAlias(Codec<T> codec, String primary, String alias) {
        return CodecUtil.MapWithAlternative(codec.fieldOf(primary), codec.fieldOf(alias).validate(CodecUtil.WithWarning("VCIT field `{}` is deprecated. Use `{}` instead.", alias, primary)));
    }

    public static <T> MapCodec<Optional<T>> OptionalWithAlias(Codec<T> codec, String primary, String alias) {
        return CodecUtil.WithAlias(codec, primary, alias).xmap(Optional::of, Optional::get).orElse(Optional.empty());
    }

    public static <SUPER, SUB extends SUPER> MapCodec<SUPER> Anonymize(MapCodec<SUB> original) {
        return original.flatXmap(o -> DataResult.success((Object)o), o -> DataResult.error(() -> "Encoding not supported by anonymized codec."));
    }

    @Nullable
    public static <T> class_2520 GetComponentNbt(class_1799 stack, class_9331<T> type) {
        Object component = stack.method_58694(type);
        if (component == null) {
            return null;
        }
        return CodecUtil.GetComponentNbt(component, type.method_57876());
    }

    @Nullable
    public static <T> class_2520 GetComponentNbt(T component, Codec<T> codec) {
        DataResult dataResult;
        class_2509 nbtOps = class_2509.field_11560;
        if (CodecUtil.client.field_1687 != null) {
            nbtOps = CodecUtil.client.field_1687.method_30349().method_57093((DynamicOps)nbtOps);
        }
        if ((dataResult = codec.encodeStart((DynamicOps)nbtOps, component)).isSuccess()) {
            return (class_2520)dataResult.getOrThrow();
        }
        VariantsCitMod.LOGGER.error("Unable to serialize component: {}", ((DataResult.Error)dataResult.error().get()).message());
        return null;
    }

    public static Map<class_2960, class_3298> GetResources(class_3300 manager, String directory, String suffix) {
        HashMap<class_2960, class_3298> result = new HashMap<class_2960, class_3298>();
        Map resources = manager.method_14488(directory, id -> id.method_12832().endsWith(suffix));
        for (Map.Entry e : resources.entrySet()) {
            result.put(CodecUtil.AssetIdFromResourceId((class_2960)e.getKey(), directory, suffix), (class_3298)e.getValue());
        }
        return result;
    }

    public static class_2960 AssetIdFromResourceId(class_2960 id, String directory, String suffix) {
        return id.method_45134(path -> path.substring(directory.length() + 1, path.length() - suffix.length()));
    }

    public static <T> DataResult<T> ParseResource(class_3298 resource, MapCodec<T> codec) {
        return CodecUtil.ParseResource(resource, codec.codec());
    }

    public static <T> DataResult<T> ParseResource(class_3298 resource, Codec<T> codec) {
        JsonElement json;
        try {
            json = JsonParser.parseReader((Reader)resource.method_43039());
        }
        catch (JsonParseException | IOException e) {
            return DataResult.error(((Exception)e)::toString);
        }
        return codec.decode((DynamicOps)JsonOps.INSTANCE, (Object)json).map(Pair::getFirst);
    }

    public static <T> Map<class_2960, T> ReloadResources(class_3300 manager, Codec<T> codec, String directory, String suffix) {
        HashMap<class_2960, Object> results = new HashMap<class_2960, Object>();
        Map<class_2960, class_3298> resources = CodecUtil.GetResources(manager, directory, suffix);
        for (Map.Entry<class_2960, class_3298> entry : resources.entrySet()) {
            class_2960 id = entry.getKey();
            DataResult<T> result = CodecUtil.ParseResource(entry.getValue(), codec);
            if (result.isSuccess()) {
                results.put(id, result.getOrThrow());
                continue;
            }
            VariantsCitMod.LOGGER.error("Error loading resource {}:\n{}", entry.getKey(), ((DataResult.Error)result.error().get()).message());
        }
        return results;
    }
}

