/*
 * Decompiled with CFR 0.152.
 */
package de.guntram.mcmod.durabilityviewer.client.gui;

import fi.dy.masa.malilib.config.IConfigOptionListEntry;
import fi.dy.masa.malilib.util.StringUtils;

public enum Corner implements IConfigOptionListEntry
{
    BOTTOM_RIGHT("Bottom-Right", "durabilityviewer.config.bottom_right"),
    BOTTOM_LEFT("Bottom-Left", "durabilityviewer.config.bottom_left"),
    TOP_RIGHT("Top-Right", "durabilityviewer.config.top_right"),
    TOP_LEFT("Top-Left", "durabilityviewer.config.top_left");

    private final String configString;
    private final String translationKey;

    public boolean isLeft() {
        return this == TOP_LEFT || this == BOTTOM_LEFT;
    }

    public boolean isRight() {
        return this == TOP_RIGHT || this == BOTTOM_RIGHT;
    }

    public boolean isTop() {
        return this == TOP_LEFT || this == TOP_RIGHT;
    }

    public boolean isBottom() {
        return this == BOTTOM_LEFT || this == BOTTOM_RIGHT;
    }

    private Corner(String configString, String translationKey) {
        this.configString = configString;
        this.translationKey = translationKey;
    }

    public String getStringValue() {
        return this.configString;
    }

    public String getDisplayName() {
        return StringUtils.translate((String)this.translationKey, (Object[])new Object[0]);
    }

    public IConfigOptionListEntry cycle(boolean forward) {
        int id = this.ordinal();
        if (forward) {
            if (++id >= Corner.values().length) {
                id = 0;
            }
        } else if (--id < 0) {
            id = Corner.values().length - 1;
        }
        return Corner.values()[id % Corner.values().length];
    }

    public Corner fromString(String name) {
        return Corner.fromStringStatic(name);
    }

    public static Corner fromStringStatic(String name) {
        for (Corner mode : Corner.values()) {
            if (!mode.configString.equalsIgnoreCase(name)) continue;
            return mode;
        }
        return BOTTOM_RIGHT;
    }
}

