/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.function.Consumer;
import net.caffeinemc.mods.sodium.client.SodiumClientMod;
import net.caffeinemc.mods.sodium.client.gl.device.CommandList;
import net.caffeinemc.mods.sodium.client.gl.device.RenderDevice;
import net.caffeinemc.mods.sodium.client.render.chunk.ChunkRenderMatrices;
import net.caffeinemc.mods.sodium.client.render.chunk.RenderSection;
import net.caffeinemc.mods.sodium.client.render.chunk.RenderSectionManager;
import net.caffeinemc.mods.sodium.client.render.chunk.lists.ChunkRenderList;
import net.caffeinemc.mods.sodium.client.render.chunk.lists.SortedRenderLists;
import net.caffeinemc.mods.sodium.client.render.chunk.map.ChunkTracker;
import net.caffeinemc.mods.sodium.client.render.chunk.map.ChunkTrackerHolder;
import net.caffeinemc.mods.sodium.client.render.chunk.region.RenderRegion;
import net.caffeinemc.mods.sodium.client.render.chunk.terrain.DefaultTerrainRenderPasses;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.SortBehavior;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.trigger.CameraMovement;
import net.caffeinemc.mods.sodium.client.render.viewport.Viewport;
import net.caffeinemc.mods.sodium.client.services.PlatformRuntimeInformation;
import net.caffeinemc.mods.sodium.client.util.FogParameters;
import net.caffeinemc.mods.sodium.client.util.NativeBuffer;
import net.caffeinemc.mods.sodium.client.util.iterator.ByteIterator;
import net.caffeinemc.mods.sodium.client.world.LevelRendererExtension;
import net.caffeinemc.mods.sodium.mixin.core.render.world.EntityRendererAccessor;
import net.minecraft.class_10017;
import net.minecraft.class_10209;
import net.minecraft.class_11531;
import net.minecraft.class_11658;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_3191;
import net.minecraft.class_3532;
import net.minecraft.class_3695;
import net.minecraft.class_4076;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_761;
import net.minecraft.class_897;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class SodiumWorldRenderer {
    private final class_310 client;
    private class_638 level;
    private int renderDistance;
    private Vector3d lastCameraPos;
    private double lastCameraPitch;
    private double lastCameraYaw;
    private FogParameters lastFogParameters = FogParameters.NONE;
    private Matrix4f lastProjectionMatrix;
    private boolean useEntityCulling;
    private RenderSectionManager renderSectionManager;
    private static final double MAX_ENTITY_CHECK_VOLUME = 61440.0;

    public static SodiumWorldRenderer instance() {
        SodiumWorldRenderer instance = SodiumWorldRenderer.instanceNullable();
        if (instance == null) {
            throw new IllegalStateException("No renderer attached to active level");
        }
        return instance;
    }

    public static SodiumWorldRenderer instanceNullable() {
        class_761 level = class_310.method_1551().field_1769;
        if (level instanceof LevelRendererExtension) {
            LevelRendererExtension extension = (LevelRendererExtension)level;
            return extension.sodium$getWorldRenderer();
        }
        return null;
    }

    public SodiumWorldRenderer(class_310 client) {
        this.client = client;
    }

    public void setLevel(class_638 level) {
        if (this.level == level) {
            return;
        }
        if (this.level != null) {
            this.unloadLevel();
        }
        if (level != null) {
            this.loadLevel(level);
        }
    }

    private void loadLevel(class_638 level) {
        this.level = level;
        try (CommandList commandList = RenderDevice.INSTANCE.createCommandList();){
            this.initRenderer(commandList);
        }
    }

    private void unloadLevel() {
        if (this.renderSectionManager != null) {
            this.renderSectionManager.destroy();
            this.renderSectionManager = null;
        }
        this.level = null;
    }

    public int getVisibleChunkCount() {
        return this.renderSectionManager.getVisibleChunkCount();
    }

    public void scheduleTerrainUpdate() {
        if (this.renderSectionManager != null) {
            this.renderSectionManager.markGraphDirty();
        }
    }

    public boolean isTerrainRenderComplete() {
        return this.renderSectionManager.getBuilder().isBuildQueueEmpty();
    }

    public void setupTerrain(class_4184 camera, Viewport viewport, FogParameters fogParameters, boolean spectator, boolean updateChunksImmediately, ChunkRenderMatrices matrices) {
        NativeBuffer.reclaim(false);
        this.processChunkEvents();
        this.useEntityCulling = SodiumClientMod.options().performance.useEntityCulling;
        if (this.client.field_1690.method_38521() != this.renderDistance) {
            this.reload();
        }
        class_3695 profiler = class_10209.method_64146();
        profiler.method_15396("camera_setup");
        class_746 player = this.client.field_1724;
        if (player == null) {
            throw new IllegalStateException("Client instance has no active player entity");
        }
        class_243 posRaw = camera.method_19326();
        Vector3d pos = new Vector3d(posRaw.method_10216(), posRaw.method_10214(), posRaw.method_10215());
        float pitch = camera.method_19329();
        float yaw = camera.method_19330();
        if (this.lastCameraPos == null) {
            this.lastCameraPos = pos;
        }
        if (this.lastProjectionMatrix == null) {
            this.lastProjectionMatrix = new Matrix4f(matrices.projection());
        }
        boolean cameraLocationChanged = !pos.equals((Object)this.lastCameraPos);
        boolean fogDistanceChanged = fogParameters.renderEnd() != this.lastFogParameters.renderEnd();
        boolean cameraAngleChanged = (double)pitch != this.lastCameraPitch || (double)yaw != this.lastCameraYaw;
        boolean cameraProjectionChanged = !matrices.projection().equals((Matrix4fc)this.lastProjectionMatrix, 1.0E-4f);
        this.lastProjectionMatrix.set(matrices.projection());
        this.lastCameraPitch = pitch;
        this.lastCameraYaw = yaw;
        if (cameraLocationChanged || fogDistanceChanged || cameraAngleChanged || cameraProjectionChanged) {
            this.renderSectionManager.markGraphDirty();
        }
        this.lastFogParameters = fogParameters;
        this.renderSectionManager.prepareFrame((Vector3dc)pos);
        if (cameraLocationChanged) {
            profiler.method_15405("translucent_triggering");
            this.renderSectionManager.processGFNIMovement(new CameraMovement((Vector3dc)this.lastCameraPos, (Vector3dc)pos));
            this.lastCameraPos = pos;
        }
        int maxChunkUpdates = updateChunksImmediately ? this.renderDistance : 1;
        for (int i = 0; i < maxChunkUpdates; ++i) {
            if (this.renderSectionManager.needsUpdate()) {
                profiler.method_15405("chunk_render_lists");
                this.renderSectionManager.update(camera, viewport, fogParameters, spectator);
            }
            profiler.method_15405("chunk_update");
            this.renderSectionManager.cleanupAndFlip();
            this.renderSectionManager.updateChunks(updateChunksImmediately);
            profiler.method_15405("chunk_upload");
            this.renderSectionManager.uploadChunks();
            if (!this.renderSectionManager.needsUpdate()) break;
        }
        profiler.method_15405("chunk_render_lists");
        this.renderSectionManager.finalizeRenderLists(viewport);
        profiler.method_15405("chunk_render_tick");
        this.renderSectionManager.tickVisibleRenders();
        profiler.method_15407();
        class_1297.method_5840((double)(class_3532.method_15350((double)((double)this.client.field_1690.method_38521() / 8.0), (double)1.0, (double)2.5) * (Double)this.client.field_1690.method_42517().method_41753()));
    }

    private void processChunkEvents() {
        this.renderSectionManager.beforeSectionUpdates();
        ChunkTracker tracker = ChunkTrackerHolder.get(this.level);
        tracker.forEachEvent(this.renderSectionManager::onChunkAdded, this.renderSectionManager::onChunkRemoved);
    }

    public void drawChunkLayer(class_11531 group, ChunkRenderMatrices matrices, double x, double y, double z) {
        if (group == class_11531.field_61022) {
            this.renderSectionManager.renderLayer(matrices, DefaultTerrainRenderPasses.SOLID, x, y, z, this.lastFogParameters);
            this.renderSectionManager.renderLayer(matrices, DefaultTerrainRenderPasses.CUTOUT, x, y, z, this.lastFogParameters);
        } else if (group == class_11531.field_61023) {
            this.renderSectionManager.renderLayer(matrices, DefaultTerrainRenderPasses.TRANSLUCENT, x, y, z, this.lastFogParameters);
        }
    }

    public void reload() {
        if (this.level == null) {
            return;
        }
        try (CommandList commandList = RenderDevice.INSTANCE.createCommandList();){
            this.initRenderer(commandList);
        }
    }

    private void initRenderer(CommandList commandList) {
        if (this.renderSectionManager != null) {
            this.renderSectionManager.destroy();
            this.renderSectionManager = null;
        }
        SortBehavior sortBehavior = SortBehavior.DYNAMIC_DEFER_NEARBY_ZERO_FRAMES;
        if (PlatformRuntimeInformation.getInstance().isDevelopmentEnvironment() && !SodiumClientMod.options().debug.terrainSortingEnabled) {
            sortBehavior = SortBehavior.OFF;
        }
        this.renderDistance = this.client.field_1690.method_38521();
        this.renderSectionManager = new RenderSectionManager(this.level, this.renderDistance, sortBehavior, commandList);
        ChunkTracker tracker = ChunkTrackerHolder.get(this.level);
        ChunkTracker.forEachChunk(tracker.getReadyChunks(), this.renderSectionManager::onChunkAdded);
    }

    public void extractBlockEntities(class_4184 camera, float tickDelta, Long2ObjectMap<SortedSet<class_3191>> progression, class_11658 levelRenderState) {
        class_4587 stack = new class_4587();
        SortedRenderLists renderLists = this.renderSectionManager.getRenderLists();
        Iterator<ChunkRenderList> renderListIterator = renderLists.iterator();
        while (renderListIterator.hasNext()) {
            ChunkRenderList renderList = renderListIterator.next();
            RenderRegion renderRegion = renderList.getRegion();
            ByteIterator renderSectionIterator = renderList.sectionsWithEntitiesIterator();
            if (renderSectionIterator == null) continue;
            while (renderSectionIterator.hasNext()) {
                int renderSectionId = renderSectionIterator.nextByteAsInt();
                RenderSection renderSection = renderRegion.getSection(renderSectionId);
                class_2586[] blockEntities = renderSection.getCulledBlockEntities();
                if (blockEntities == null) continue;
                for (class_2586 blockEntity : blockEntities) {
                    this.extractBlockEntity(blockEntity, stack, camera, tickDelta, progression, levelRenderState);
                }
            }
        }
        for (RenderSection renderSection : this.renderSectionManager.getSectionsWithGlobalEntities()) {
            class_2586[] blockEntities = renderSection.getGlobalBlockEntities();
            if (blockEntities == null) continue;
            for (class_2586 blockEntity : blockEntities) {
                this.extractBlockEntity(blockEntity, stack, camera, tickDelta, progression, levelRenderState);
            }
        }
    }

    private void extractBlockEntity(class_2586 blockEntity, class_4587 poseStack, class_4184 camera, float tickDelta, Long2ObjectMap<SortedSet<class_3191>> progression, class_11658 levelRenderState) {
        class_11683.class_11792 crumblingOverlay;
        class_2338 blockPos = blockEntity.method_11016();
        SortedSet sortedSet = (SortedSet)progression.get(blockPos.method_10063());
        if (sortedSet != null && !sortedSet.isEmpty()) {
            poseStack.method_22903();
            poseStack.method_22904((double)blockPos.method_10263() - camera.method_71156().field_1352, (double)blockPos.method_10264() - camera.method_71156().field_1351, (double)blockPos.method_10260() - camera.method_71156().field_1350);
            crumblingOverlay = new class_11683.class_11792(((class_3191)sortedSet.last()).method_13988(), poseStack.method_23760());
            poseStack.method_22909();
        } else {
            crumblingOverlay = null;
        }
        class_11954 blockEntityRenderState = class_310.method_1551().method_31975().method_74348(blockEntity, tickDelta, crumblingOverlay);
        if (blockEntityRenderState != null) {
            levelRenderState.field_62646.add(blockEntityRenderState);
        }
    }

    public void iterateVisibleBlockEntities(Consumer<class_2586> blockEntityConsumer) {
        SortedRenderLists renderLists = this.renderSectionManager.getRenderLists();
        Iterator<ChunkRenderList> renderListIterator = renderLists.iterator();
        while (renderListIterator.hasNext()) {
            ChunkRenderList renderList = renderListIterator.next();
            RenderRegion renderRegion = renderList.getRegion();
            ByteIterator renderSectionIterator = renderList.sectionsWithEntitiesIterator();
            if (renderSectionIterator == null) continue;
            while (renderSectionIterator.hasNext()) {
                int renderSectionId = renderSectionIterator.nextByteAsInt();
                RenderSection renderSection = renderRegion.getSection(renderSectionId);
                class_2586[] blockEntities = renderSection.getCulledBlockEntities();
                if (blockEntities == null) continue;
                for (class_2586 blockEntity : blockEntities) {
                    blockEntityConsumer.accept(blockEntity);
                }
            }
        }
        for (RenderSection renderSection : this.renderSectionManager.getSectionsWithGlobalEntities()) {
            class_2586[] blockEntities = renderSection.getGlobalBlockEntities();
            if (blockEntities == null) continue;
            for (class_2586 blockEntity : blockEntities) {
                blockEntityConsumer.accept(blockEntity);
            }
        }
    }

    public <T extends class_1297, S extends class_10017> boolean isEntityVisible(class_897<T, S> renderer, T entity) {
        if (!this.useEntityCulling) {
            return true;
        }
        if (this.client.method_27022(entity) || entity.method_5733()) {
            return true;
        }
        class_238 bb = ((EntityRendererAccessor)renderer).getCullingBox(entity);
        double entityVolume = (bb.field_1320 - bb.field_1323) * (bb.field_1325 - bb.field_1322) * (bb.field_1324 - bb.field_1321);
        if (entityVolume > 61440.0) {
            return true;
        }
        return this.isBoxVisible(bb.field_1323, bb.field_1322, bb.field_1321, bb.field_1320, bb.field_1325, bb.field_1324);
    }

    public boolean isBoxVisible(double x1, double y1, double z1, double x2, double y2, double z2) {
        if (y2 < (double)this.level.method_31607() + 0.5 || y1 > (double)this.level.method_31600() - 0.5) {
            return true;
        }
        int minX = class_4076.method_32204((double)(x1 - 0.5));
        int minY = class_4076.method_32204((double)(y1 - 0.5));
        int minZ = class_4076.method_32204((double)(z1 - 0.5));
        int maxX = class_4076.method_32204((double)(x2 + 0.5));
        int maxY = class_4076.method_32204((double)(y2 + 0.5));
        int maxZ = class_4076.method_32204((double)(z2 + 0.5));
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                for (int y = minY; y <= maxY; ++y) {
                    if (!this.renderSectionManager.isSectionVisible(x, y, z)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Nullable
    public String getChunksDebugString() {
        if (this.renderSectionManager == null) {
            return null;
        }
        return String.format("C: %d/%d D: %d", this.renderSectionManager.getVisibleChunkCount(), this.renderSectionManager.getTotalSections(), this.renderDistance);
    }

    public void scheduleRebuildForBlockArea(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, boolean important) {
        this.scheduleRebuildForChunks(minX >> 4, minY >> 4, minZ >> 4, maxX >> 4, maxY >> 4, maxZ >> 4, important);
    }

    public void scheduleRebuildForChunks(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, boolean important) {
        for (int chunkX = minX; chunkX <= maxX; ++chunkX) {
            for (int chunkY = minY; chunkY <= maxY; ++chunkY) {
                for (int chunkZ = minZ; chunkZ <= maxZ; ++chunkZ) {
                    this.scheduleRebuildForChunk(chunkX, chunkY, chunkZ, important);
                }
            }
        }
    }

    public void scheduleRebuildForChunk(int x, int y, int z, boolean important) {
        this.renderSectionManager.scheduleRebuild(x, y, z, important);
    }

    public Collection<String> getDebugStrings() {
        return this.renderSectionManager == null ? Collections.emptyList() : this.renderSectionManager.getDebugStrings();
    }

    public boolean isSectionReady(int x, int y, int z) {
        return this.renderSectionManager.isSectionBuilt(x, y, z);
    }
}

