/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.systems.RenderSystem;
import fi.dy.masa.malilib.util.JsonUtils;
import fi.dy.masa.malilib.util.position.PositionUtils;
import fi.dy.masa.minihud.renderer.IOverlayRenderer;
import fi.dy.masa.minihud.renderer.OverlayRendererBase;
import fi.dy.masa.minihud.renderer.OverlayRendererBeaconRange;
import fi.dy.masa.minihud.renderer.OverlayRendererBiomeBorders;
import fi.dy.masa.minihud.renderer.OverlayRendererBlockGrid;
import fi.dy.masa.minihud.renderer.OverlayRendererConduitRange;
import fi.dy.masa.minihud.renderer.OverlayRendererHandheldBeaconRange;
import fi.dy.masa.minihud.renderer.OverlayRendererLightLevel;
import fi.dy.masa.minihud.renderer.OverlayRendererRandomTickableChunks;
import fi.dy.masa.minihud.renderer.OverlayRendererRegion;
import fi.dy.masa.minihud.renderer.OverlayRendererSlimeChunks;
import fi.dy.masa.minihud.renderer.OverlayRendererSpawnChunks;
import fi.dy.masa.minihud.renderer.OverlayRendererSpawnableColumnHeights;
import fi.dy.masa.minihud.renderer.OverlayRendererStructures;
import fi.dy.masa.minihud.renderer.OverlayRendererVillagerInfo;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3695;
import net.minecraft.class_4184;
import net.minecraft.class_4604;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;

public class RenderContainer {
    public static final RenderContainer INSTANCE = new RenderContainer();
    private final List<OverlayRendererBase> renderers = new ArrayList<OverlayRendererBase>();
    protected int countActive;

    private RenderContainer() {
        this.addRenderer(OverlayRendererBeaconRange.INSTANCE);
        this.addRenderer(OverlayRendererBiomeBorders.INSTANCE);
        this.addRenderer(OverlayRendererBlockGrid.INSTANCE);
        this.addRenderer(OverlayRendererConduitRange.INSTANCE);
        this.addRenderer(OverlayRendererLightLevel.INSTANCE);
        this.addRenderer(OverlayRendererHandheldBeaconRange.INSTANCE);
        this.addRenderer(OverlayRendererRandomTickableChunks.INSTANCE_FIXED);
        this.addRenderer(OverlayRendererRandomTickableChunks.INSTANCE_PLAYER);
        this.addRenderer(OverlayRendererRegion.INSTANCE);
        this.addRenderer(OverlayRendererSlimeChunks.INSTANCE);
        this.addRenderer(OverlayRendererSpawnableColumnHeights.INSTANCE);
        this.addRenderer(OverlayRendererSpawnChunks.INSTANCE_PLAYER);
        this.addRenderer(OverlayRendererSpawnChunks.INSTANCE_REAL);
        this.addRenderer(OverlayRendererStructures.INSTANCE);
        this.addRenderer(OverlayRendererVillagerInfo.INSTANCE);
    }

    public void addRenderer(OverlayRendererBase renderer) {
        this.renderers.add(renderer);
    }

    public void removeRenderer(OverlayRendererBase renderer) {
        this.renderers.remove(renderer);
    }

    public void render(class_1297 entity, Matrix4f posMatrix, Matrix4f projMatrix, class_310 mc, class_4184 camera, class_4604 frustum, class_3695 profiler) {
        profiler.method_15396("render_container");
        this.update(camera.method_19326(), entity, mc, profiler);
        this.draw(camera.method_19326(), profiler);
        profiler.method_15407();
    }

    protected void update(class_243 cameraPos, class_1297 entity, class_310 mc, class_3695 profiler) {
        profiler.method_15405("render_update");
        this.countActive = 0;
        for (OverlayRendererBase renderer : this.renderers) {
            profiler.method_15396("update_" + renderer.getName());
            if (renderer.shouldRender(mc)) {
                if (renderer.needsUpdate(entity, mc)) {
                    renderer.lastUpdatePos = PositionUtils.getEntityBlockPos((class_1297)entity);
                    renderer.update(cameraPos, entity, mc, profiler);
                    renderer.setUpdatePosition(cameraPos);
                }
                ++this.countActive;
            } else {
                renderer.reset();
            }
            profiler.method_15407();
        }
    }

    protected void draw(class_243 cameraPos, class_3695 profiler) {
        profiler.method_15405("render_draw");
        if (this.countActive > 0) {
            Matrix4fStack matrix4fstack = RenderSystem.getModelViewStack();
            for (IOverlayRenderer iOverlayRenderer : this.renderers) {
                profiler.method_15396("draw_" + iOverlayRenderer.getName());
                if (iOverlayRenderer.hasData()) {
                    class_243 updatePos = iOverlayRenderer.getUpdatePosition();
                    matrix4fstack.pushMatrix();
                    matrix4fstack.translate((float)(updatePos.field_1352 - cameraPos.field_1352), (float)(updatePos.field_1351 - cameraPos.field_1351), (float)(updatePos.field_1350 - cameraPos.field_1350));
                    iOverlayRenderer.draw(cameraPos);
                    matrix4fstack.popMatrix();
                } else {
                    iOverlayRenderer.reset();
                }
                profiler.method_15407();
            }
        }
    }

    protected void reset() {
        for (OverlayRendererBase renderer : this.renderers) {
            renderer.reset();
        }
    }

    public JsonObject toJson() {
        JsonObject obj = new JsonObject();
        for (OverlayRendererBase renderer : this.renderers) {
            String id = renderer.getSaveId();
            if (id.isEmpty()) continue;
            obj.add(id, (JsonElement)renderer.toJson());
        }
        return obj;
    }

    public void fromJson(JsonObject obj) {
        for (OverlayRendererBase renderer : this.renderers) {
            String id = renderer.getSaveId();
            if (id.isEmpty() || !JsonUtils.hasObject((JsonObject)obj, (String)id)) continue;
            renderer.fromJson(obj.get(id).getAsJsonObject());
        }
    }
}

