/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.config;

import fi.dy.masa.malilib.config.IConfigBoolean;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.util.EntityUtils;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.minihud.data.HudDataManager;
import fi.dy.masa.minihud.renderer.OverlayRendererBeaconRange;
import fi.dy.masa.minihud.renderer.OverlayRendererBiomeBorders;
import fi.dy.masa.minihud.renderer.OverlayRendererConduitRange;
import fi.dy.masa.minihud.renderer.OverlayRendererLightLevel;
import fi.dy.masa.minihud.renderer.OverlayRendererRandomTickableChunks;
import fi.dy.masa.minihud.renderer.OverlayRendererRegion;
import fi.dy.masa.minihud.renderer.OverlayRendererSlimeChunks;
import fi.dy.masa.minihud.renderer.OverlayRendererSpawnChunks;
import fi.dy.masa.minihud.renderer.shapes.ShapeManager;
import fi.dy.masa.minihud.util.DataStorage;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4208;

public class RendererCallbacks {
    public static void onBeaconRangeToggled(IConfigBoolean config) {
        if (config.getBooleanValue()) {
            OverlayRendererBeaconRange.INSTANCE.reset();
            OverlayRendererBeaconRange.INSTANCE.setNeedsUpdate();
        }
    }

    public static void onBiomeBorderToggled(IConfigBoolean config) {
        if (config.getBooleanValue()) {
            OverlayRendererBiomeBorders.INSTANCE.reset();
            OverlayRendererBiomeBorders.INSTANCE.setNeedsUpdate();
        }
    }

    public static void onConduitRangeToggled(IConfigBoolean config) {
        if (config.getBooleanValue()) {
            OverlayRendererBeaconRange.INSTANCE.reset();
            OverlayRendererConduitRange.INSTANCE.setNeedsUpdate();
        }
    }

    public static void onLightLevelToggled(IConfigBoolean config) {
        if (config.getBooleanValue()) {
            OverlayRendererLightLevel.INSTANCE.reset();
            OverlayRendererLightLevel.INSTANCE.setNeedsUpdate();
        }
    }

    public static void onRandomTicksFixedToggled(IConfigBoolean config) {
        class_1297 entity = EntityUtils.getCameraEntity();
        if (config.getBooleanValue() && entity != null) {
            class_243 pos = entity.method_73189();
            OverlayRendererRandomTickableChunks.INSTANCE_FIXED.setNewPos(pos);
            String green = GuiBase.TXT_GREEN;
            String rst = GuiBase.TXT_RST;
            String strStatus = green + StringUtils.translate((String)"malilib.message.value.on", (Object[])new Object[0]) + rst;
            String strPos = String.format("x: %.2f, y: %.2f, z: %.2f", pos.field_1352, pos.field_1351, pos.field_1350);
            String message = StringUtils.translate((String)"minihud.message.toggled_using_position", (Object[])new Object[]{config.getPrettyName(), strStatus, strPos});
            InfoUtils.printActionbarMessage((String)message, (Object[])new Object[0]);
        }
    }

    public static void onRandomTicksPlayerToggled(IConfigBoolean config) {
        if (config.getBooleanValue()) {
            OverlayRendererRandomTickableChunks.INSTANCE_PLAYER.setNeedsUpdate();
        }
    }

    public static void onRegionFileToggled(IConfigBoolean config) {
        if (config.getBooleanValue()) {
            OverlayRendererRegion.INSTANCE.setNeedsUpdate();
        }
    }

    public static void onSlimeChunksToggled(IConfigBoolean config) {
        if (config.getBooleanValue()) {
            OverlayRendererSlimeChunks.INSTANCE.setNeedsUpdate();
            OverlayRendererSlimeChunks.INSTANCE.onEnabled();
        }
    }

    public static void onSpawnChunksPlayerToggled(IConfigBoolean config) {
        if (config.getBooleanValue()) {
            String green = GuiBase.TXT_GREEN;
            String rst = GuiBase.TXT_RST;
            String strStatus = green + StringUtils.translate((String)"malilib.message.value.on", (Object[])new Object[0]) + rst;
            String strDist = String.format("%d", DataStorage.getInstance().getSimulationDistance());
            String message = StringUtils.translate((String)"minihud.message.toggled_using_player_spawn", (Object[])new Object[]{config.getPrettyName(), strStatus, strDist});
            InfoUtils.printActionbarMessage((String)message, (Object[])new Object[0]);
            OverlayRendererSpawnChunks.INSTANCE_PLAYER.setNeedsUpdate();
        }
    }

    public static void onSpawnChunksRealToggled(IConfigBoolean config) {
        class_310 mc = class_310.method_1551();
        if (mc != null && mc.field_1724 != null && config.getBooleanValue()) {
            String message;
            class_4208 spawn = HudDataManager.getInstance().getWorldSpawn();
            int radius = HudDataManager.getInstance().getSpawnChunkRadius();
            String green = GuiBase.TXT_GREEN;
            String rst = GuiBase.TXT_RST;
            if (radius > 0) {
                String strStatus = green + StringUtils.translate((String)"malilib.message.value.on", (Object[])new Object[0]) + rst;
                String strPos = String.format("x: %d, y: %d, z: %d [R: %d]", spawn.comp_2208().method_10263(), spawn.comp_2208().method_10264(), spawn.comp_2208().method_10260(), radius);
                message = StringUtils.translate((String)"minihud.message.toggled_using_world_spawn", (Object[])new Object[]{config.getPrettyName(), strStatus, strPos});
                if (!mc.method_1496() && HudDataManager.getInstance().hasServuxServer()) {
                    HudDataManager.getInstance().requestSpawnMetadata();
                } else {
                    OverlayRendererSpawnChunks.INSTANCE_REAL.setNeedsUpdate();
                }
            } else {
                OverlayRendererSpawnChunks.INSTANCE_REAL.setNeedsUpdate();
                String strStatus = green + StringUtils.translate((String)"malilib.message.value.on", (Object[])new Object[0]) + rst;
                String strPos = String.format("[%s] x: %d, y: %d, z: %d", spawn.comp_2207().method_29177().toString(), spawn.comp_2208().method_10263(), spawn.comp_2208().method_10264(), spawn.comp_2208().method_10260());
                message = StringUtils.translate((String)"minihud.message.toggled_using_world_spawn", (Object[])new Object[]{config.getPrettyName(), strStatus, strPos});
            }
            InfoUtils.printActionbarMessage((String)message, (Object[])new Object[0]);
        }
    }

    public static void onStructuresToggled(IConfigBoolean config) {
        class_310 mc = class_310.method_1551();
        if (mc != null && mc.field_1724 != null) {
            if (!mc.method_1496() && !DataStorage.getInstance().hasIntegratedServer()) {
                if (config.getBooleanValue()) {
                    DataStorage.getInstance().registerStructureChannel();
                } else {
                    DataStorage.getInstance().unregisterStructureChannel();
                }
            } else {
                DataStorage.getInstance().setStructuresNeedUpdating();
            }
        }
    }

    public static void onShapeRendererToggled(IConfigBoolean config) {
        if (config.getBooleanValue()) {
            ShapeManager.INSTANCE.setAllNeedsUpdate();
        }
    }
}

