/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.audio.capture;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_310;
import net.minecraft.class_408;
import net.minecraft.class_437;
import net.minecraft.class_498;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.config.Config;
import su.plo.config.entry.BooleanConfigEntry;
import su.plo.config.entry.ConfigEntry;
import su.plo.config.entry.IntConfigEntry;
import su.plo.lib.mod.client.chat.ClientChatUtil;
import su.plo.slib.api.chat.component.McTextComponent;
import su.plo.voice.api.audio.codec.AudioEncoder;
import su.plo.voice.api.client.PlasmoVoiceClient;
import su.plo.voice.api.client.audio.capture.ClientActivation;
import su.plo.voice.api.client.config.hotkey.Hotkey;
import su.plo.voice.api.client.connection.ServerInfo;
import su.plo.voice.api.util.AudioUtil;
import su.plo.voice.client.config.VoiceClientConfig;
import su.plo.voice.client.config.capture.ConfigClientActivation;
import su.plo.voice.client.config.hotkey.ConfigHotkeys;
import su.plo.voice.client.config.hotkey.HotkeyConfigEntry;
import su.plo.voice.proto.data.audio.capture.Activation;
import su.plo.voice.proto.data.audio.capture.CaptureInfo;
import su.plo.voice.proto.data.audio.capture.VoiceActivation;
import su.plo.voice.proto.packets.tcp.serverbound.PlayerActivationDistancesPacket;

@Config
public final class VoiceClientActivation
extends VoiceActivation
implements ClientActivation {
    private final PlasmoVoiceClient voiceClient;
    private final VoiceClientConfig config;
    private final IntConfigEntry configDistance;
    private final ConfigEntry<ClientActivation.Type> configType;
    private final BooleanConfigEntry configToggle;
    private final HotkeyConfigEntry pttKey;
    private final HotkeyConfigEntry toggleKey;
    private final HotkeyConfigEntry distanceIncreaseKey;
    private final HotkeyConfigEntry distanceDecreaseKey;
    private final AtomicBoolean disabled = new AtomicBoolean(false);
    private boolean active;
    private long lastActivation;
    @Nullable
    private AudioEncoder monoEncoder;
    @Nullable
    private AudioEncoder stereoEncoder;

    public VoiceClientActivation(@NotNull PlasmoVoiceClient voiceClient, @NotNull VoiceClientConfig config, @NotNull ConfigClientActivation activationConfig, @NotNull IntConfigEntry activationDistance, @NotNull Activation activation, @NotNull String icon) {
        super(activation.getName(), activation.getTranslation(), icon, new ArrayList<Integer>(activation.getDistances()), activation.getDefaultDistance(), activation.isProximity(), activation.isStereoSupported(), activation.isTransitive(), activation.getEncoderInfo().orElse(null), activation.getWeight());
        this.voiceClient = voiceClient;
        this.config = config;
        ConfigHotkeys hotKeys = config.getKeyBindings();
        this.configDistance = activationDistance;
        this.configType = activationConfig.getConfigType();
        this.configToggle = activationConfig.getConfigToggle();
        this.pttKey = this.createHotKey(hotKeys, activation, "ptt", true);
        this.toggleKey = this.createHotKey(hotKeys, activation, "toggle", false);
        this.distanceIncreaseKey = this.createHotKey(hotKeys, activation, "distance_increase", false);
        this.distanceDecreaseKey = this.createHotKey(hotKeys, activation, "distance_decrease", false);
        ((Hotkey)this.toggleKey.value()).clearPressListener();
        ((Hotkey)this.toggleKey.value()).addPressListener(this::onToggle);
        ((Hotkey)this.distanceIncreaseKey.value()).clearPressListener();
        ((Hotkey)this.distanceIncreaseKey.value()).addPressListener(this::onDistanceIncrease);
        ((Hotkey)this.distanceDecreaseKey.value()).clearPressListener();
        ((Hotkey)this.distanceDecreaseKey.value()).addPressListener(this::onDistanceDecrease);
        this.configDistance.clearChangeListeners();
        this.configDistance.addChangeListener(this::onDistanceChange);
        if (this.encoderInfo != null) {
            CaptureInfo captureInfo = voiceClient.getServerInfo().map(ServerInfo::getVoiceInfo).map(ServerInfo.VoiceInfo::getCaptureInfo).orElseThrow(() -> new IllegalStateException("not connected to voice server"));
            this.monoEncoder = voiceClient.getCodecManager().createEncoder(this.encoderInfo, captureInfo.getSampleRate(), false, captureInfo.getMtuSize());
            this.stereoEncoder = voiceClient.getCodecManager().createEncoder(this.encoderInfo, captureInfo.getSampleRate(), true, captureInfo.getMtuSize());
        }
    }

    @Override
    @NotNull
    public ClientActivation.Type getType() {
        return this.configType.value();
    }

    @Override
    @NotNull
    public Hotkey getPttKey() {
        return (Hotkey)this.pttKey.value();
    }

    public HotkeyConfigEntry getPttConfigEntry() {
        return this.pttKey;
    }

    @Override
    @NotNull
    public Hotkey getToggleKey() {
        return (Hotkey)this.toggleKey.value();
    }

    @Override
    @NotNull
    public Hotkey getDistanceIncreaseKey() {
        return (Hotkey)this.distanceIncreaseKey.value();
    }

    public HotkeyConfigEntry getDistanceIncreaseConfigEntry() {
        return this.distanceIncreaseKey;
    }

    @Override
    @NotNull
    public Hotkey getDistanceDecreaseKey() {
        return (Hotkey)this.distanceDecreaseKey.value();
    }

    @Override
    public Optional<AudioEncoder> getMonoEncoder() {
        return Optional.ofNullable(this.monoEncoder);
    }

    @Override
    public Optional<AudioEncoder> getStereoEncoder() {
        return Optional.ofNullable(this.stereoEncoder);
    }

    public HotkeyConfigEntry getDistanceDecreaseConfigEntry() {
        return this.distanceDecreaseKey;
    }

    public HotkeyConfigEntry getToggleConfigEntry() {
        return this.toggleKey;
    }

    @Override
    public void setDisabled(boolean disabled) {
        this.disabled.set(disabled);
    }

    @Override
    public boolean isDisabled() {
        return this.getType() == ClientActivation.Type.VOICE && (Boolean)this.configToggle.value() != false || this.disabled.get();
    }

    @Override
    public int getDistance() {
        return (Integer)this.configDistance.value();
    }

    @Override
    @NotNull
    public ClientActivation.Result process(short[] samples, @Nullable ClientActivation.Result result2) {
        if (this.isDisabled()) {
            if (this.active) {
                this.active = false;
                return ClientActivation.Result.END;
            }
            return ClientActivation.Result.NOT_ACTIVATED;
        }
        if (this.getType() == ClientActivation.Type.PUSH_TO_TALK) {
            return this.handlePTT();
        }
        if (this.getType() == ClientActivation.Type.VOICE) {
            return this.handleVoice(samples, result2);
        }
        if (this.getType() == ClientActivation.Type.INHERIT) {
            return this.handleInherit(result2);
        }
        return ClientActivation.Result.NOT_ACTIVATED;
    }

    @Override
    public void reset() {
        this.active = false;
        this.lastActivation = 0L;
    }

    @Override
    public void cleanup() {
        this.getMonoEncoder().ifPresent(AudioEncoder::close);
        this.getStereoEncoder().ifPresent(AudioEncoder::close);
        ((Hotkey)this.toggleKey.value()).clearPressListener();
        ((Hotkey)this.distanceIncreaseKey.value()).clearPressListener();
        ((Hotkey)this.distanceDecreaseKey.value()).clearPressListener();
        this.configDistance.clearChangeListeners();
        this.monoEncoder = null;
        this.stereoEncoder = null;
    }

    @NotNull
    private ClientActivation.Result handlePTT() {
        boolean pressed;
        class_437 currentScreen = class_310.method_1551().field_1755;
        boolean isScreenWithInput = currentScreen instanceof class_408 || currentScreen instanceof class_498;
        boolean bl = pressed = this.getPttKey().isPressed() && !isScreenWithInput;
        if (pressed) {
            if (!this.active) {
                this.active = true;
            }
            this.lastActivation = System.currentTimeMillis();
        } else if (this.active && System.currentTimeMillis() - this.lastActivation > 350L) {
            this.active = false;
            return ClientActivation.Result.END;
        }
        return this.active ? ClientActivation.Result.ACTIVATED : ClientActivation.Result.NOT_ACTIVATED;
    }

    @NotNull
    private ClientActivation.Result handleVoice(short[] samples, @Nullable ClientActivation.Result result2) {
        if (((Boolean)this.configToggle.value()).booleanValue()) {
            if (this.active) {
                this.active = false;
                return ClientActivation.Result.END;
            }
            return ClientActivation.Result.NOT_ACTIVATED;
        }
        if (result2 != null) {
            if (result2 == ClientActivation.Result.ACTIVATED) {
                this.active = true;
                this.lastActivation = System.currentTimeMillis();
                return result2;
            }
            if (result2 == ClientActivation.Result.END) {
                this.active = false;
                return result2;
            }
        }
        boolean lastActivated = System.currentTimeMillis() - this.lastActivation <= 500L;
        boolean voiceDetected = AudioUtil.containsMinAudioLevel(samples, (double)((Double)this.config.getVoice().getActivationThreshold().value()));
        if (lastActivated || voiceDetected) {
            if (voiceDetected) {
                this.lastActivation = System.currentTimeMillis();
            }
            if (!this.active) {
                this.active = true;
            }
            return ClientActivation.Result.ACTIVATED;
        }
        if (this.active) {
            this.active = false;
            return ClientActivation.Result.END;
        }
        return ClientActivation.Result.NOT_ACTIVATED;
    }

    @NotNull
    private ClientActivation.Result handleInherit(@Nullable ClientActivation.Result result2) {
        if (result2 == null) {
            return ClientActivation.Result.NOT_ACTIVATED;
        }
        if (((Boolean)this.configToggle.value()).booleanValue()) {
            if (this.active) {
                this.active = false;
                return ClientActivation.Result.END;
            }
            return ClientActivation.Result.NOT_ACTIVATED;
        }
        boolean bl = this.active = result2 == ClientActivation.Result.ACTIVATED;
        if (this.active) {
            this.lastActivation = System.currentTimeMillis();
        }
        return result2;
    }

    private void onToggle(@NotNull Hotkey.Action action) {
        if (action != Hotkey.Action.DOWN || this.getType() == ClientActivation.Type.PUSH_TO_TALK) {
            return;
        }
        this.configToggle.invert();
        ClientChatUtil.setActionBar(McTextComponent.translatable("message.plasmovoice.activation.toggle", McTextComponent.translatable(this.translation, new Object[0]), (Boolean)this.configToggle.value() == false ? McTextComponent.translatable("message.plasmovoice.on", new Object[0]) : McTextComponent.translatable("message.plasmovoice.off", new Object[0])));
    }

    private void onDistanceIncrease(@NotNull Hotkey.Action action) {
        if (action != Hotkey.Action.DOWN) {
            return;
        }
        int index = (this.distances.indexOf(this.getDistance()) + 1) % this.distances.size();
        this.configDistance.set((Integer)this.distances.get(index));
        this.sendDistanceChangedMessage();
    }

    private void onDistanceDecrease(@NotNull Hotkey.Action action) {
        if (action != Hotkey.Action.DOWN) {
            return;
        }
        int index = this.distances.indexOf(this.getDistance()) - 1;
        if (index < 0) {
            index = this.distances.size() - 1;
        }
        this.configDistance.set((Integer)this.distances.get(index));
        this.sendDistanceChangedMessage();
    }

    private void onDistanceChange(int distance) {
        this.voiceClient.getServerConnection().ifPresent(connection -> {
            HashMap distanceByActivationId = Maps.newHashMap();
            distanceByActivationId.put(this.id, distance);
            connection.sendPacket(new PlayerActivationDistancesPacket(distanceByActivationId));
        });
    }

    private void sendDistanceChangedMessage() {
        ClientChatUtil.setActionBar(McTextComponent.translatable("message.plasmovoice.distance_changed", McTextComponent.translatable(this.translation, new Object[0]), this.getDistance()));
    }

    private HotkeyConfigEntry createHotKey(@NotNull ConfigHotkeys hotKeys, @NotNull Activation activation, @NotNull String suffix, boolean anyContext) {
        String keyName = "key.plasmovoice." + activation.getName() + "." + suffix;
        Optional<HotkeyConfigEntry> key = hotKeys.getConfigHotkey(keyName);
        if (!key.isPresent()) {
            hotKeys.register(keyName, (List<Hotkey.Key>)ImmutableList.of(), "hidden", anyContext);
            key = hotKeys.getConfigHotkey(keyName);
        }
        if (!key.isPresent()) {
            throw new IllegalStateException("Failed to register keybinding " + activation.getName() + "." + suffix);
        }
        return key.get();
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public long getLastActivation() {
        return this.lastActivation;
    }
}

