/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.render;

import fi.dy.masa.litematica.render.OverlayRenderer;
import fi.dy.masa.litematica.util.BlockInfoAlignment;
import fi.dy.masa.litematica.util.InventoryUtils;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.LeftRight;
import fi.dy.masa.malilib.render.InventoryOverlay;
import fi.dy.masa.malilib.util.GuiUtils;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.malilib.util.data.Color4f;
import fi.dy.masa.malilib.util.game.BlockUtils;
import fi.dy.masa.malilib.util.nbt.NbtBlockUtils;
import fi.dy.masa.malilib.util.position.PositionUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.class_1087;
import net.minecraft.class_10889;
import net.minecraft.class_1263;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5819;
import net.minecraft.class_6575;
import net.minecraft.class_777;
import net.minecraft.class_8887;

public class RenderUtils {
    public static int getMaxStringRenderLength(List<String> list) {
        int length = 0;
        for (String str : list) {
            length = Math.max(length, StringUtils.getStringWidth((String)str));
        }
        return length;
    }

    public static void drawDebugBlockModelOutlinesBatched(List<class_10889> modelParts, class_2680 state, class_2338 pos, Color4f color, double expand, class_287 buffer) {
        for (class_10889 part : modelParts) {
            RenderUtils.drawDebugBlockModelOutlinesBatched(part, state, pos, color, expand, buffer);
        }
    }

    public static void drawDebugBlockModelOutlinesBatched(class_10889 modelPart, class_2680 state, class_2338 pos, Color4f color, double expand, class_287 buffer) {
        for (class_2350 side : PositionUtils.ALL_DIRECTIONS) {
            RenderUtils.renderDebugModelQuadOutlines(modelPart, state, pos, side, color, expand, buffer);
        }
        RenderUtils.renderDebugModelQuadOutlines(modelPart, state, pos, null, color, expand, buffer);
    }

    public static void renderDebugModelQuadOutlines(class_10889 modelPart, class_2680 state, class_2338 pos, class_2350 side, Color4f color, double expand, class_287 buffer) {
        try {
            RenderUtils.renderDebugModelQuadOutlines(pos, buffer, color, modelPart.method_68509(side));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void renderDebugModelQuadOutlines(class_2338 pos, class_287 buffer, Color4f color, List<class_777> quads) {
        int size = quads.size();
        for (int i = 0; i < size; ++i) {
            RenderUtils.renderDebugQuadOutlinesBatched(pos, buffer, color, quads.get(i).comp_3721());
        }
    }

    public static void renderDebugQuadOutlinesBatched(class_2338 pos, class_287 buffer, Color4f color, int[] vertexData) {
        int x = pos.method_10263();
        int y = pos.method_10264();
        int z = pos.method_10260();
        int vertexSize = vertexData.length / 4;
        float[] fx = new float[4];
        float[] fy = new float[4];
        float[] fz = new float[4];
        for (int index = 0; index < 4; ++index) {
            fx[index] = (float)x + Float.intBitsToFloat(vertexData[index * vertexSize]);
            fy[index] = (float)y + Float.intBitsToFloat(vertexData[index * vertexSize + 1]);
            fz[index] = (float)z + Float.intBitsToFloat(vertexData[index * vertexSize + 2]);
        }
        buffer.method_22912(fx[0], fy[0], fz[0]).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(fx[1], fy[1], fz[1]).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(fx[1], fy[1], fz[1]).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(fx[2], fy[2], fz[2]).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(fx[2], fy[2], fz[2]).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(fx[3], fy[3], fz[3]).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(fx[3], fy[3], fz[3]).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(fx[0], fy[0], fz[0]).method_22915(color.r, color.g, color.b, color.a);
    }

    public static void drawBlockModelOutlinesBatched(List<class_10889> modelParts, class_2680 state, class_2338 pos, Color4f color, double expand, class_287 buffer, class_4587 matricies) {
        for (class_10889 part : modelParts) {
            RenderUtils.drawlockModelOutlinesBatched(part, state, pos, color, expand, buffer, matricies);
        }
    }

    public static void drawlockModelOutlinesBatched(class_10889 modelPart, class_2680 state, class_2338 pos, Color4f color, double expand, class_287 buffer, class_4587 matricies) {
        for (class_2350 side : PositionUtils.ALL_DIRECTIONS) {
            RenderUtils.renderModelQuadOutlines(modelPart, state, pos, side, color, expand, buffer, matricies);
        }
        RenderUtils.renderModelQuadOutlines(modelPart, state, pos, null, color, expand, buffer, matricies);
    }

    public static void renderModelQuadOutlines(class_10889 modelPart, class_2680 state, class_2338 pos, class_2350 side, Color4f color, double expand, class_287 buffer, class_4587 matricies) {
        try {
            RenderUtils.renderModelQuadOutlines(pos, buffer, color, modelPart.method_68509(side), matricies);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void renderModelQuadOutlines(class_2338 pos, class_287 buffer, Color4f color, List<class_777> quads, class_4587 matricies) {
        int size = quads.size();
        for (int i = 0; i < size; ++i) {
            RenderUtils.renderQuadOutlinesBatched(pos, buffer, color, quads.get(i).comp_3721(), matricies);
        }
    }

    public static void renderQuadOutlinesBatched(class_2338 pos, class_287 buffer, Color4f color, int[] vertexData, class_4587 matricies) {
        int x = pos.method_10263();
        int y = pos.method_10264();
        int z = pos.method_10260();
        int vertexSize = vertexData.length / 4;
        float[] fx = new float[4];
        float[] fy = new float[4];
        float[] fz = new float[4];
        for (int index = 0; index < 4; ++index) {
            fx[index] = (float)x + Float.intBitsToFloat(vertexData[index * vertexSize]);
            fy[index] = (float)y + Float.intBitsToFloat(vertexData[index * vertexSize + 1]);
            fz[index] = (float)z + Float.intBitsToFloat(vertexData[index * vertexSize + 2]);
        }
        class_4587.class_4665 e = matricies.method_23760();
        buffer.method_56824(e, fx[0], fy[0], fz[0]).method_22915(color.r, color.g, color.b, color.a).method_60831(e, 0.0f, 0.0f, 0.0f);
        buffer.method_56824(e, fx[1], fy[1], fz[1]).method_22915(color.r, color.g, color.b, color.a).method_60831(e, 0.0f, 0.0f, 0.0f);
        buffer.method_56824(e, fx[1], fy[1], fz[1]).method_22915(color.r, color.g, color.b, color.a).method_60831(e, 0.0f, 0.0f, 0.0f);
        buffer.method_56824(e, fx[2], fy[2], fz[2]).method_22915(color.r, color.g, color.b, color.a).method_60831(e, 0.0f, 0.0f, 0.0f);
        buffer.method_56824(e, fx[2], fy[2], fz[2]).method_22915(color.r, color.g, color.b, color.a).method_60831(e, 0.0f, 0.0f, 0.0f);
        buffer.method_56824(e, fx[3], fy[3], fz[3]).method_22915(color.r, color.g, color.b, color.a).method_60831(e, 0.0f, 0.0f, 0.0f);
        buffer.method_56824(e, fx[3], fy[3], fz[3]).method_22915(color.r, color.g, color.b, color.a).method_60831(e, 0.0f, 0.0f, 0.0f);
        buffer.method_56824(e, fx[0], fy[0], fz[0]).method_22915(color.r, color.g, color.b, color.a).method_60831(e, 0.0f, 0.0f, 0.0f);
    }

    public static boolean stateModelHasQuads(class_2680 state) {
        return RenderUtils.modelHasQuads(Objects.requireNonNull(class_310.method_1551().method_1541().method_3349(state)));
    }

    public static boolean modelHasQuads(@Nonnull class_1087 model) {
        return RenderUtils.hasQuads(model.method_68512((class_5819)new class_6575(0L)));
    }

    public static boolean hasQuads(List<class_10889> modelParts) {
        if (modelParts.isEmpty()) {
            return false;
        }
        int totalSize = 0;
        for (class_10889 part : modelParts) {
            for (class_2350 face : PositionUtils.ALL_DIRECTIONS) {
                totalSize += part.method_68509(face).size();
            }
            totalSize += part.method_68509(null).size();
        }
        return totalSize > 0;
    }

    public static void drawBlockModelQuadOverlayBatched(List<class_10889> modelParts, class_2680 state, class_2338 pos, Color4f color, double expand, class_287 buffer) {
        for (class_10889 part : modelParts) {
            RenderUtils.drawBlockModelQuadOverlayBatched(part, state, pos, color, expand, buffer);
        }
    }

    public static void drawBlockModelQuadOverlayBatched(class_10889 modelPart, class_2680 state, class_2338 pos, Color4f color, double expand, class_287 buffer) {
        for (class_2350 side : PositionUtils.ALL_DIRECTIONS) {
            RenderUtils.drawBlockModelQuadOverlayBatched(modelPart, state, pos, side, color, expand, buffer);
        }
        RenderUtils.drawBlockModelQuadOverlayBatched(modelPart, state, pos, null, color, expand, buffer);
    }

    public static void drawBlockModelQuadOverlayBatched(class_10889 modelPart, class_2680 state, class_2338 pos, class_2350 side, Color4f color, double expand, class_287 buffer) {
        RenderUtils.renderModelQuadOverlayBatched(pos, buffer, color, modelPart.method_68509(side));
    }

    private static void renderModelQuadOverlayBatched(class_2338 pos, class_287 buffer, Color4f color, List<class_777> quads) {
        for (class_777 quad : quads) {
            RenderUtils.renderModelQuadOverlayBatched(pos, buffer, color, quad);
        }
    }

    private static void renderModelQuadOverlayBatched(class_2338 pos, class_287 buffer, Color4f color, class_777 quad) {
        int[] vertexData = quad.comp_3721();
        int x = pos.method_10263();
        int y = pos.method_10264();
        int z = pos.method_10260();
        int vertexSize = vertexData.length / 4;
        for (int index = 0; index < 4; ++index) {
            float fx = (float)x + Float.intBitsToFloat(vertexData[index * vertexSize]);
            float fy = (float)y + Float.intBitsToFloat(vertexData[index * vertexSize + 1]);
            float fz = (float)z + Float.intBitsToFloat(vertexData[index * vertexSize + 2]);
            buffer.method_22912(fx, fy, fz).method_22915(color.r, color.g, color.b, color.a);
        }
    }

    public static void drawBlockBoxBatchedQuads(class_2338 pos, Color4f color, double expand, class_287 buffer) {
        for (class_2350 side : PositionUtils.ALL_DIRECTIONS) {
            RenderUtils.drawBlockBoxSideBatchedQuads(pos, side, color, expand, buffer);
        }
    }

    public static void drawBlockBoxSideBatchedQuads(class_2338 pos, class_2350 side, Color4f color, double expand, class_287 buffer) {
        float minX = (float)((double)pos.method_10263() - expand);
        float minY = (float)((double)pos.method_10264() - expand);
        float minZ = (float)((double)pos.method_10260() - expand);
        float maxX = (float)((double)pos.method_10263() + expand + 1.0);
        float maxY = (float)((double)pos.method_10264() + expand + 1.0);
        float maxZ = (float)((double)pos.method_10260() + expand + 1.0);
        switch (side) {
            case field_11033: {
                buffer.method_22912(maxX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(minX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(minX, minY, minZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(maxX, minY, minZ).method_22915(color.r, color.g, color.b, color.a);
                break;
            }
            case field_11036: {
                buffer.method_22912(minX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(maxX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(maxX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(minX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a);
                break;
            }
            case field_11043: {
                buffer.method_22912(maxX, minY, minZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(minX, minY, minZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(minX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(maxX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a);
                break;
            }
            case field_11035: {
                buffer.method_22912(minX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(maxX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(maxX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(minX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a);
                break;
            }
            case field_11039: {
                buffer.method_22912(minX, minY, minZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(minX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(minX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(minX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a);
                break;
            }
            case field_11034: {
                buffer.method_22912(maxX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(maxX, minY, minZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(maxX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(maxX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a);
            }
        }
    }

    public static void drawBlockBoxEdgeBatchedLines(class_2338 pos, class_2350.class_2351 axis, int cornerIndex, Color4f color, class_287 buffer) {
        class_2382 offset = fi.dy.masa.litematica.util.PositionUtils.getEdgeNeighborOffsets(axis, cornerIndex)[cornerIndex];
        double minX = pos.method_10263() + offset.method_10263();
        double minY = pos.method_10264() + offset.method_10264();
        double minZ = pos.method_10260() + offset.method_10260();
        double maxX = pos.method_10263() + offset.method_10263() + (axis == class_2350.class_2351.field_11048 ? 1 : 0);
        double maxY = pos.method_10264() + offset.method_10264() + (axis == class_2350.class_2351.field_11052 ? 1 : 0);
        double maxZ = pos.method_10260() + offset.method_10260() + (axis == class_2350.class_2351.field_11051 ? 1 : 0);
        buffer.method_22912((float)minX, (float)minY, (float)minZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912((float)maxX, (float)maxY, (float)maxZ).method_22915(color.r, color.g, color.b, color.a);
    }

    public static void drawBlockBoxEdgeBatchedDebugLines(class_2338 pos, class_2350.class_2351 axis, int cornerIndex, Color4f color, class_287 buffer) {
        class_2382 offset = fi.dy.masa.litematica.util.PositionUtils.getEdgeNeighborOffsets(axis, cornerIndex)[cornerIndex];
        double minX = pos.method_10263() + offset.method_10263();
        double minY = pos.method_10264() + offset.method_10264();
        double minZ = pos.method_10260() + offset.method_10260();
        double maxX = pos.method_10263() + offset.method_10263() + (axis == class_2350.class_2351.field_11048 ? 1 : 0);
        double maxY = pos.method_10264() + offset.method_10264() + (axis == class_2350.class_2351.field_11052 ? 1 : 0);
        double maxZ = pos.method_10260() + offset.method_10260() + (axis == class_2350.class_2351.field_11051 ? 1 : 0);
        buffer.method_22912((float)minX, (float)minY, (float)minZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912((float)maxX, (float)maxY, (float)maxZ).method_22915(color.r, color.g, color.b, color.a);
    }

    public static int renderInventoryOverlays(class_332 drawContext, BlockInfoAlignment align, int offY, class_1937 worldSchematic, class_1937 worldClient, class_2338 pos, class_310 mc) {
        int heightSch = RenderUtils.renderInventoryOverlay(drawContext, align, LeftRight.LEFT, offY, worldSchematic, pos, mc);
        int heightCli = RenderUtils.renderInventoryOverlay(drawContext, align, LeftRight.RIGHT, offY, worldClient, pos, mc);
        return Math.max(heightSch, heightCli);
    }

    public static int renderInventoryOverlay(class_332 drawContext, BlockInfoAlignment align, LeftRight side, int offY, class_1937 world, class_2338 pos, class_310 mc) {
        InventoryOverlay.Context ctx = InventoryUtils.getTargetInventory(world, pos);
        if (ctx != null && ctx.inv() != null) {
            InventoryOverlay.InventoryProperties props = InventoryOverlay.getInventoryPropsTemp((InventoryOverlay.InventoryRenderType)ctx.type(), (int)ctx.inv().method_5439());
            if (ctx.type() == InventoryOverlay.InventoryRenderType.CRAFTER) {
                HashSet<Integer> disabledSlots = new HashSet();
                if (ctx.nbt() != null && !ctx.nbt().method_33133()) {
                    disabledSlots = NbtBlockUtils.getDisabledSlotsFromNbt((class_2487)ctx.nbt());
                } else {
                    class_2586 class_25862 = ctx.be();
                    if (class_25862 instanceof class_8887) {
                        class_8887 cbe = (class_8887)class_25862;
                        disabledSlots = BlockUtils.getDisabledSlots((class_8887)cbe);
                    }
                }
                return RenderUtils.renderInventoryOverlay(drawContext, align, side, offY, ctx.inv(), ctx.type(), props, disabledSlots, mc);
            }
            return RenderUtils.renderInventoryOverlay(drawContext, align, side, offY, ctx.inv(), ctx.type(), props, mc);
        }
        return 0;
    }

    public static int renderInventoryOverlay(class_332 drawContext, BlockInfoAlignment align, LeftRight side, int offY, class_1263 inv, InventoryOverlay.InventoryRenderType type, InventoryOverlay.InventoryProperties props, class_310 mc) {
        return RenderUtils.renderInventoryOverlay(drawContext, align, side, offY, inv, type, props, Set.of(), mc);
    }

    public static int renderInventoryOverlay(class_332 drawContext, BlockInfoAlignment align, LeftRight side, int offY, class_1263 inv, InventoryOverlay.InventoryRenderType type, InventoryOverlay.InventoryProperties props, Set<Integer> disabledSlots, class_310 mc) {
        int xInv = 0;
        int yInv = 0;
        int compatShift = OverlayRenderer.calculateCompatYShift();
        switch (align) {
            case CENTER: {
                xInv = GuiUtils.getScaledWindowWidth() / 2 - props.width / 2;
                yInv = GuiUtils.getScaledWindowHeight() / 2 - props.height - offY;
                break;
            }
            case TOP_CENTER: {
                xInv = GuiUtils.getScaledWindowWidth() / 2 - props.width / 2;
                yInv = offY + compatShift;
            }
        }
        if (side == LeftRight.LEFT) {
            xInv -= props.width / 2 + 4;
        } else if (side == LeftRight.RIGHT) {
            xInv += props.width / 2 + 4;
        }
        InventoryOverlay.renderInventoryBackground((class_332)drawContext, (InventoryOverlay.InventoryRenderType)type, (int)xInv, (int)yInv, (int)props.slotsPerRow, (int)props.totalSlots, (class_310)mc);
        InventoryOverlay.renderInventoryStacks((class_332)drawContext, (InventoryOverlay.InventoryRenderType)type, (class_1263)inv, (int)(xInv + props.slotOffsetX), (int)(yInv + props.slotOffsetY), (int)props.slotsPerRow, (int)0, (int)inv.method_5439(), disabledSlots, (class_310)mc);
        return props.height + compatShift;
    }

    public static void renderBackgroundMask(class_332 drawContext, int startX, int startY, int width, int height) {
        fi.dy.masa.malilib.render.RenderUtils.drawTexturedRect((class_332)drawContext, (class_2960)GuiBase.BG_TEXTURE, (int)startX, (int)startY, (int)0, (int)0, (int)width, (int)height);
    }

    public static void drawBlockBoundingBoxOutlinesBatchedDebugLines(class_2338 pos, Color4f color, double expand, class_287 buffer) {
        RenderUtils.drawBoxAllEdgesBatchedDebugLines(pos, class_243.field_1353, color, expand, buffer);
    }

    public static void drawBoxAllEdgesBatchedDebugLines(class_2338 pos, class_243 cameraPos, Color4f color, double expand, class_287 buffer) {
        float minX = (float)((double)pos.method_10263() - expand - cameraPos.field_1352);
        float minY = (float)((double)pos.method_10264() - expand - cameraPos.field_1351);
        float minZ = (float)((double)pos.method_10260() - expand - cameraPos.field_1350);
        float maxX = (float)((double)pos.method_10263() + expand - cameraPos.field_1352 + 1.0);
        float maxY = (float)((double)pos.method_10264() + expand - cameraPos.field_1351 + 1.0);
        float maxZ = (float)((double)pos.method_10260() + expand - cameraPos.field_1350 + 1.0);
        RenderUtils.drawBoxAllEdgesBatchedDebugLines(minX, minY, minZ, maxX, maxY, maxZ, color, buffer);
    }

    public static void drawBoxAllEdgesBatchedDebugLines(float minX, float minY, float minZ, float maxX, float maxY, float maxZ, Color4f color, class_287 buffer) {
        buffer.method_22912(minX, minY, minZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(minX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(minX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(minX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(minX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(minX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(minX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(minX, minY, minZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(maxX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(maxX, minY, minZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(maxX, minY, minZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(maxX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(maxX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(maxX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(maxX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(maxX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(maxX, minY, minZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(minX, minY, minZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(minX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(maxX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(minX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(maxX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(maxX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(minX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a);
    }
}

